ORCA/M Asm65816 2.1.0

0001 D000              ;====================================================================================================
0002 D000              ;clear_handles: This routine will zero any local handles that contain a copy of the
0003 D000              ;               handle that we are disposing
0004 D000              ;
0005 D000              ;Input:         A = undefined
0006 D000              ;               X = undefined
0007 D000              ;               Y = undefined
0008 D000              ;               P = nvmxdizc
0009 D000              ;                   ..000...
0010 D000              ;               b = k
0011 D000              ;
0012 D000              ;               stack:
0013 D000              ;
0014 D000              ;                       Y register              $1,s
0015 D000              ;                       X register              $3,s
0016 D000              ;                       Accum                   $5,s
0017 D000              ;                       processor_status        $7,s
0018 D000              ;                       return address          $8,s
0019 D000              ;                       low word of handle      $A,s
0020 D000              ;                       high word of handle     $C,s
0021 D000              ;
0022 D000              ;Output:        A = restored
0023 D000              ;               X = restored
0024 D000              ;               Y = restored
0025 D000              ;               P = nvmxdizc
0026 D000              ;                   ..000...
0027 D000              ;               b = k
0028 D000              ;
0029 D000              ;
0030 D000              ;
0031 D000              ;====================================================================================================
0032 D000              clear_handles proc 
0033 D000                       with DirectPage
0034 D000
0035 D000 08                    php   
0036 D001 48                    pha   
0037 D002 DA                    phx   
0038 D003 5A                    phy   
0039 D004
0040 D004 A3 0A                 lda   $0A,s                    ;get the low word of the handle
0041 D006 AA                    tax   
0042 D007 A3 0C                 lda   $0C,s                    ;get the high word of the handle
0043 D009
0044 D009 C5 8A                 cmp   ExpressHandle+2
0045 D00B D0 08                 bne   @skip_express            ;Does Express = Dispose Handle?
0046 D00D E4 88                 cpx   ExpressHandle
0047 D00F D0 04                 bne   @skip_express
0048 D011
0049 D011 64 88                 stz   ExpressHandle            ;zero matching handle
0050 D013 64 8A                 stz   ExpressHandle+2
0051 D015
0052 D015              @skip_express  
0053 D015 C5 46                 cmp   temp_handle
0054 D017 D0 08                 bne   @skip_temp
0055 D019 E4 48                 cpx   temp_handle+2
0056 D01B D0 04                 bne   @skip_temp
0057 D01D
0058 D01D 64 46                 stz   temp_handle
0059 D01F 64 48                 stz   temp_handle+2
0060 D021
0061 D021              @skip_temp  
0062 D021 C5 90                 cmp   reloc_handle
0063 D023 D0 08                 bne   @skip_reloc
0064 D025 E4 92                 cpx   reloc_handle+2
0065 D027 D0 04                 bne   @skip_reloc
0066 D029
0067 D029 64 90                 stz   reloc_handle
0068 D02B 64 92                 stz   reloc_handle+2
0069 D02D
0070 D02D              @skip_reloc  
0071 D02D C5 94                 cmp   seg_handle
0072 D02F D0 08                 bne   @skip_seg
0073 D031 E4 96                 cpx   seg_handle+2
0074 D033 D0 04                 bne   @skip_seg
0075 D035
0076 D035 64 94                 stz   seg_handle
0077 D037 64 96                 stz   seg_handle+2
0078 D039
0079 D039              @skip_seg  
0080 D039 C5 98                 cmp   curr_id_handle
0081 D03B D0 08                 bne   @skip_id
0082 D03D E4 9A                 cpx   curr_id_handle+2
0083 D03F D0 04                 bne   @skip_id
0084 D041
0085 D041 64 98                 stz   curr_id_handle
0086 D043 64 9A                 stz   curr_id_handle+2
0087 D045              @skip_id  
0088 D045 7A                    ply   
0089 D046 FA                    plx   
0090 D047 68                    pla   
0091 D048 28                    plp   
0092 D049 60                    rts   
0093 D04A                       endp 
0094 D04A
0095 D04A                       TITLE ', ExpressLoad.a - alloc_ExpLoad'
0096 D04A              ;====================================================================================================
0097 D04A              ;alloc_ExpLoad: This routine will allocate memory from the system for the loader.
0098 D04A              ;
0099 D04A              ;Input:         A = undefined
0100 D04A              ;               X = request bytes low
0101 D04A              ;               Y = requets bytes high
0102 D04A              ;               P = nvmxdizc
0103 D04A              ;                   ..000...
0104 D04A              ;               b = k
0105 D04A              ;
0106 D04A              ;
0107 D04A              ;Output:        A = undefined
0108 D04A              ;               X = handle low
0109 D04A              ;               Y = handle high
0110 D04A              ;               P = nvmxdizc
0111 D04A              ;                   ..000..
0112 D04A              ;               b = k
0113 D04A              ;
0114 D04A              ;
0115 D04A              ;====================================================================================================
0116 D04A
0117 D04A                       longa on
0118 D04A                       longi on
0119 D04A              alloc_ExpLoad proc 
0120 D04A                       with DirectPage, Globals
0121 D04A
0122 D04A A9 01 71              lda   #uExpressSegment         ;my ID
0123 D04D 80 03                 bra   do_alloc                 ;go allocate
0124 D04F
0125 D04F              ;====================================================================================================
0126 D04F              ;alloc_mem:     This routine will allocate memory from the system.
0127 D04F              ;
0128 D04F              ;Input:         A = user ID to use
0129 D04F              ;               X = request bytes low
0130 D04F              ;               Y = requets bytes high
0131 D04F              ;               P = nvmxdizc
0132 D04F              ;                   ..000...
0133 D04F              ;               b = k
0134 D04F              ;
0135 D04F              ;
0136 D04F              ;Output:        A = undefined
0137 D04F              ;               X = handle low
0138 D04F              ;               Y = handle high
0139 D04F              ;               P = nvmxdizc
0140 D04F              ;                   ..000..
0141 D04F              ;               b = k
0142 D04F              ;
0143 D04F              ;
0144 D04F              ;====================================================================================================
0145 D04F
0146 D04F                       entry alloc_mem, do_alloc
0147 D04F              alloc_mem  
0148 D04F AD B6 A6              lda   |USERID                  ;use application ID for normal allocation
0149 D052              do_alloc  
0150 D052 48                    pha                            ;space for handle
0151 D053 48                    pha   
0152 D054 5A                    phy                            ;high request bytes
0153 D055 DA                    phx                            ;low request bytes
0154 D056 48                    pha                            ;userID
0155 D057 F4 00 80              pea   attrLocked               ;locked
0156 D05A A9 00 00              lda   #0
0157 D05D 48                    pha   
0158 D05E 48                    pha   
0159 D05F 20 62 BA              jsr   lock_handles             ;lock my handles so they stay put!!
0160 D062 A2 02 09 22           _NewHandle                     ;allocate the memory
0161 D069 20 CB BA              jsr   unlock_handles           ;put the handles back to original state
0162 D06C FA                    plx   
0163 D06D 7A                    ply   
0164 D06E 60                    rts   
0165 D06F                       endp 
0166 D06F
0167 D06F                       TITLE ', ExpressLoad.a - alloc_my_dp'
0168 D06F              ;====================================================================================================
0169 D06F              ;alloc_my_dp:   This routine will allocate my direct page from the system.
0170 D06F              ;
0171 D06F              ;Input:         A = undefined
0172 D06F              ;               X = undefined
0173 D06F              ;               Y = undefined
0174 D06F              ;               P = nvmxdizc
0175 D06F              ;                   ..000...
0176 D06F              ;               b = k
0177 D06F              ;
0178 D06F              ;
0179 D06F              ;Output:        A = undefined
0180 D06F              ;               X = undefined
0181 D06F              ;               Y = undefined
0182 D06F              ;               P = nvmxdizc
0183 D06F              ;                   ..000..
0184 D06F              ;               b = k
0185 D06F              ;
0186 D06F              ;
0187 D06F              ;====================================================================================================
0188 D06F
0189 D06F                       longa on
0190 D06F                       longi on
0191 D06F              alloc_my_dp proc 
0192 D06F                       with Globals
0193 D06F                       Import DeRef
0194 D06F
0195 D06F A9 00 00              lda   #0
0196 D072 48                    pha                            ;space for handle
0197 D073 48                    pha   
0198 D074 48                    pha                            ;request bytes
0199 D075 F4 00 01              pea   256
0200 D078 F4 01 7F              pea   uDirectPage              ;userID
0201 D07B F4 05 80              pea   #attr_locked+attr_bank+attr_page
0202 D07E 48                    pha                            ;MUST be in bank 0
0203 D07F 48                    pha   
0204 D080 A2 02 09 22           _NewHandle 
0205 D087 FA                    plx   
0206 D088 7A                    ply                            ;get the handle
0207 D089 8E 8E A6              stx   dp_handle                ;save my handle please
0208 D08C 8C 90 A6              sty   dp_handle+2
0209 D08F B0 08                 bcs   @oops
0210 D091 8A                    txa                            ;put low word into accumulator
0211 D092 20 D6 FA              jsr   DeRef                    ;get the pointer to the direct page
0212 D095 8D 92 A6              sta   my_dir_page
0213 D098 5B                    tcd                            ;go ahead and setup the direct register
0214 D099              @oops     
0215 D099 60                    rts                            ;and return it
0216 D09A                       endp 
0217 D09A
0218 D09A                       TITLE ', ExpressLoad.a - alloc_LConst_seg'
0219 D09A              ;====================================================================================================
0220 D09A              ;alloc_LConst_seg       This routine will allocate memory from the system.
0221 D09A              ;
0222 D09A              ;Input:         A = undefined
0223 D09A              ;               X = request bytes low
0224 D09A              ;               Y = requets bytes high
0225 D09A              ;               P = nvmxdizc
0226 D09A              ;                   ..000...
0227 D09A              ;               b = k
0228 D09A              ;
0229 D09A              ;               seg_header_ptr          ;must be setup
0230 D09A              ;
0231 D09A              ;Output:        A = undefined
0232 D09A              ;               X = handle low
0233 D09A              ;               Y = handle high
0234 D09A              ;               P = nvmxdizc
0235 D09A              ;                   ..000..
0236 D09A              ;               b = k
0237 D09A              ;
0238 D09A              ;
0239 D09A              ;====================================================================================================
0240 D09A
0241 D09A                       longa on
0242 D09A                       longi on
0243 D09A              alloc_LConst_seg proc  
0244 D09A                       with DirectPage, Globals
0245 D09A
0246 D09A 20 62 BA              jsr   lock_handles
0247 D09D
0248 D09D A5 D8                 lda   mem_attr                 ;see if this is bank aligned or align in bank
0249 D09F 29 60 00              and   #attr_bank_align+attr_align_in_bank
0250 D0A2 D0 1E                 bne   @align_to_bank
0251 D0A4
0252 D0A4 48                    pha                            ;space for handle
0253 D0A5 48                    pha   
0254 D0A6 5A                    phy                            ;high request bytes
0255 D0A7 DA                    phx                            ;low request bytes
0256 D0A8 AD B6 A6              lda   |USERID
0257 D0AB 48                    pha   
0258 D0AC A5 D8                 lda   mem_attr
0259 D0AE 48                    pha   
0260 D0AF A5 C2                 lda   org_address+2
0261 D0B1 48                    pha   
0262 D0B2 A5 C0                 lda   org_address              ;address to start at
0263 D0B4 48                    pha   
0264 D0B5 A2 02 09 22           _NewHandle 
0265 D0BC 20 CB BA              jsr   unlock_handles           ;put the handles back to original state
0266 D0BF
0267 D0BF FA                    plx   
0268 D0C0 7A                    ply   
0269 D0C1 60                    rts   
0270 D0C2
0271 D0C2              @align_to_bank  
0272 D0C2 86 D4                 stx   free_mem_size            ;save the request count
0273 D0C4 84 D6                 sty   free_mem_size+2
0274 D0C6
0275 D0C6 A5 D8                 lda   mem_attr                 ;clear the align to bank bit
0276 D0C8 29 9F FF              and   #~(attr_bank_align+attr_align_in_bank)
0277 D0CB 85 D8                 sta   mem_attr
0278 D0CD
0279 D0CD A9 02 00              lda   #$0002                   ;start looking in bank two
0280 D0D0 85 BE                 sta   search_addr+2            ;address we are searching for
0281 D0D2 A5 C0                 lda   org_address              ;add in org. align in bank if non zero
0282 D0D4 85 BC                 sta   search_addr
0283 D0D6
0284 D0D6 48                    pha                            ;space for handle
0285 D0D7 48                    pha   
0286 D0D8 A2 00 00              ldx   #$0000                   ;convenient place for a zero
0287 D0DB F4 01 00              pea   $0001                    ;allocate 64K
0288 D0DE DA                    phx   
0289 D0DF AD B6 A6              lda   |USERID                  ;use App's ID
0290 D0E2 48                    pha   
0291 D0E3 A5 D8                 lda   mem_attr                 ;attributes
0292 D0E5 29 FC FF              and   #~(attr_bank+attr_addr)
0293 D0E8 09 18 00              ora   #attr_no_spec+attr_no_cross
0294 D0EB 48                    pha   
0295 D0EC DA                    phx                            ;location pointer
0296 D0ED DA                    phx   
0297 D0EE A2 02 09 22           _NewHandle                     ;allocate the memory
0298 D0F5 FA                    plx                            ;retrieve handle
0299 D0F6 7A                    ply   
0300 D0F7 B0 17                 bcs   @no_memory               ;oops!  couldn't get a whole bank!
0301 D0F9 8B                    phb                            ;save current DBR
0302 D0FA 5A                    phy                            ;set to handle's DBR
0303 D0FB AB                    plb   
0304 D0FC E8                    inx                            ;bump to bank word of handle
0305 D0FD E8                    inx   
0306 D0FE BD 00 00              lda   |0,x                     ;get the bank # that was allocated
0307 D101 AB                    plb   
0308 D102 AB                    plb                            ;restore DBR
0309 D103 85 BE                 sta   search_addr+2            ;save the bank value
0310 D105 CA                    dex                            ;restore original value
0311 D106 CA                    dex   
0312 D107 5A                    phy   
0313 D108 DA                    phx                            ;now deallocate the bank again
0314 D109 A2 02 10 22           _DisposeHandle 
0315 D110
0316 D110              @no_memory  
0317 D110 A9 03 00              lda   #attr_addr+attr_bank     ;set the fixed address and bank bits
0318 D113 04 D8                 tsb   mem_attr
0319 D115
0320 D115              @search_loop  
0321 D115 48                    pha                            ;space for handle
0322 D116 48                    pha   
0323 D117 A5 D6                 lda   free_mem_size+2
0324 D119 48                    pha   
0325 D11A A5 D4                 lda   free_mem_size
0326 D11C 48                    pha   
0327 D11D AD B6 A6              lda   |USERID
0328 D120 48                    pha   
0329 D121 A5 D8                 lda   mem_attr
0330 D123 48                    pha   
0331 D124 A5 BE                 lda   search_addr+2            ;address to start at
0332 D126 48                    pha   
0333 D127 A5 BC                 lda   search_addr
0334 D129 48                    pha   
0335 D12A A2 02 09 22           _NewHandle 
0336 D131 FA                    plx   
0337 D132 7A                    ply                            ;get the handle
0338 D133 90 0C                 bcc   @done                    ;if no error, return!
0339 D135              @not_done  
0340 D135 E6 BE                 inc   search_addr+2
0341 D137 A5 BE                 lda   search_addr+2            ;move up one bank
0342 D139 C9 80 00              cmp   #$0080                   ;have we searched all of memory?
0343 D13C 90 D7                 bcc   @search_loop
0344 D13E A9 01 02              lda   #$0201                   ;synthesize a Memory Manager error
0345 D141                                                      ;(carry already set)
0346 D141 20 CB BA     @done    jsr   unlock_handles
0347 D144 60                    rts                            ;return the handle
0348 D145
0349 D145                       endp 
0350 D145
0351 D145                       TITLE ', ExpressLoad.a - add_id_table'
0352 D145              ;====================================================================================================
0353 D145              ;add_id_table:  This routine will allocate memory for one user_id_table and link the table
0354 D145              ;               into the list of user_id_tables.  It will also zero the entire table
0355 D145              ;
0356 D145              ;
0357 D145              ;Input:         A = undefined
0358 D145              ;               X = undefined
0359 D145              ;               Y = undefined
0360 D145              ;               P = nvmxdizc
0361 D145              ;                   ..000...
0362 D145              ;               b = k
0363 D145              ;
0364 D145              ;
0365 D145              ;Output:        A = undefined
0366 D145              ;               X = undefined
0367 D145              ;               Y = undefined
0368 D145              ;               P = nvmxdizc
0369 D145              ;                   ..000..1 = error
0370 D145              ;               b = k
0371 D145              ;
0372 D145              ;
0373 D145              ;====================================================================================================
0374 D145
0375 D145                       longa on
0376 D145                       longi on
0377 D145              add_id_table proc 
0378 D145                       with DirectPage, Globals
0379 D145
0380 D145 A2 00 08              ldx   #id_tbl_size             ;allocate the table please
0381 D148 A0 00 00              ldy   #$0000
0382 D14B A9 01 72              lda   #uUserIDTable            ;ID to use for the user id table
0383 D14E 20 52 D0              jsr   do_alloc                 ;go and allocate memory
0384 D151 B0 38                 bcs   @oops
0385 D153
0386 D153 86 46                 stx   temp_handle              ;save the handle please
0387 D155 86 80                 stx   temp_long
0388 D157 84 48                 sty   temp_handle+2
0389 D159 84 82                 sty   temp_long+2
0390 D15B
0391 D15B A0 04 00              ldy   #$0004                   ;offset to memory manager attributes
0392 D15E B7 46                 lda   [temp_handle],y
0393 D160 29 FF 7F              and   #$7FFF                   ;unlock the handle
0394 D163 97 46                 sta   [temp_handle],y
0395 D165
0396 D165 A0 02 00              ldy   #$0002                   ;make a pointer to new memory
0397 D168 A7 46                 lda   [temp_handle]
0398 D16A 85 7C                 sta   user_id_ptr
0399 D16C B7 46                 lda   [temp_handle],y
0400 D16E 85 7E                 sta   user_id_ptr+2
0401 D170
0402 D170 A9 00 00              lda   #$0000
0403 D173 A0 FE 07              ldy   #id_tbl_size-2           ;clear the buffer please
0404 D176              @clear_loop  
0405 D176 97 7C                 sta   [user_id_ptr],y
0406 D178 88                    dey   
0407 D179 88                    dey   
0408 D17A 10 FA                 bpl   @clear_loop
0409 D17C              ;
0410 D17C              ;Now that we have cleared the segment lets link it into the list
0411 D17C              ;
0412 D17C A5 78                 lda   user_id_handle           ;see if this is the first one!
0413 D17E 05 7A                 ora   user_id_handle+2
0414 D180 D0 0A                 bne   @walk_list
0415 D182
0416 D182 A5 46                 lda   temp_handle              ;setup the first handle and exit
0417 D184 85 78                 sta   user_id_handle
0418 D186 A5 48                 lda   temp_handle+2
0419 D188 85 7A                 sta   user_id_handle+2
0420 D18A 18                    clc   
0421 D18B              @oops     
0422 D18B 60                    rts   
0423 D18C
0424 D18C              @walk_list  
0425 D18C A5 78                 lda   user_id_handle           ;start at front of the list
0426 D18E 85 46                 sta   temp_handle
0427 D190 A5 7A                 lda   user_id_handle+2
0428 D192 85 48                 sta   temp_handle+2
0429 D194              @search_loop  
0430 D194 A0 02 00              ldy   #$0002
0431 D197 A7 46                 lda   [temp_handle]
0432 D199 85 7C                 sta   user_id_ptr
0433 D19B B7 46                 lda   [temp_handle],y
0434 D19D 85 7E                 sta   user_id_ptr+2
0435 D19F
0436 D19F A7 7C                 lda   [user_id_ptr]            ;get the forward link please (Link = Handle)
0437 D1A1 85 46                 sta   temp_handle
0438 D1A3 B7 7C                 lda   [user_id_ptr],y
0439 D1A5 85 48                 sta   temp_handle+2
0440 D1A7 05 46                 ora   temp_handle
0441 D1A9 D0 E9                 bne   @search_loop
0442 D1AB
0443 D1AB A0 02 00              ldy   #User_ID_Table.Next+2    ;link in the new entry
0444 D1AE A5 80                 lda   temp_long                ;handle to our new segment
0445 D1B0 87 7C                 sta   [user_id_ptr]
0446 D1B2 A5 82                 lda   temp_long+2
0447 D1B4 97 7C                 sta   [user_id_ptr],y
0448 D1B6
0449 D1B6 A7 80                 lda   [temp_long]              ;deref handle
0450 D1B8 85 7C                 sta   user_id_ptr
0451 D1BA B7 80                 lda   [temp_long],y
0452 D1BC 85 7E                 sta   user_id_ptr+2
0453 D1BE
0454 D1BE 18                    clc   
0455 D1BF 60                    rts   
0456 D1C0
0457 D1C0                       endp 
0458 D1C0
0459 D1C0                       TITLE ', ExpressLoad.a - reset_local_mark'
0460 D1C0              ;====================================================================================================
0461 D1C0              ;reset_local_mark:      This routine will reset our local mark to $FFFFFF.
0462 D1C0              ;
0463 D1C0              ;Input:         A = undefined
0464 D1C0              ;               X = undefined
0465 D1C0              ;               Y = undefined
0466 D1C0              ;               P = nvmxdizc
0467 D1C0              ;                   ..000...
0468 D1C0              ;               b = k
0469 D1C0              ;
0470 D1C0              ;
0471 D1C0              ;Output:        A = preserved
0472 D1C0              ;               X = preserved
0473 D1C0              ;               Y = preserved
0474 D1C0              ;               P = preserved
0475 D1C0              ;               b = k
0476 D1C0              ;
0477 D1C0              ;
0478 D1C0              ;
0479 D1C0              ;====================================================================================================
0480 D1C0
0481 D1C0                       longa on
0482 D1C0                       longi on
0483 D1C0              reset_local_mark proc  
0484 D1C0                       with DirectPage, Globals
0485 D1C0 A9 FF FF              lda   #$FFFF
0486 D1C3 85 A6                 sta   local_mark
0487 D1C5 85 A8                 sta   local_mark+2
0488 D1C7 60                    rts   
0489 D1C8                       endp 
0490 D1C8
0491 D1C8                       TITLE ', ExpressLoad.a - seg_num_lookup'
0492 D1C8              ;====================================================================================================
0493 D1C8              ;seg_num_lookup:        This routine will take a segment number and convert the number
0494 D1C8              ;                       to the correct segment number via the segment conversion table
0495 D1C8              ;
0496 D1C8              ;Input:         A = original segment number
0497 D1C8              ;               X = undefined
0498 D1C8              ;               Y = undefined
0499 D1C8              ;               P = nvmxdizc
0500 D1C8              ;                   ..000...
0501 D1C8              ;               b = k
0502 D1C8              ;
0503 D1C8              ;               HET_ptr         ;must point to seg_num_count
0504 D1C8              ;
0505 D1C8              ;Output:        A = new segment number
0506 D1C8              ;               X = preserved
0507 D1C8              ;               Y = preserved
0508 D1C8              ;               P = nvmxdizc
0509 D1C8              ;                   ..000..1=error
0510 D1C8              ;               b = k
0511 D1C8              ;
0512 D1C8              ;
0513 D1C8              ;
0514 D1C8              ;====================================================================================================
0515 D1C8
0516 D1C8                       longa on
0517 D1C8                       longi on
0518 D1C8              seg_num_lookup proc 
0519 D1C8                       with DirectPage, Globals
0520 D1C8
0521 D1C8 AA                    tax   
0522 D1C9 F0 24                 beq   @bad_seg_num             ;sorry bud
0523 D1CB 3A                    dec   a                        ;make zero based
0524 D1CC C7 3E                 cmp   [HET_ptr]                ;is it in the range?
0525 D1CE F0 02                 beq   @num_OK
0526 D1D0 B0 1D                 bcs   @bad_seg_num             ;sorry the segment number is no good
0527 D1D2              @num_OK   
0528 D1D2 18                    clc   
0529 D1D3 A7 3E                 lda   [HET_ptr]                ;get the number of segments please
0530 D1D5 1A                    inc   a                        ;add one for 0 based stuff
0531 D1D6 0A                    asl   a
0532 D1D7 0A                    asl   a
0533 D1D8 0A                    asl   a                        ;times 8 to pass Header Entry table
0534 D1D9 69 02 00              adc   #$0002                   ;pass the count please
0535 D1DC
0536 D1DC 65 3E                 adc   HET_ptr                  ;add current position
0537 D1DE 85 62                 sta   temp_ptr
0538 D1E0 A9 00 00              lda   #$0000
0539 D1E3 65 40                 adc   HET_ptr+2
0540 D1E5 85 64                 sta   temp_ptr+2               ;Temp pointer now points to the segment conv tbl
0541 D1E7
0542 D1E7 CA                    dex                            ;subtract one for zero based please
0543 D1E8 8A                    txa                            ;Times two for word table
0544 D1E9 0A                    asl   a
0545 D1EA A8                    tay                            ;index to the real segment number
0546 D1EB B7 62                 lda   [temp_ptr],y
0547 D1ED 18                    clc   
0548 D1EE 60                    rts                            ;return with the new segment number in "A"
0549 D1EF
0550 D1EF              @bad_seg_num  
0551 D1EF A9 01 11              lda   #seg_not_found
0552 D1F2 38                    sec   
0553 D1F3 60                    rts                            ;return the "Error"
0554 D1F4                       endp 
0555 D1F4
0556 D1F4                       TITLE ', ExpressLoad.a - my_seg_to_user_seg'
0557 D1F4              ;====================================================================================================
0558 D1F4              ;my_seg_to_user_seg:    This routine will take my segment number and convert the number
0559 D1F4              ;                       to the correct segment number via the segment conversion table.
0560 D1F4              ;                       This means if you use the segment number returned to you as input
0561 D1F4              ;                       to another loader call then everything will workout OK.
0562 D1F4              ;
0563 D1F4              ;Input:         A = internal segment number
0564 D1F4              ;               X = undefined
0565 D1F4              ;               Y = undefined
0566 D1F4              ;               P = nvmxdizc
0567 D1F4              ;                   ..000...
0568 D1F4              ;               b = k
0569 D1F4              ;
0570 D1F4              ;               HET_ptr         ;must point to seg_num_count
0571 D1F4              ;
0572 D1F4              ;Output:        A = new segment number for user
0573 D1F4              ;               X = preserved
0574 D1F4              ;               Y = preserved
0575 D1F4              ;               P = nvmxdizc
0576 D1F4              ;                   ..000..1=error
0577 D1F4              ;               b = k
0578 D1F4              ;
0579 D1F4              ;
0580 D1F4              ;
0581 D1F4              ;====================================================================================================
0582 D1F4
0583 D1F4                       longa on
0584 D1F4                       longi on
0585 D1F4              my_seg_to_user_seg proc  
0586 D1F4                       with DirectPage, Globals
0587 D1F4
0588 D1F4 48                    pha                            ;segment we need to find
0589 D1F5
0590 D1F5 18                    clc   
0591 D1F6 A7 3E                 lda   [HET_ptr]                ;get the number of segments please
0592 D1F8 1A                    inc   a                        ;add one for 0 based stuff
0593 D1F9 0A                    asl   a
0594 D1FA 0A                    asl   a
0595 D1FB 0A                    asl   a                        ;times 8 to pass Header Entry table
0596 D1FC 69 02 00              adc   #$0002                   ;pass the count please
0597 D1FF
0598 D1FF              ;        clc
0599 D1FF
0600 D1FF 65 3E                 adc   HET_ptr                  ;add current position
0601 D201 85 62                 sta   temp_ptr
0602 D203 A9 00 00              lda   #$0000
0603 D206 65 40                 adc   HET_ptr+2
0604 D208 85 64                 sta   temp_ptr+2               ;Temp pointer now points to the segment conv tbl
0605 D20A
0606 D20A A0 00 00              ldy   #$0000
0607 D20D 68                    pla                            ;retrieve comparison value
0608 D20E              @look_loop  
0609 D20E D7 62                 cmp   [temp_ptr],y             ;is this the correct segment number?
0610 D210 F0 09                 beq   @have_segment
0611 D212 C8                    iny   
0612 D213 C8                    iny   
0613 D214 D0 F8                 bne   @look_loop
0614 D216
0615 D216 A9 01 11              lda   #seg_not_found
0616 D219 38                    sec   
0617 D21A 60                    rts                            ;return the "Error"
0618 D21B
0619 D21B 98           @have_segment tya                       ;convert index to segment number
0620 D21C 4A                    lsr   a
0621 D21D 1A                    inc   a                        ;add one to convert from 0 to 1 based
0622 D21E 18                    clc   
0623 D21F 60                    rts   
0624 D220                       endp 
0625 D220
0626 D220                       TITLE ', ExpressLoad.a - error_routine'
0627 D220              ;====================================================================================================
0628 D220              ;Error_routine: This routine will call the death manager with an error code.  The routine will not
0629 D220              ;               return to the caller.  The routine is called with a JSR so I can display the
0630 D220              ;               address if I want to.
0631 D220              ;
0632 D220              ;Input:         A = error_code
0633 D220              ;               X = undefined
0634 D220              ;               Y = undefined
0635 D220              ;               P = nvmxdizc
0636 D220              ;                   ..000...
0637 D220              ;               b = k
0638 D220              ;
0639 D220              ;
0640 D220              ;Output:        A = undefined
0641 D220              ;               X = undefined
0642 D220              ;               Y = undefined
0643 D220              ;               P = nvmxdizc
0644 D220              ;                   ..000...
0645 D220              ;               b = k
0646 D220              ;
0647 D220              ;
0648 D220              ;
0649 D220              ;====================================================================================================
0650 D220
0651 D220                       longa on
0652 D220                       longi on
0653 D220              error_routine proc 
0654 D220                       with DirectPage, Globals
0655 D220 48                    pha                            ;push the error code
0656 D221 F4 01 00              pea   err_string>>16
0657 D224 F4 30 D2              pea   err_string
0658 D227 A2 03 15 22           _SysFailMgr 
0659 D22E 00 FF                 brk   $ff
0660 D230
0661 D230                       string pascal
0662 D230 13 45 78 70  err_string DC B:'ExpressLoad error: '
0663 D244                       string asis
0664 D244                       endp 
0665 D244
0666 D244
0667 D244                       TITLE ', ExpressLoad.a - make_HET_ptr'
0668 D244              ;====================================================================================================
0669 D244              ;make_HET_ptr:  This routine builds a pointer to the Header Entry Table
0670 D244              ;
0671 D244              ;Input:         A = undefined
0672 D244              ;               X = undefined
0673 D244              ;               Y = undefined
0674 D244              ;               P = nvmxdizc
0675 D244              ;                   ..000...
0676 D244              ;               b = k
0677 D244              ;
0678 D244              ;               ExpressHandle                   ;must be setup
0679 D244              ;
0680 D244              ;Output:        A = undefined
0681 D244              ;               X = low word of pointer to Expressload Segment memory
0682 D244              ;               Y = high word of pointer to Expressload Segment memory
0683 D244              ;               P = nvmxdizc
0684 D244              ;                   ..000...
0685 D244              ;               b = k
0686 D244              ;
0687 D244              ;               HET_ptr will point to the segment count field in the Header Entry Table (HET)
0688 D244              ;               temp_ptr will point to the link field (HET_ptr-4)
0689 D244              ;
0690 D244              ;====================================================================================================
0691 D244
0692 D244                       longa on
0693 D244                       longi on
0694 D244              make_HET_ptr proc 
0695 D244                       with DirectPage, Globals
0696 D244              ;
0697 D244              ;Setup temp_ptr to point to the reserved field (of Disk Image) of the HET,
0698 D244              ; and HET_ptr to point to the segment count field of the segment.
0699 D244              ;
0700 D244 A0 02 00              ldy   #$0002
0701 D247 18                    clc   
0702 D248 A7 88                 lda   [ExpressHandle]
0703 D24A 85 62                 sta   temp_ptr                 ;temp now points the link field
0704 D24C AA                    tax   
0705 D24D 18                    clc   
0706 D24E 69 04 00              adc   #ExpressloadSeg.SegCount
0707 D251 85 3E                 sta   HET_ptr                  ;and HET_ptr points to count field
0708 D253 B7 88                 lda   [ExpressHandle],y
0709 D255 A8                    tay   
0710 D256 85 64                 sta   temp_ptr+2
0711 D258 69 00 00              adc   #0
0712 D25B 85 40                 sta   HET_ptr+2
0713 D25D 60                    rts   
0714 D25E                       endp 
0715 D25E
0716 D25E                       TITLE ', ExpressLoad.a - setup_seg_ptrs'
0717 D25E              ;====================================================================================================
0718 D25E              ;setup_seg_ptrs:        This routine builds pointers to the segment header entry and the segment
0719 D25E              ;
0720 D25E              ;Input:         A = segment number
0721 D25E              ;               X = undefined
0722 D25E              ;               Y = undefined
0723 D25E              ;               P = nvmxdizc
0724 D25E              ;                   ..000...
0725 D25E              ;               b = k
0726 D25E              ;
0727 D25E              ;
0728 D25E              ;Output:        A = undefined
0729 D25E              ;               X = undefined
0730 D25E              ;               Y = undefined
0731 D25E              ;               P = nvmxdizc
0732 D25E              ;                   ..000...
0733 D25E              ;               b = k
0734 D25E              ;
0735 D25E              ;               HET_entry_ptr
0736 D25E              ;               seg_header_ptr
0737 D25E              ;
0738 D25E              ;====================================================================================================
0739 D25E
0740 D25E                       longa on
0741 D25E                       longi on
0742 D25E              setup_seg_ptrs proc 
0743 D25E                       with DirectPage, Globals
0744 D25E
0745 D25E 3A                    dec   a                        ;convert the segment number please
0746 D25F 3A                    dec   a                        ;allow for ExpressLoad segment
0747 D260
0748 D260 0A                    asl   a
0749 D261 0A                    asl   a
0750 D262 0A                    asl   a                        ;times 8 for HET entry size
0751 D263
0752 D263 1A                    inc   a                        ;add two to pass the segment count field
0753 D264 1A                    inc   a
0754 D265
0755 D265 18                    clc   
0756 D266 65 3E                 adc   HET_ptr                  ;make a pointer to the Entry
0757 D268 85 42                 sta   HET_entry_ptr            ;pointer to the entry itself
0758 D26A A9 00 00              lda   #$0000
0759 D26D 65 40                 adc   HET_ptr+2
0760 D26F 85 44                 sta   HET_entry_ptr+2
0761 D271              ;
0762 D271              ;Build a pointer to the segment header itself
0763 D271              ;
0764 D271 18                    clc   
0765 D272 A5 42                 lda   HET_entry_ptr            ;add in relative address to segment
0766 D274 67 42                 adc   [HET_entry_ptr]
0767 D276 85 4E                 sta   seg_header_ptr
0768 D278 A5 44                 lda   HET_entry_ptr+2
0769 D27A 69 00 00              adc   #$0000
0770 D27D 85 50                 sta   seg_header_ptr+2
0771 D27F 60                    rts   
0772 D280                       endp 
0773 D280
0774 D280                       TITLE ', ExpressLoad.a - setup_base_ptr'
0775 D280              ;====================================================================================================
0776 D280              ;setup_base_ptr:        This routine setups the pointer to the base address of the segment
0777 D280              ;
0778 D280              ;Input:         A = undefined
0779 D280              ;               X = undefined
0780 D280              ;               Y = undefined
0781 D280              ;               P = nvmxdizc
0782 D280              ;                   ..000...
0783 D280              ;               b = k
0784 D280              ;
0785 D280              ;               Het_Entry_pointer               ;must be setup
0786 D280              ;               seg_header_ptr
0787 D280              ;
0788 D280              ;Output:        A = undefined
0789 D280              ;               X = undefined
0790 D280              ;               Y = undefined
0791 D280              ;               P = nvmxdizc
0792 D280              ;                   ..000..1 = error
0793 D280              ;               b = k
0794 D280              ;
0795 D280              ;               base_ptr
0796 D280              ;               segment_entry
0797 D280              ;====================================================================================================
0798 D280
0799 D280                       longa on
0800 D280                       longi on
0801 D280              setup_base_ptr proc 
0802 D280                       with DirectPage, Globals
0803 D280                       import add_segment_offset
0804 D280
0805 D280 A0 04 00              ldy   #HET_Entry.SegHandle     ;setup the Base_ptr
0806 D283 B7 42                 lda   [HET_entry_ptr],y
0807 D285 AA                    tax   
0808 D286 C8                    iny   
0809 D287 C8                    iny   
0810 D288 B7 42                 lda   [HET_entry_ptr],y
0811 D28A A8                    tay   
0812 D28B D0 05                 bne   @good_handle
0813 D28D 8A                    txa   
0814 D28E D0 02                 bne   @good_handle
0815 D290 38                    sec   
0816 D291 60                    rts   
0817 D292              @good_handle  
0818 D292 86 46                 stx   temp_handle
0819 D294 84 48                 sty   temp_handle+2            ;handle to the segment in memory
0820 D296 A0 02 00              ldy   #$0002                   ;deref the handle to get the base address
0821 D299 A7 46                 lda   [temp_handle]
0822 D29B AA                    tax   
0823 D29C B7 46                 lda   [temp_handle],y
0824 D29E A8                    tay   
0825 D29F 07 46                 ora   [temp_handle]
0826 D2A1 D0 02                 bne   @good_address
0827 D2A3 38                    sec   
0828 D2A4 60                    rts   
0829 D2A5              @good_address  
0830 D2A5 86 4A                 stx   base_ptr
0831 D2A7 84 4C                 sty   base_ptr+2               ;address of the segment in memory
0832 D2A9 20 FD E2              jsr   add_segment_offset
0833 D2AC 18                    clc   
0834 D2AD 60                    rts   
0835 D2AE                       endp 
0836 D2AE
0837 D2AE                       TITLE ', ExpressLoad.a - alloc_id'
0838 D2AE              ;====================================================================================================
0839 D2AE              ;alloc_id:      This routine will allocate a new user ID for a load file.  This routine is called
0840 D2AE              ;               by the "initial_Load" routine
0841 D2AE              ;
0842 D2AE              ;Input:         A = user_id             ;ID from the caller
0843 D2AE              ;               X = undefined
0844 D2AE              ;               Y = undefined
0845 D2AE              ;               P = nvmxdizc
0846 D2AE              ;                   ..000...
0847 D2AE              ;               b = k
0848 D2AE              ;
0849 D2AE              ;
0850 D2AE              ;Output:        A = user_id             ;ID for the application
0851 D2AE              ;               X = undefined
0852 D2AE              ;               Y = undefined
0853 D2AE              ;               P = nvmxdizc
0854 D2AE              ;                   ..000..1 = error
0855 D2AE              ;               b = k
0856 D2AE              ;
0857 D2AE              ;
0858 D2AE              ;====================================================================================================
0859 D2AE
0860 D2AE                       longa on
0861 D2AE                       longi on
0862 D2AE              alloc_id proc 
0863 D2AE                       with DirectPage, Globals
0864 D2AE
0865 D2AE AA                    tax   
0866 D2AF 29 FF 00              and   #$00FF
0867 D2B2 D0 19                 bne   @exit_alloc              ;use the given ID
0868 D2B4 8A                    txa   
0869 D2B5 29 00 FF              and   #$FF00                   ;see if the Type_ID is 0
0870 D2B8 D0 05                 bne   @get_new                 ;Use the Input Type and Aux type please
0871 D2BA 8A                    txa   
0872 D2BB 09 00 10              ora   #Application             ;set the Type to Application
0873 D2BE AA                    tax   
0874 D2BF              @get_new  
0875 D2BF F4 00 00              pea   $0000                    ;space for result
0876 D2C2 DA                    phx                            ;ID stuff
0877 D2C3 A2 03 20 22           _GetNewID 
0878 D2CA FA                    plx   
0879 D2CB B0 05                 bcs   @oops                    ;return the error
0880 D2CD              @exit_alloc  
0881 D2CD 8A                    txa                            ;set A = user_id
0882 D2CE 8D B6 A6              sta   |USERID                  ;this is now the Global_ID
0883 D2D1 18                    clc   
0884 D2D2              @oops     
0885 D2D2 60                    rts   
0886 D2D3                       endp 
0887 D2D3
0888 D2D3                       TITLE ', ExpressLoad.a - compare_paths'
0889 D2D3              ;====================================================================================================
0890 D2D3              ;compare_paths: This routine will compare the full pathnames pointed to by PathnamePtr and
0891 D2D3              ;               TempBuff to see if they are equal.
0892 D2D3              ;               It can also compare partial paths if "Partial_Match" is negative.
0893 D2D3              ;
0894 D2D3              ;Input:         A = undefined
0895 D2D3              ;               X = undefined
0896 D2D3              ;               Y = undefined
0897 D2D3              ;               P = nvmxdizc
0898 D2D3              ;                   ..000...
0899 D2D3              ;               b = k
0900 D2D3              ;               PathnamePtr & TempBuff point to the two pathnames to compare
0901 D2D3              ;
0902 D2D3              ;Output:        A = undefined
0903 D2D3              ;               X = undefined
0904 D2D3              ;               Y = undefined
0905 D2D3              ;               P = nvmxdizc
0906 D2D3              ;                   .x000..0 = Match found (complete or partial, depending on V flag)
0907 D2D3              ;                          1 = Match not found
0908 D2D3              ;                    0       = partial match found.
0909 D2D3              ;                    1       = complete match found.
0910 D2D3              ;               b = k
0911 D2D3              ;
0912 D2D3              ;
0913 D2D3              ;====================================================================================================
0914 D2D3
0915 D2D3                       longa on
0916 D2D3                       longi on
0917 D2D3              compare_paths proc 
0918 D2D3                       with DirectPage, Globals
0919 D2D3
0920 D2D3 A7 CE                 lda   [PathnamePtr]            ;compare the string sizes first
0921 D2D5 A8                    tay   
0922 D2D6 C7 18                 cmp   [TempBuff]
0923 D2D8 F0 40                 beq   @do_full_check
0924 D2DA 90 09                 bcc   @chk_colon_full_blown    ;PathnamePtr contains the smaller string.
0925 D2DC A7 18                 lda   [TempBuff]
0926 D2DE A8                    tay   
0927 D2DF
0928 D2DF C8                    iny                            ;TempBuff contains the smaller string
0929 D2E0 C8                    iny   
0930 D2E1 B7 CE                 lda   [PathnamePtr],y
0931 D2E3 80 04                 bra   @do_chk
0932 D2E5
0933 D2E5              @chk_colon_full_blown  
0934 D2E5 C8                    iny   
0935 D2E6 C8                    iny   
0936 D2E7 B7 18                 lda   [TempBuff],y
0937 D2E9              @do_chk   
0938 D2E9 29 FF 00              and   #$00FF
0939 D2EC C9 3A 00              cmp   #seperator               ;is it a seperator?
0940 D2EF D0 50                 bne   @not_same
0941 D2F1
0942 D2F1              @do_partial_compare  
0943 D2F1 A5 A4                 lda   partial_match            ;are we looking for a partial match?
0944 D2F3 10 4C                 bpl   @not_same                ;don't bother.
0945 D2F5
0946 D2F5 88                    dey   
0947 D2F6                       longa off
0948 D2F6 E2 20                 sep   #$20
0949 D2F8              @partial_loop  
0950 D2F8 B7 CE                 lda   [PathnamePtr],y          ;compare the ascii data
0951 D2FA 57 18                 eor   [TempBuff],y             ;case insensitive comparison
0952 D2FC F0 16                 beq   @equal_1
0953 D2FE C9 20                 cmp   #$20                     ;difference only in case?
0954 D300 D0 3F                 bne   @not_same                ;nope!
0955 D302 B7 CE                 lda   [PathnamePtr],y          ;get character again
0956 D304 C9 41                 cmp   #'A'                     ;make sure it's alphabetic
0957 D306 90 39                 bcc   @not_same
0958 D308 C9 5B                 cmp   #'Z'+1
0959 D30A 90 08                 bcc   @equal_1
0960 D30C C9 61                 cmp   #'a'                     ;lower case?
0961 D30E 90 31                 bcc   @not_same
0962 D310 C9 7B                 cmp   #'z'+1
0963 D312 B0 2D                 bcs   @not_same
0964 D314              @equal_1  
0965 D314 88                    dey   
0966 D315 D0 E1                 bne   @partial_loop
0967 D317 C2 61                 rep   #$61                     ;clear overflow & carry bits
0968 D319 60                    rts   
0969 D31A
0970 D31A              @do_full_check  
0971 D31A C8                    iny                            ;bump for leading length word
0972 D31B                       longa off
0973 D31B E2 20                 sep   #$20
0974 D31D              @loop     
0975 D31D B7 CE                 lda   [PathnamePtr],y          ;compare the ascii data
0976 D31F 57 18                 eor   [TempBuff],y             ;case insensitive comparison
0977 D321 F0 16                 beq   @equal_2
0978 D323 C9 20                 cmp   #$20                     ;difference only in case?
0979 D325 D0 1A                 bne   @not_same                ;nope!
0980 D327 B7 CE                 lda   [PathnamePtr],y          ;get character again
0981 D329 C9 41                 cmp   #'A'                     ;make sure it's alphabetic
0982 D32B 90 14                 bcc   @not_same
0983 D32D C9 5B                 cmp   #'Z'+1
0984 D32F 90 08                 bcc   @equal_2
0985 D331 C9 61                 cmp   #'a'                     ;lower case?
0986 D333 90 0C                 bcc   @not_same
0987 D335 C9 7B                 cmp   #'z'+1
0988 D337 B0 08                 bcs   @not_same
0989 D339              @equal_2  
0990 D339 88                    dey   
0991 D33A D0 E1                 bne   @loop
0992 D33C C2 21                 rep   #$21                     ;clears carry too
0993 D33E E2 40                 sep   #$40                     ;set overflow bit (full match)
0994 D340 60                    rts                            ;the pathnames are the same
0995 D341              @not_same  
0996 D341                       longa on
0997 D341 C2 20                 rep   #$20
0998 D343 E2 41                 sep   #$41                     ;no partial or complete match found
0999 D345 60                    rts   
1000 D346                       endp 
1001 D346
1002 D346                       TITLE ', ExpressLoad.a - merge_path'
1003 D346              ;====================================================================================================
1004 D346              ;merge_path:    This routine will merge the volume name and partial path into one complete pathname
1005 D346              ;               The names are stored at the end of an ExpressLoad segment.
1006 D346              ;
1007 D346              ;merge_path_2:  Alternate entry point that can be used when ExpressHandle already contains the handle.
1008 D346              ;
1009 D346              ;Input:         A = undefined
1010 D346              ;               X = low word of ExpressHandle
1011 D346              ;               Y = High Word of ExpressHandle
1012 D346              ;               P = nvmxdizc
1013 D346              ;                   ..000...
1014 D346              ;               b = k
1015 D346              ;
1016 D346              ;               ExpressHandle           ;must be setup
1017 D346              ;
1018 D346              ;Output:        A = undefined
1019 D346              ;               X = undefined
1020 D346              ;               Y = undefined
1021 D346              ;               P = nvmxdizc
1022 D346              ;                   ..000..
1023 D346              ;               b = k
1024 D346              ;
1025 D346              ;               PathnamePtr             pointer to pathname within ExpressLoad segment
1026 D346              ;
1027 D346              ;====================================================================================================
1028 D346
1029 D346                       longa on
1030 D346                       longi on
1031 D346              merge_path proc 
1032 D346                       entry merge_path_2
1033 D346
1034 D346                       with DirectPage, Globals
1035 D346
1036 D346 86 88                 stx   ExpressHandle
1037 D348 84 8A                 sty   ExpressHandle+2
1038 D34A
1039 D34A              merge_path_2  
1040 D34A A0 02 00              ldy   #$0002                   ;build a pointer to ExpressSegment
1041 D34D A7 88                 lda   [ExpressHandle]
1042 D34F 85 62                 sta   temp_ptr
1043 D351 B7 88                 lda   [ExpressHandle],y
1044 D353 85 64                 sta   temp_ptr+2
1045 D355              ;
1046 D355              ;Now we need to build a pointer to the volume name
1047 D355              ;
1048 D355 A0 02 00              ldy   #ExpressloadSeg.PathnameOffset ;offset to the volume name
1049 D358 18                    clc   
1050 D359 B7 62                 lda   [temp_ptr],y
1051 D35B 65 62                 adc   temp_ptr
1052 D35D 85 CE                 sta   PathnamePtr
1053 D35F A9 00 00              lda   #$0000
1054 D362 65 64                 adc   temp_ptr+2
1055 D364 85 D0                 sta   PathnamePtr+2            ;PathnamePtr now points to the volume name
1056 D366
1057 D366 18                    clc   
1058 D367 60                    rts   
1059 D368                       endp 
1060 D368
1061 D368                       TITLE ', ExpressLoad.a - add_user_id'
1062 D368              ;====================================================================================================
1063 D368              ;add_user_id:   This routine will find a empty spot in the user_id table and allocate it
1064 D368              ;
1065 D368              ;Input:         A = user_id             ;ID from the caller
1066 D368              ;               X = undefined
1067 D368              ;               Y = undefined
1068 D368              ;               P = nvmxdizc
1069 D368              ;                   ..000..1 = error
1070 D368              ;               b = k
1071 D368              ;
1072 D368              ;
1073 D368              ;Output:        A = undefined
1074 D368              ;               X = low word address of entry
1075 D368              ;               Y = high word address of entry
1076 D368              ;               P = nvmxdizc
1077 D368              ;                   ..000..1 = error
1078 D368              ;               b = k
1079 D368              ;
1080 D368              ;
1081 D368              ;====================================================================================================
1082 D368
1083 D368                       longa on
1084 D368                       longi on
1085 D368              add_user_id proc 
1086 D368                       with DirectPage, Globals
1087 D368
1088 D368 85 72                 sta   temp_word                ;ID to add
1089 D36A
1090 D36A A0 02 00              ldy   #$0002                   ;start at the beginning of the user_id table
1091 D36D A7 78                 lda   [user_id_handle]
1092 D36F 85 7C                 sta   user_id_ptr
1093 D371 B7 78                 lda   [user_id_handle],y
1094 D373 85 7E                 sta   user_id_ptr+2
1095 D375              @loop     
1096 D375 20 86 D3              jsr   get_free_id              ;find a free spot in the table
1097 D378 90 06                 bcc   @got_it
1098 D37A 20 45 D1              jsr   add_id_table             ;add another table please
1099 D37D 90 F6                 bcc   @loop                    ;try again
1100 D37F 60                    rts                            ;return the error
1101 D380              @got_it   
1102 D380 A6 62                 ldx   temp_ptr
1103 D382 A4 64                 ldy   temp_ptr+2               ;address of the entry
1104 D384 18                    clc   
1105 D385 60                    rts   
1106 D386
1107 D386              get_free_id  
1108 D386 A0 10 00              ldy   #id_entry_size           ;start at the first available spot
1109 D389 A2 7E 00              ldx   #id_entry_cnt            ;number of entries in a table
1110 D38C              @search_loop  
1111 D38C B7 7C                 lda   [user_id_ptr],y          ;is this avail.
1112 D38E F0 0B                 beq   @its_free
1113 D390 18                    clc   
1114 D391 98                    tya   
1115 D392 69 10 00              adc   #id_entry_size
1116 D395 A8                    tay   
1117 D396 CA                    dex   
1118 D397 10 F3                 bpl   @search_loop
1119 D399 38                    sec   
1120 D39A 60                    rts   
1121 D39B              @its_free  
1122 D39B 18                    clc                            ;build a pointer to the entry
1123 D39C 98                    tya   
1124 D39D 65 7C                 adc   user_id_ptr
1125 D39F 85 62                 sta   temp_ptr
1126 D3A1 85 7C                 sta   user_id_ptr
1127 D3A3 A9 00 00              lda   #$000
1128 D3A6 65 7E                 adc   user_id_ptr+2
1129 D3A8 85 64                 sta   temp_ptr+2
1130 D3AA 85 7E                 sta   user_id_ptr+2
1131 D3AC
1132 D3AC A0 0E 00              ldy   #14                      ;clear the entry please (16 bytes total 0 thru 15)
1133 D3AF A9 00 00              lda   #$0000
1134 D3B2              @clr_it   
1135 D3B2 97 62                 sta   [temp_ptr],y
1136 D3B4 88                    dey   
1137 D3B5 88                    dey   
1138 D3B6 10 FA                 bpl   @clr_it
1139 D3B8
1140 D3B8 A5 72                 lda   temp_word                ;save the user Id please
1141 D3BA 87 62                 sta   [temp_ptr]
1142 D3BC 18                    clc   
1143 D3BD 60                    rts   
1144 D3BE                       endp 
1145 D3BE
1146 D3BE                       TITLE ', ExpressLoad.a - delete_user_id'
1147 D3BE              ;====================================================================================================
1148 D3BE              ;delete_user_id:        This routine will delete the user_id pointer to by user_id
1149 D3BE              ;
1150 D3BE              ;Input:         A = user_id_Flag:       0 = delete ID, 1 = keep the user_id
1151 D3BE              ;               X = undefined
1152 D3BE              ;               Y = undefined
1153 D3BE              ;               P = nvmxdizc
1154 D3BE              ;                   ..000..1 = error
1155 D3BE              ;               b = k
1156 D3BE              ;
1157 D3BE              ;               user_id                 ;must be setup
1158 D3BE              ;
1159 D3BE              ;Output:        A = undefined
1160 D3BE              ;               X = undefined
1161 D3BE              ;               Y = undefined
1162 D3BE              ;               P = nvmxdizc
1163 D3BE              ;                   ..000..1 = error
1164 D3BE              ;               b = k
1165 D3BE              ;
1166 D3BE              ;
1167 D3BE              ;====================================================================================================
1168 D3BE
1169 D3BE                       longa on
1170 D3BE                       longi on
1171 D3BE              delete_user_id proc 
1172 D3BE                       with DirectPage, Globals
1173 D3BE
1174 D3BE 85 AA                 sta   id_flag                  ;used to determine if I should delete the user id
1175 D3C0
1176 D3C0 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle
1177 D3C3 B7 7C                 lda   [user_id_ptr],y          ;get the ExpressLoad handle
1178 D3C5 AA                    tax   
1179 D3C6 C8                    iny   
1180 D3C7 C8                    iny   
1181 D3C8 B7 7C                 lda   [user_id_ptr],y
1182 D3CA A8                    tay   
1183 D3CB D0 03                 bne   @deallocate
1184 D3CD AA                    tax   
1185 D3CE F0 0C                 beq   @no_handle
1186 D3D0              @deallocate  
1187 D3D0 5A                    phy   
1188 D3D1 DA                    phx   
1189 D3D2 20 00 D0              jsr   clear_handles            ;clear local copy of handle
1190 D3D5 A2 02 10 22           _DisposeHandle 
1191 D3DC              @no_handle  
1192 D3DC A7 7C                 lda   [user_id_ptr]            ;get the user_id
1193 D3DE F0 16                 beq   @zero_and_exit
1194 D3E0
1195 D3E0 48                    pha                            ;ID to nuke
1196 D3E1 A2 02 11 22           _DisposeAll 
1197 D3E8
1198 D3E8 A6 AA                 ldx   id_flag                  ;should we nuke the ID?
1199 D3EA D0 0A                 bne   @zero_and_exit           ;no...
1200 D3EC
1201 D3EC A7 7C                 lda   [user_id_ptr]            ;get the user_id
1202 D3EE 48                    pha                            ;ID to nuke
1203 D3EF A2 03 21 22           _DeleteID 
1204 D3F6
1205 D3F6              @zero_and_exit  
1206 D3F6 A0 02 00              ldy   #$0002
1207 D3F9 A9 00 00              lda   #$0000
1208 D3FC 87 7C                 sta   [user_id_ptr]
1209 D3FE 97 7C                 sta   [user_id_ptr],y
1210 D400 C8                    iny   
1211 D401 C8                    iny   
1212 D402 97 7C                 sta   [user_id_ptr],y          ;remove everything
1213 D404 64 88                 stz   ExpressHandle            ;indicate that we no longer have the load file
1214 D406 64 8A                 stz   ExpressHandle+2
1215 D408 18                    clc   
1216 D409 60                    rts   
1217 D40A                       endp 
1218 D40A
1219 D40A                       TITLE ', ExpressLoad.a - purge_user_id'
1220 D40A              ;====================================================================================================
1221 D40A              ;purge_user_id: This routine will mark an application as purgable
1222 D40A              ;
1223 D40A              ;Input:         A = undefined
1224 D40A              ;               X = undefined
1225 D40A              ;               Y = undefined
1226 D40A              ;               P = nvmxdizc
1227 D40A              ;                   ..000..1 = error
1228 D40A              ;               b = k
1229 D40A              ;
1230 D40A              ;               user_id                 ;must be setup
1231 D40A              ;
1232 D40A              ;Output:        A = undefined
1233 D40A              ;               X = undefined
1234 D40A              ;               Y = undefined
1235 D40A              ;               P = nvmxdizc
1236 D40A              ;                   ..000..1 = error
1237 D40A              ;               b = k
1238 D40A              ;
1239 D40A              ;
1240 D40A              ;====================================================================================================
1241 D40A
1242 D40A                       longa on
1243 D40A                       longi on
1244 D40A              purge_user_id proc 
1245 D40A                       with DirectPage, Globals
1246 D40A
1247 D40A A7 7C                 lda   [user_id_ptr]            ;get the user_id
1248 D40C F0 08                 beq   @exit
1249 D40E 48                    pha   
1250 D40F A2 02 13 22           _PurgeAll 
1251 D416              @exit     
1252 D416 60                    rts   
1253 D417                       endp 
1254 D417
1255 D417                       TITLE ', ExpressLoad.a - remove_segment'
1256 D417              ;====================================================================================================
1257 D417              ;remove_segment:        This routine will deallocate all memory associated with a user ID.
1258 D417              ;
1259 D417              ;Input:         A = And Mask for flags field
1260 D417              ;               X = Compare Value
1261 D417              ;               Y = undefined
1262 D417              ;               P = nvmxdizc
1263 D417              ;                   ..000..1 = error
1264 D417              ;               b = k
1265 D417              ;
1266 D417              ;               ExpressHandle
1267 D417              ;
1268 D417              ;Output:        A = undefined
1269 D417              ;               X = undefined
1270 D417              ;               Y = undefined
1271 D417              ;               P = nvmxdizc
1272 D417              ;                   ..000..1 = error
1273 D417              ;               b = k
1274 D417              ;
1275 D417              ;
1276 D417              ;====================================================================================================
1277 D417
1278 D417                       longa on
1279 D417                       longi on
1280 D417              remove_segment proc 
1281 D417                       with DirectPage, Globals
1282 D417 85 72                 sta   temp_word
1283 D419 86 C6                 stx   search_kind
1284 D41B
1285 D41B 20 44 D2              jsr   make_HET_ptr
1286 D41E
1287 D41E A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
1288 D420 1A                    inc   a                        ;start from the last segment
1289 D421 1A                    inc   a
1290 D422 AA                    tax   
1291 D423              @search_loop  
1292 D423 8A                    txa                            ;pass in the segment number
1293 D424 F0 19                 beq   @end_remove              ;sorry there is no segment
1294 D426 DA                    phx   
1295 D427 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
1296 D42A A0 02 00              ldy   #HET_Entry.SegFlags
1297 D42D B7 42                 lda   [HET_entry_ptr],y
1298 D42F 25 72                 and   temp_word                ;AND off user requested bits
1299 D431 C5 C6                 cmp   search_kind              ;see if we have a match
1300 D433 D0 03                 bne   @skip_it
1301 D435 20 41 D4              jsr   do_operation
1302 D438              @skip_it  
1303 D438 FA                    plx   
1304 D439 CA                    dex                            ;back off by one and try again
1305 D43A E0 01 00              cpx   #$0001
1306 D43D D0 E4                 bne   @search_loop
1307 D43F              @end_remove  
1308 D43F 18                    clc   
1309 D440 60                    rts   
1310 D441
1311 D441              do_operation  
1312 D441 A9 00 00              lda   #$0000                   ;zero the status word
1313 D444 97 42                 sta   [HET_entry_ptr],y
1314 D446 A0 04 00              ldy   #HET_Entry.SegHandle     ;lets dispose of the handle please
1315 D449 B7 42                 lda   [HET_entry_ptr],y
1316 D44B AA                    tax   
1317 D44C A9 00 00              lda   #$0000
1318 D44F 97 42                 sta   [HET_entry_ptr],y
1319 D451 C8                    iny   
1320 D452 C8                    iny   
1321 D453 B7 42                 lda   [HET_entry_ptr],y        ;get the high word
1322 D455 48                    pha   
1323 D456 A9 00 00              lda   #$000
1324 D459 97 42                 sta   [HET_entry_ptr],y
1325 D45B DA                    phx                            ;push the low word
1326 D45C 20 00 D0              jsr   clear_handles            ;clear local copy of handle
1327 D45F A2 02 10 22           _DisposeHandle 
1328 D466 60                    rts   
1329 D467                       endp 
1330 D467
1331 D467                       TITLE ', ExpressLoad.a - find_user_id'
1332 D467              ;====================================================================================================
1333 D467              ;find_user_id:  This routine will find a user_id in the user_id_Table
1334 D467              ;
1335 D467              ;Input:         A = user_id             ;ID from the caller
1336 D467              ;               X = undefined
1337 D467              ;               Y = undefined
1338 D467              ;               P = nvmxdizc
1339 D467              ;                   ..000...
1340 D467              ;               b = k
1341 D467              ;
1342 D467              ;
1343 D467              ;Output:        A = undefined
1344 D467              ;               X = low word address of entry
1345 D467              ;               Y = high word address of entry
1346 D467              ;               P = nvmxdizc
1347 D467              ;                   ..000..1 = error
1348 D467              ;               b = k
1349 D467              ;
1350 D467              ;
1351 D467              ;====================================================================================================
1352 D467
1353 D467                       longa on
1354 D467                       longi on
1355 D467              find_user_id proc 
1356 D467                       with DirectPage, Globals
1357 D467
1358 D467 AA                    tax   
1359 D468 D0 03                 bne   @use_input
1360 D46A AD B6 A6              lda   |USERID                  ;use the global ID
1361 D46D              @use_input  
1362 D46D 85 C6                 sta   search_kind
1363 D46F 8D B6 A6              sta   |USERID                  ;update the global User ID
1364 D472
1365 D472 A0 02 00              ldy   #$0002
1366 D475 A7 78                 lda   [user_id_handle]
1367 D477 85 7C                 sta   user_id_ptr
1368 D479 B7 78                 lda   [user_id_handle],y
1369 D47B 85 7E                 sta   user_id_ptr+2
1370 D47D              @loop     
1371 D47D 20 AD D4              jsr   find_id
1372 D480 90 25                 bcc   @found_it
1373 D482
1374 D482 A0 02 00              ldy   #User_ID_Table.Next+2    ;get the next link
1375 D485 A7 7C                 lda   [user_id_ptr]
1376 D487 AA                    tax   
1377 D488 B7 7C                 lda   [user_id_ptr],y
1378 D48A A8                    tay   
1379 D48B D0 05                 bne   @keep_going
1380 D48D 8A                    txa   
1381 D48E D0 02                 bne   @keep_going
1382 D490 38                    sec   
1383 D491 60                    rts                            ;sorry ID not found
1384 D492              @keep_going  
1385 D492 86 46                 stx   temp_handle
1386 D494 86 98                 stx   curr_id_handle           ;the current handle table
1387 D496 84 48                 sty   temp_handle+2
1388 D498 84 9A                 sty   curr_id_handle+2
1389 D49A A0 02 00              ldy   #$0002
1390 D49D A7 46                 lda   [temp_handle]
1391 D49F 85 7C                 sta   user_id_ptr
1392 D4A1 B7 46                 lda   [temp_handle],y
1393 D4A3 85 7E                 sta   user_id_ptr+2
1394 D4A5 80 D6                 bra   @loop
1395 D4A7              @found_it  
1396 D4A7 A6 62                 ldx   temp_ptr                 ;return pointer to the entry
1397 D4A9 A4 64                 ldy   temp_ptr+2
1398 D4AB 18                    clc   
1399 D4AC 60                    rts   
1400 D4AD
1401 D4AD              find_id   
1402 D4AD A0 10 00              ldy   #id_entry_size           ;start at the first available spot
1403 D4B0 A2 7E 00              ldx   #id_entry_cnt            ;number of entries in a table
1404 D4B3              @search_loop  
1405 D4B3 B7 7C                 lda   [user_id_ptr],y          ;is this the one
1406 D4B5 C5 C6                 cmp   search_kind
1407 D4B7 F0 0B                 beq   @its_the_one
1408 D4B9 18                    clc   
1409 D4BA 98                    tya   
1410 D4BB 69 10 00              adc   #id_entry_size
1411 D4BE A8                    tay   
1412 D4BF CA                    dex   
1413 D4C0 10 F1                 bpl   @search_loop
1414 D4C2 38                    sec   
1415 D4C3 60                    rts   
1416 D4C4              @its_the_one  
1417 D4C4 18                    clc                            ;build a pointer to the entry
1418 D4C5 98                    tya   
1419 D4C6 65 7C                 adc   user_id_ptr
1420 D4C8 85 62                 sta   temp_ptr
1421 D4CA 85 7C                 sta   user_id_ptr
1422 D4CC A9 00 00              lda   #$000
1423 D4CF 65 7E                 adc   user_id_ptr+2
1424 D4D1 85 64                 sta   temp_ptr+2
1425 D4D3 85 7E                 sta   user_id_ptr+2
1426 D4D5
1427 D4D5 18                    clc   
1428 D4D6 60                    rts   
1429 D4D7
1430 D4D7                       endp 
1431 D4D7
1432 D4D7                       TITLE ', ExpressLoad.a - path_to_user_id'
1433 D4D7              ;====================================================================================================
1434 D4D7              ;path_to_user_id:       This routine will find a user_id in the user_id_Table given a pathname
1435 D4D7              ;
1436 D4D7              ;Input:         A = undefined
1437 D4D7              ;               X = undefined
1438 D4D7              ;               Y = undefined
1439 D4D7              ;               P = nvmxdizc
1440 D4D7              ;                   ..000...
1441 D4D7              ;               b = k
1442 D4D7              ;
1443 D4D7              ;               TempBuff                ;pointer to path that we need to find
1444 D4D7              ;
1445 D4D7              ;Output:        A = User ID
1446 D4D7              ;               X = undefined
1447 D4D7              ;               Y =undefined
1448 D4D7              ;               P = nvmxdizc
1449 D4D7              ;                   ..000..1 = not found
1450 D4D7              ;               b = k
1451 D4D7              ;
1452 D4D7              ;
1453 D4D7              ;====================================================================================================
1454 D4D7
1455 D4D7                       longa on
1456 D4D7                       longi on
1457 D4D7              path_to_user_id proc 
1458 D4D7                       with DirectPage, Globals
1459 D4D7
1460 D4D7 A0 02 00              ldy   #$0002
1461 D4DA A7 78                 lda   [user_id_handle]
1462 D4DC 85 7C                 sta   user_id_ptr
1463 D4DE B7 78                 lda   [user_id_handle],y
1464 D4E0 85 7E                 sta   user_id_ptr+2
1465 D4E2              @loop     
1466 D4E2 20 08 D5              jsr   find_id
1467 D4E5 90 20                 bcc   @found_it                ;we have found the complete path!
1468 D4E7
1469 D4E7 A0 02 00              ldy   #$0002                   ;get the next link
1470 D4EA A7 7C                 lda   [user_id_ptr]
1471 D4EC AA                    tax   
1472 D4ED B7 7C                 lda   [user_id_ptr],y
1473 D4EF A8                    tay   
1474 D4F0 07 7C                 ora   [user_id_ptr]
1475 D4F2 D0 02                 bne   @keep_going
1476 D4F4 38                    sec   
1477 D4F5 60                    rts                            ;sorry ID not found
1478 D4F6              @keep_going  
1479 D4F6 86 46                 stx   temp_handle
1480 D4F8 84 48                 sty   temp_handle+2
1481 D4FA A0 02 00              ldy   #$00002
1482 D4FD A7 46                 lda   [temp_handle]
1483 D4FF 85 7C                 sta   user_id_ptr
1484 D501 B7 46                 lda   [temp_handle],y
1485 D503 85 7E                 sta   user_id_ptr+2
1486 D505 80 DB                 bra   @loop
1487 D507              @found_it  
1488 D507 60                    rts                            ;A = user_id
1489 D508
1490 D508              find_id   
1491 D508 A0 10 00              ldy   #id_entry_size           ;start at the first available spot
1492 D50B A2 7E 00              ldx   #id_entry_cnt            ;number of entries in a table
1493 D50E              @search_loop  
1494 D50E B7 7C                 lda   [user_id_ptr],y          ;is this the one
1495 D510 85 C6                 sta   search_kind              ;save the User ID
1496 D512 F0 09                 beq   @empty_slot
1497 D514 5A                    phy   
1498 D515 DA                    phx   
1499 D516 20 2A D5              jsr   check_name               ;is this the one
1500 D519 FA                    plx   
1501 D51A 7A                    ply   
1502 D51B 90 0C                 bcc   @its_the_one
1503 D51D
1504 D51D 18           @empty_slot clc   
1505 D51E 98                    tya   
1506 D51F 69 10 00              adc   #id_entry_size
1507 D522 A8                    tay   
1508 D523 CA                    dex   
1509 D524 10 E8                 bpl   @search_loop
1510 D526 38                    sec   
1511 D527 E2 40                 sep   #$40                     ;no partial match!!!
1512 D529              @its_the_one  
1513 D529 60                    rts   
1514 D52A              check_name  
1515 D52A C8                    iny   
1516 D52B C8                    iny                            ;get the handle
1517 D52C B7 7C                 lda   [user_id_ptr],y
1518 D52E AA                    tax   
1519 D52F C8                    iny   
1520 D530 C8                    iny   
1521 D531 B7 7C                 lda   [user_id_ptr],y
1522 D533 A8                    tay   
1523 D534 20 46 D3              jsr   merge_path               ;build a complete pathname
1524 D537 20 D3 D2              jsr   compare_paths            ;is this the one?
1525 D53A A5 C6                 lda   search_kind
1526 D53C 60                    rts                            ;carry set or cleared from the compare routine
1527 D53D                       endp 
1528 D53D
1529 D53D                       TITLE ', ExpressLoad.a - find_seg_handle'
1530 D53D              ;====================================================================================================
1531 D53D              ;find_seg_handle:       This routine will find a segment by handle
1532 D53D              ;
1533 D53D              ;Input:         A = undefined
1534 D53D              ;               X = undefined
1535 D53D              ;               Y = undefined
1536 D53D              ;               P = nvmxdizc
1537 D53D              ;                   ..000...
1538 D53D              ;               b = k
1539 D53D              ;
1540 D53D              ;               seg_handle              ;must be setup
1541 D53D              ;
1542 D53D              ;Output:        A = User ID
1543 D53D              ;               X = undefined
1544 D53D              ;               Y =undefined
1545 D53D              ;               P = nvmxdizc
1546 D53D              ;                   ..000..1 = not found
1547 D53D              ;               b = k
1548 D53D              ;
1549 D53D              ;
1550 D53D              ;====================================================================================================
1551 D53D
1552 D53D                       longa on
1553 D53D                       longi on
1554 D53D              find_seg_handle proc 
1555 D53D                       with DirectPage, Globals
1556 D53D
1557 D53D A0 02 00              ldy   #$0002
1558 D540 A7 78                 lda   [user_id_handle]
1559 D542 85 7C                 sta   user_id_ptr
1560 D544 B7 78                 lda   [user_id_handle],y
1561 D546 85 7E                 sta   user_id_ptr+2
1562 D548              @loop     
1563 D548 20 6F D5              jsr   find_id
1564 D54B 90 21                 bcc   @found_it
1565 D54D
1566 D54D A0 02 00              ldy   #User_ID_Table.Next+2    ;get the next link
1567 D550 A7 7C                 lda   [user_id_ptr]
1568 D552 AA                    tax   
1569 D553 B7 7C                 lda   [user_id_ptr],y
1570 D555 A8                    tay   
1571 D556 D0 05                 bne   @keep_going
1572 D558 8A                    txa   
1573 D559 D0 02                 bne   @keep_going
1574 D55B 38                    sec   
1575 D55C 60                    rts                            ;sorry ID not found
1576 D55D              @keep_going  
1577 D55D 86 46                 stx   temp_handle
1578 D55F 84 48                 sty   temp_handle+2
1579 D561 A0 02 00              ldy   #$00002
1580 D564 A7 46                 lda   [temp_handle]
1581 D566 85 7C                 sta   user_id_ptr
1582 D568 B7 46                 lda   [temp_handle],y
1583 D56A 85 7E                 sta   user_id_ptr+2
1584 D56C 80 DA                 bra   @loop
1585 D56E              @found_it  
1586 D56E 60                    rts                            ;A = user_id
1587 D56F
1588 D56F              find_id   
1589 D56F A0 10 00              ldy   #id_entry_size           ;start at the first available spot
1590 D572 A2 7E 00              ldx   #id_entry_cnt            ;number of entries in a table
1591 D575              @search_loop  
1592 D575 B7 7C                 lda   [user_id_ptr],y          ;is this the one
1593 D577 8D B6 A6              sta   |USERID
1594 D57A F0 09                 beq   @empty_slot
1595 D57C 5A                    phy   
1596 D57D DA                    phx   
1597 D57E 20 92 D5              jsr   check_handle             ;is this the one
1598 D581 FA                    plx   
1599 D582 7A                    ply   
1600 D583 90 0A                 bcc   @its_the_one
1601 D585              @empty_slot  
1602 D585 18                    clc   
1603 D586 98                    tya   
1604 D587 69 10 00              adc   #id_entry_size
1605 D58A A8                    tay   
1606 D58B CA                    dex   
1607 D58C 10 E7                 bpl   @search_loop
1608 D58E 38                    sec   
1609 D58F              @its_the_one  
1610 D58F 85 AC                 sta   search_seg               ;save the segment number
1611 D591 60                    rts   
1612 D592              check_handle  
1613 D592 C8                    iny   
1614 D593 C8                    iny                            ;get the handle
1615 D594 B7 7C                 lda   [user_id_ptr],y
1616 D596 85 88                 sta   ExpressHandle
1617 D598 AA                    tax   
1618 D599 C8                    iny   
1619 D59A C8                    iny   
1620 D59B B7 7C                 lda   [user_id_ptr],y
1621 D59D 85 8A                 sta   ExpressHandle+2          ;Handle to the ExpressLoad segment
1622 D59F 20 A3 D5              jsr   walk_expressSeg          ;look at all the handles in the ExpressLoad segment
1623 D5A2 60                    rts                            ;found the handle
1624 D5A3
1625 D5A3              walk_expressSeg  
1626 D5A3 20 44 D2              jsr   make_HET_ptr             ;make a pointer to the Header Entry Table
1627 D5A6
1628 D5A6 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
1629 D5A8 1A                    inc   a                        ;start from the last segment
1630 D5A9 1A                    inc   a
1631 D5AA AA                    tax   
1632 D5AB              @search_loop  
1633 D5AB 8A                    txa                            ;pass in the segment number
1634 D5AC F0 1F                 beq   @end_handle              ;sorry there is no segment by this name
1635 D5AE DA                    phx   
1636 D5AF 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
1637 D5B2 A0 04 00              ldy   #HET_Entry.SegHandle     ;see if this is a jump segment
1638 D5B5 B7 42                 lda   [HET_entry_ptr],y
1639 D5B7 C5 94                 cmp   seg_handle
1640 D5B9 D0 0B                 bne   @not_handle
1641 D5BB C8                    iny   
1642 D5BC C8                    iny   
1643 D5BD B7 42                 lda   [HET_entry_ptr],y
1644 D5BF C5 96                 cmp   seg_handle+2
1645 D5C1 D0 03                 bne   @not_handle
1646 D5C3 68                    pla                            ;this is the segment number
1647 D5C4 18                    clc   
1648 D5C5 60                    rts   
1649 D5C6              @not_handle  
1650 D5C6 FA                    plx   
1651 D5C7 CA                    dex                            ;back off by one and try again
1652 D5C8 E0 01 00              cpx   #$0001
1653 D5CB D0 DE                 bne   @search_loop
1654 D5CD              @end_handle  
1655 D5CD 38                    sec   
1656 D5CE 60                    rts   
1657 D5CF
1658 D5CF                       endp 
1659 D5CF
1660 D5CF                       TITLE ', ExpressLoad.a - get_seg_base'
1661 D5CF              ;====================================================================================================
1662 D5CF              ;get_seg_base:  Given a segment number this routine will setup segment_base
1663 D5CF              ;
1664 D5CF              ;Input:         A = segment_number
1665 D5CF              ;               X = undefined
1666 D5CF              ;               Y = undefined
1667 D5CF              ;               P = nvmxdizc
1668 D5CF              ;                   ..000...
1669 D5CF              ;               b = undefined
1670 D5CF              ;
1671 D5CF              ;               HET_ptr                 ;must be setup!
1672 D5CF              ;
1673 D5CF              ;Output:        A = undefined
1674 D5CF              ;               X = undefined
1675 D5CF              ;               Y = undefined
1676 D5CF              ;               P = nvmxdizc
1677 D5CF              ;                   ..000...
1678 D5CF              ;               b = k
1679 D5CF              ;
1680 D5CF              ;
1681 D5CF              ;====================================================================================================
1682 D5CF
1683 D5CF                       longa on
1684 D5CF                       longi on
1685 D5CF              get_seg_base proc 
1686 D5CF                       with DirectPage
1687 D5CF
1688 D5CF 3A                    dec   a                        ;HET table numbers are 0 thru (-n- minus 1)
1689 D5D0 3A                    dec   a                        ;allow for ExpressLoad segment
1690 D5D1
1691 D5D1 0A                    asl   a
1692 D5D2 0A                    asl   a
1693 D5D3 0A                    asl   a                        ;times 8 for HET entry size
1694 D5D4
1695 D5D4 1A                    inc   a                        ;add two to pass the segment count field
1696 D5D5 1A                    inc   a
1697 D5D6
1698 D5D6 18                    clc   
1699 D5D7 65 3E                 adc   HET_ptr                  ;make a pointer to the Entry
1700 D5D9 85 42                 sta   HET_entry_ptr            ;pointer to the entry itself
1701 D5DB A9 00 00              lda   #$0000
1702 D5DE 65 40                 adc   HET_ptr+2
1703 D5E0 85 44                 sta   HET_entry_ptr+2
1704 D5E2              ;
1705 D5E2              ;Now we need to setup our Base address for this segment
1706 D5E2              ;
1707 D5E2 A0 04 00              ldy   #HET_Entry.SegHandle     ;index to the handle
1708 D5E5 B7 42                 lda   [HET_entry_ptr],y
1709 D5E7 85 46                 sta   temp_handle
1710 D5E9 C8                    iny   
1711 D5EA C8                    iny   
1712 D5EB B7 42                 lda   [HET_entry_ptr],y
1713 D5ED 85 48                 sta   temp_handle+2
1714 D5EF              ;
1715 D5EF              ;Deref the handle to find out the base address
1716 D5EF              ;
1717 D5EF A0 02 00              ldy   #$0002
1718 D5F2 A7 46                 lda   [temp_handle]
1719 D5F4 85 74                 sta   segment_base             ;starting address of the segment
1720 D5F6 B7 46                 lda   [temp_handle],y
1721 D5F8 85 76                 sta   segment_base+2
1722 D5FA 05 74                 ora   segment_base             ;see if the segment has been purged!
1723 D5FC D0 05                 bne   @segment_alive           ;great.
1724 D5FE A9 01 11              lda   #seg_not_found
1725 D601 38                    sec   
1726 D602 60                    rts   
1727 D603              @segment_alive  
1728 D603 18                    clc   
1729 D604 60                    rts   
1730 D605
1731 D605                       TITLE ', ExpressLoad.a - Process_Reloc'
1732 D605              ;====================================================================================================
1733 D605              ;Process_Reloc: This routine is called to process the relocation dictionary of a segment
1734 D605              ;               ** NOTE ** This code changes the data bank register to the bank that
1735 D605              ;               contains the Relocation Dictionary.  This means all data access to data in
1736 D605              ;               our bank must use long addressing.
1737 D605              ;
1738 D605              ;Input:         A = segment number to relocate
1739 D605              ;               X = undefined
1740 D605              ;               Y = undefined
1741 D605              ;               P = nvmxdizc
1742 D605              ;                   ..000...
1743 D605              ;               b = k
1744 D605              ;
1745 D605              ;               HET_ptr                 ;pointer to HET (Header Entry Table) must be setup!
1746 D605              ;
1747 D605              ;Output:        A = undefined
1748 D605              ;               X = undefined
1749 D605              ;               Y = undefined
1750 D605              ;               P = nvmxdizc
1751 D605              ;                   ..000...
1752 D605              ;               b = k
1753 D605              ;
1754 D605              ;
1755 D605              ;
1756 D605              ;-Note-
1757 D605              ;               All Segments that this segment links to must be loaded into memory
1758 D605              ;
1759 D605              ;HET Entry definition:
1760 D605              ;
1761 D605              ;               -------------------
1762 D605              ;               Number of segments      (word)
1763 D605              ;               -------------------
1764 D605              ;                       •
1765 D605              ;                       •
1766 D605              ;                       •
1767 D605              ;               -------------------     [This is one Header Entry, it is repeated -n- times]
1768 D605              ;               Relative offset to
1769 D605              ;               segment header          (word)
1770 D605              ;               -------------------
1771 D605              ;               Flags                   (word) Bit 15 = loaded
1772 D605              ;               -------------------
1773 D605              ;               Handle to segment       (Long) Points to the segment in memory
1774 D605              ;               -------------------
1775 D605              ;                       •
1776 D605              ;                       •
1777 D605              ;                       •
1778 D605              ;
1779 D605              ;====================================================================================================
1780 D605
1781 D605                       longa on
1782 D605                       longi on
1783 D605              Process_Reloc proc 
1784 D605                       with DirectPage, Globals
1785 D605
1786 D605              ;        sta   reloc_seg                ;segment numbers are 1 thru -n-
1787 D605 20 5E D2              jsr   setup_seg_ptrs           ;build pointers to the segment entries
1788 D608
1789 D608              ;
1790 D608              ;Now we need to setup our Base address for this segment
1791 D608              ;
1792 D608 A0 04 00              ldy   #HET_Entry.SegHandle     ;index to the handle
1793 D60B B7 42                 lda   [HET_entry_ptr],y
1794 D60D 85 46                 sta   temp_handle
1795 D60F C8                    iny   
1796 D610 C8                    iny   
1797 D611 B7 42                 lda   [HET_entry_ptr],y
1798 D613 85 48                 sta   temp_handle+2
1799 D615              ;
1800 D615              ;Deref the handle to find out the base address
1801 D615              ;
1802 D615 A0 02 00              ldy   #$0002
1803 D618 A7 46                 lda   [temp_handle]
1804 D61A 85 4A                 sta   base_ptr                 ;starting address of the segment
1805 D61C B7 46                 lda   [temp_handle],y
1806 D61E 85 4C                 sta   base_ptr+2
1807 D620 05 4A                 ora   base_ptr                 ;see if the segment has been purged!
1808 D622 D0 05                 bne   @segment_alive           ;great.
1809 D624              @no_seg   
1810 D624 38                    sec   
1811 D625 A9 01 11              lda   #seg_not_found           ;sorry we cannot process the segment
1812 D628 60                    rts   
1813 D629              ;
1814 D629              ;Now we need to deref the handle to the relocation dictionary
1815 D629              ;The handle for the relocation dictionary is located in the segment header
1816 D629              ;
1817 D629              @segment_alive  
1818 D629 A0 0C 00              ldy   #SegHeaderEntry.RelocDict_Length ;now lets get the size of the segment
1819 D62C B7 4E                 lda   [seg_header_ptr],y
1820 D62E D0 08                 bne   @its_there
1821 D630 C8                    iny   
1822 D631 C8                    iny   
1823 D632 B7 4E                 lda   [seg_header_ptr],y
1824 D634 D0 02                 bne   @its_there
1825 D636 18                    clc   
1826 D637 60                    rts                            ;easy case
1827 D638              @its_there  
1828 D638 A0 2E 00              ldy   #SegHeaderEntry.RelocDict_Hndl ;offset to the relocation dictionary handle
1829 D63B B7 4E                 lda   [seg_header_ptr],y       ;get the handle
1830 D63D 85 46                 sta   temp_handle
1831 D63F C8                    iny   
1832 D640 C8                    iny   
1833 D641 B7 4E                 lda   [seg_header_ptr],y
1834 D643 85 48                 sta   temp_handle+2
1835 D645              ;
1836 D645              ;now lets deref the handle and build a pointer to the relocation dictionary
1837 D645              ;
1838 D645 A0 02 00              ldy   #$0002
1839 D648 A7 46                 lda   [temp_handle]
1840 D64A 85 52                 sta   reloc_dict_ptr           ;points the relocation dictionary in memory
1841 D64C B7 46                 lda   [temp_handle],y
1842 D64E 85 54                 sta   reloc_dict_ptr+2
1843 D650 05 52                 ora   reloc_dict_ptr           ;is the dictionary available
1844 D652 F0 D0                 beq   @no_seg
1845 D654 64 56                 stz   patch_cnt
1846 D656 64 58                 stz   shift_cnt
1847 D658
1848 D658 A5 53                 lda   reloc_dict_ptr+1         ;set the data bank register to relocation dictionary
1849 D65A 48                    pha   
1850 D65B AB                    plb                            ;get the Bank Address of Relocation Dictionary
1851 D65C AB                    plb   
1852 D65D              opcode_loop  
1853 D65D B2 52                 lda   (reloc_dict_ptr)         ;get the current opcode
1854 D65F 29 FF 00              and   #$00FF                   ;clear any garbage
1855 D662 F0 17                 beq   do_end_handler           ;this is the end handler
1856 D664 C9 E2 00              cmp   #$00E2                   ;valid record?
1857 D667 90 05                 bcc   @invalid_record          ;no...
1858 D669 C9 F8 00              cmp   #$F8
1859 D66C 90 03                 bcc   @good_record
1860 D66E              @invalid_record  
1861 D66E A9 E4 00              lda   #$00E4                   ;translate into another invalid number
1862 D671              @good_record  
1863 D671 0A                    asl   a                        ;times two for word table
1864 D672 AA                    tax   
1865 D673 FC E7 D4              jsr   (opcode_handlers-$1C4,x) ;Subtract of base of opcodes ($1C4 = $E2*2)
1866 D676 90 E5                 bcc   opcode_loop              ;do the next opcode please
1867 D678 4B                    phk   
1868 D679 AB                    plb                            ;restore our bank
1869 D67A 60                    rts                            ;return the error code
1870 D67B
1871 D67B              ;
1872 D67B              ;This routine dispatches to the correct opcode handler
1873 D67B              ;
1874 D67B              do_end_handler  
1875 D67B F4 81 D6              pea   we_are_done-1            ;this is the last one!
1876 D67E F4 44 DA              pea   end_handler-1
1877 D681 60                    rts   
1878 D682              we_are_done  
1879 D682 4B                    phk   
1880 D683 AB                    plb                            ;restore our bank please
1881 D684
1882 D684 A0 30 00              ldy   #SegHeaderEntry.RelocDict_Hndl+2 ;offset to the relocation dictionary handle
1883 D687 B7 4E                 lda   [seg_header_ptr],y       ;get the handle
1884 D689 48                    pha   
1885 D68A A9 00 00              lda   #$0000
1886 D68D 97 4E                 sta   [seg_header_ptr],y
1887 D68F 88                    dey   
1888 D690 88                    dey   
1889 D691 B7 4E                 lda   [seg_header_ptr],y
1890 D693 48                    pha   
1891 D694 A9 00 00              lda   #$0000
1892 D697 97 4E                 sta   [seg_header_ptr],y
1893 D699
1894 D699 A2 02 10 22           _DisposeHandle 
1895 D6A0
1896 D6A0 64 46                 stz   temp_handle              ;make sure we note that the handle is invalid
1897 D6A2 64 48                 stz   temp_handle+2
1898 D6A4
1899 D6A4 18                    clc   
1900 D6A5 60                    rts                            ;we did it!!!!
1901 D6A6
1902 D6A6              bad_opcode  
1903 D6A6 38                    sec   
1904 D6A7 A9 0A 11              lda   #illegal_record
1905 D6AA 60                    rts                            ;exit with error
1906 D6AB
1907 D6AB
1908 D6AB              opcode_handlers  
1909 D6AB D7 D6                 DC W:Reloc_handler             ;$E2
1910 D6AD 62 D7                 DC W:Interseg_handler          ;$E3
1911 D6AF A6 D6                 DC W:bad_opcode                ;$E4
1912 D6B1 A6 D6                 DC W:bad_opcode                ;$E5
1913 D6B3 A6 D6                 DC W:bad_opcode                ;$E6
1914 D6B5 A6 D6                 DC W:bad_opcode                ;$E7
1915 D6B7 A6 D6                 DC W:bad_opcode                ;$E8
1916 D6B9 A6 D6                 DC W:bad_opcode                ;$E9
1917 D6BB A6 D6                 DC W:bad_opcode                ;$EA
1918 D6BD A6 D6                 DC W:bad_opcode                ;$EB
1919 D6BF A6 D6                 DC W:bad_opcode                ;$EC
1920 D6C1 A6 D6                 DC W:bad_opcode                ;$ED
1921 D6C3 A6 D6                 DC W:bad_opcode                ;$EE
1922 D6C5 A6 D6                 DC W:bad_opcode                ;$EF
1923 D6C7 A6 D6                 DC W:bad_opcode                ;$F0
1924 D6C9 A6 D6                 DC W:bad_opcode                ;$F1
1925 D6CB A6 D6                 DC W:bad_opcode                ;$F2
1926 D6CD A6 D6                 DC W:bad_opcode                ;$F3
1927 D6CF A6 D6                 DC W:bad_opcode                ;$F4
1928 D6D1 1F D7                 DC W:cReloc_handler            ;$F5
1929 D6D3 C5 D7                 DC W:cInterseg_handler         ;$F6
1930 D6D5 17 D8                 DC W:super_handler             ;$F7
1931 D6D7
1932 D6D7                       TITLE ', ExpressLoad.a - Reloc_handler'
1933 D6D7              ;====================================================================================================
1934 D6D7              ;
1935 D6D7              ;This routine will process a standard relocation entry
1936 D6D7              ;
1937 D6D7              ;Structure pointed to by Reloc_dict_ptr
1938 D6D7              ;
1939 D6D7              ;               opcode $E2      (1 Byte)
1940 D6D7              ;               patch_cnt       (1 byte: number of bytes to patch)
1941 D6D7              ;               bit_shift       (1 byte: (+) = ASL (-) = LSR
1942 D6D7              ;               patch_offset    (4 bytes: offset from the start of the segment)
1943 D6D7              ;               patch_value     (4 bytes: offset from the start of the segment)
1944 D6D7              ;
1945 D6D7              ;====================================================================================================
1946 D6D7
1947 D6D7              Reloc_handler  
1948 D6D7 A0 01 00              ldy   #$0001
1949 D6DA B1 52                 lda   (reloc_dict_ptr),y       ;get the patch cnt and bit shift
1950 D6DC E2 20                 sep   #$20
1951 D6DE 85 56                 sta   patch_cnt                ;the number of bytes to patch 1,2 or 3
1952 D6E0 EB                    xba   
1953 D6E1 85 58                 sta   shift_cnt
1954 D6E3 C2 20                 rep   #$20                     ;back to 16 bit mode
1955 D6E5
1956 D6E5 A0 03 00              ldy   #$0003                   ;point to the patch offset
1957 D6E8 18                    clc   
1958 D6E9 B1 52                 lda   (reloc_dict_ptr),y
1959 D6EB 65 4A                 adc   base_ptr                 ;base address
1960 D6ED 85 5A                 sta   patch_ptr                ;address to patch
1961 D6EF A0 05 00              ldy   #$0005
1962 D6F2 B1 52                 lda   (reloc_dict_ptr),y
1963 D6F4 65 4C                 adc   base_ptr+2
1964 D6F6 85 5C                 sta   patch_ptr+2              ;high word of patch address
1965 D6F8
1966 D6F8 A0 07 00              ldy   #$0007                   ;point to the patch value field
1967 D6FB 18                    clc   
1968 D6FC B1 52                 lda   (reloc_dict_ptr),y
1969 D6FE 65 4A                 adc   base_ptr
1970 D700 85 5E                 sta   patch_value
1971 D702 A0 09 00              ldy   #$0009
1972 D705 B1 52                 lda   (reloc_dict_ptr),y
1973 D707 65 4C                 adc   base_ptr+2
1974 D709 85 60                 sta   patch_value+2            ;what we will patch with
1975 D70B
1976 D70B 18                    clc   
1977 D70C A5 52                 lda   reloc_dict_ptr           ;bump the relocation dictionary pointer please
1978 D70E 69 0B 00              adc   #$000b
1979 D711 85 52                 sta   reloc_dict_ptr
1980 D713 90 07                 bcc   @low_only
1981 D715 E6 54                 inc   reloc_dict_ptr+2         ;don't forget the high byte please
1982 D717 A5 53                 lda   reloc_dict_ptr+1
1983 D719 48                    pha   
1984 D71A AB                    plb   
1985 D71B AB                    plb                            ;setup for the new bank please
1986 D71C              @low_only  
1987 D71C 4C 46 DA              jmp   shift_patch              ;the the patch please
1988 D71F
1989 D71F                       TITLE ', ExpressLoad.a - cReloc_handler'
1990 D71F              ;====================================================================================================
1991 D71F              ;
1992 D71F              ;This routine will process a compressed relocation entry
1993 D71F              ;
1994 D71F              ;Structure pointed to by Reloc_dict_ptr
1995 D71F              ;
1996 D71F              ;               opcode $F5      (1 Byte)
1997 D71F              ;               patch_cnt       (1 byte: number of bytes to patch)
1998 D71F              ;               bit_shift       (1 byte: (+) = ASL (-) = LSR
1999 D71F              ;               patch_offset    (2 bytes: offset from the start of the segment)
2000 D71F              ;               patch_value     (2 bytes: offset from the start of the segment)
2001 D71F              ;
2002 D71F              ;====================================================================================================
2003 D71F
2004 D71F              cReloc_handler  
2005 D71F A0 01 00              ldy   #$0001
2006 D722 B1 52                 lda   (reloc_dict_ptr),y       ;get the patch cnt and bit shift
2007 D724 E2 20                 sep   #$20
2008 D726 85 56                 sta   patch_cnt                ;the number of bytes to patch 1,2 or 3
2009 D728 EB                    xba   
2010 D729 85 58                 sta   shift_cnt
2011 D72B C2 20                 rep   #$20                     ;back to 16 bit mode
2012 D72D
2013 D72D A0 03 00              ldy   #$0003                   ;point the patch offset
2014 D730 18                    clc   
2015 D731 B1 52                 lda   (reloc_dict_ptr),y
2016 D733 65 4A                 adc   base_ptr                 ;base address
2017 D735 85 5A                 sta   patch_ptr                ;address to patch
2018 D737 A9 00 00              lda   #$0000
2019 D73A 65 4C                 adc   base_ptr+2
2020 D73C 85 5C                 sta   patch_ptr+2              ;high word of patch address
2021 D73E
2022 D73E A0 05 00              ldy   #$0005                   ;point to the patch value field
2023 D741 18                    clc   
2024 D742 B1 52                 lda   (reloc_dict_ptr),y
2025 D744 65 4A                 adc   base_ptr
2026 D746 85 5E                 sta   patch_value
2027 D748 A9 00 00              lda   #$0000
2028 D74B 65 4C                 adc   base_ptr+2
2029 D74D 85 60                 sta   patch_value+2            ;what we will patch with
2030 D74F
2031 D74F 18                    clc   
2032 D750 A5 52                 lda   reloc_dict_ptr           ;bump the relocation dictionary pointer please
2033 D752 69 07 00              adc   #$0007
2034 D755 85 52                 sta   reloc_dict_ptr
2035 D757 90 06                 bcc   @low_only
2036 D759 E6 54                 inc   reloc_dict_ptr+2         ;don't forget the high byte please
2037 D75B D4 53                 pei   reloc_dict_ptr+1
2038 D75D AB                    plb   
2039 D75E AB                    plb                            ;setup for the new bank please
2040 D75F              @low_only  
2041 D75F 4C 46 DA              jmp   shift_patch              ;the the patch please
2042 D762
2043 D762                       TITLE ', ExpressLoad.a - Interseg_handler'
2044 D762              ;====================================================================================================
2045 D762              ;
2046 D762              ;This routine will process a Interseg relocation entry
2047 D762              ;
2048 D762              ;Structure pointed to by Reloc_dict_ptr
2049 D762              ;
2050 D762              ;               opcode $E3      (1 Byte)
2051 D762              ;               patch_cnt       (1 byte: number of bytes to patch)
2052 D762              ;               bit_shift       (1 byte: (+) = ASL (-) = LSR
2053 D762              ;               patch_offset    (4 bytes: offset from the start of the segment)
2054 D762              ;               file number     (2 bytes: file number of load file: not supported yet)
2055 D762              ;               segment number  (2 bytes: segment that we are linking to)
2056 D762              ;               patch_value     (4 bytes: offset from the start of the destination segment)
2057 D762              ;
2058 D762              ;====================================================================================================
2059 D762              Interseg_handler  
2060 D762 A0 01 00              ldy   #$0001
2061 D765 B1 52                 lda   (reloc_dict_ptr),y       ;get the patch cnt and bit shift
2062 D767 E2 20                 sep   #$20
2063 D769 85 56                 sta   patch_cnt                ;the number of bytes to patch 1,2 or 3
2064 D76B EB                    xba   
2065 D76C 85 58                 sta   shift_cnt
2066 D76E C2 20                 rep   #$20                     ;back to 16 bit mode
2067 D770
2068 D770 A0 03 00              ldy   #$0003                   ;point the patch offset
2069 D773 18                    clc   
2070 D774 B1 52                 lda   (reloc_dict_ptr),y
2071 D776 65 4A                 adc   base_ptr                 ;base address
2072 D778 85 5A                 sta   patch_ptr                ;address to patch
2073 D77A A0 05 00              ldy   #$0005
2074 D77D B1 52                 lda   (reloc_dict_ptr),y
2075 D77F 65 4C                 adc   base_ptr+2
2076 D781 85 5C                 sta   patch_ptr+2              ;high word of patch address
2077 D783
2078 D783 A0 07 00              ldy   #$0007                   ;now lets point to the file number
2079 D786 B1 52                 lda   (reloc_dict_ptr),y
2080 D788 3A                    dec   a                        ;better be one
2081 D789 F0 05                 beq   @great
2082 D78B 38                    sec   
2083 D78C A9 0A 11              lda   #illegal_record
2084 D78F 60                    rts                            ;return the error
2085 D790              @great    
2086 D790 A0 09 00              ldy   #$0009                   ;get the segment number
2087 D793 B1 52                 lda   (reloc_dict_ptr),y
2088 D795 29 FF 00              and   #$00FF
2089 D798 20 CF D5              jsr   get_seg_base
2090 D79B 90 01                 bcc   @got_it
2091 D79D 60                    rts   
2092 D79E              @got_it   
2093 D79E A0 0B 00              ldy   #$000B                   ;offset to relative address in destination seg
2094 D7A1 18                    clc   
2095 D7A2 B1 52                 lda   (reloc_dict_ptr),y
2096 D7A4 65 74                 adc   segment_base
2097 D7A6 85 5E                 sta   patch_value
2098 D7A8 A0 0D 00              ldy   #$000D
2099 D7AB B1 52                 lda   (reloc_dict_ptr),y
2100 D7AD 65 76                 adc   segment_base+2
2101 D7AF 85 60                 sta   patch_value+2
2102 D7B1
2103 D7B1 18                    clc   
2104 D7B2 A5 52                 lda   reloc_dict_ptr           ;bump the relocation dictionary pointer please
2105 D7B4 69 0F 00              adc   #$000F
2106 D7B7 85 52                 sta   reloc_dict_ptr
2107 D7B9 90 07                 bcc   @low_only
2108 D7BB E6 54                 inc   reloc_dict_ptr+2         ;don't forget the high byte please
2109 D7BD A5 53                 lda   reloc_dict_ptr+1
2110 D7BF 48                    pha   
2111 D7C0 AB                    plb   
2112 D7C1 AB                    plb                            ;setup for the new bank please
2113 D7C2              @low_only  
2114 D7C2 4C 46 DA              jmp   shift_patch              ;patch the segment please
2115 D7C5
2116 D7C5                       TITLE ', ExpressLoad.a - cInterseg_handler'
2117 D7C5              ;====================================================================================================
2118 D7C5              ;
2119 D7C5              ;This routine will process a compressed Interseg relocation entry
2120 D7C5              ;
2121 D7C5              ;Structure pointed to by Reloc_dict_ptr
2122 D7C5              ;
2123 D7C5              ;               opcode $F6      (1 Byte)
2124 D7C5              ;               patch_cnt       (1 byte: number of bytes to patch)
2125 D7C5              ;               bit_shift       (1 byte: (+) = ASL (-) = LSR
2126 D7C5              ;               patch_offset    (2 bytes: offset from the start of the segment)
2127 D7C5              ;               segment number  (1 bytes: segment that we are linking to)
2128 D7C5              ;               patch_value     (2 bytes: offset from the start of the destination segment)
2129 D7C5              ;
2130 D7C5              ;====================================================================================================
2131 D7C5              cInterseg_handler  
2132 D7C5 A0 01 00              ldy   #$0001
2133 D7C8 B1 52                 lda   (reloc_dict_ptr),y       ;get the patch cnt and bit shift
2134 D7CA E2 20                 sep   #$20
2135 D7CC 85 56                 sta   patch_cnt                ;the number of bytes to patch 1,2 or 3
2136 D7CE EB                    xba   
2137 D7CF 85 58                 sta   shift_cnt
2138 D7D1 C2 20                 rep   #$20                     ;back to 16 bit mode
2139 D7D3
2140 D7D3 A0 03 00              ldy   #$0003                   ;point the patch offset
2141 D7D6 18                    clc   
2142 D7D7 B1 52                 lda   (reloc_dict_ptr),y
2143 D7D9 65 4A                 adc   base_ptr                 ;base address
2144 D7DB 85 5A                 sta   patch_ptr                ;address to patch
2145 D7DD A9 00 00              lda   #$0000
2146 D7E0 65 4C                 adc   base_ptr+2
2147 D7E2 85 5C                 sta   patch_ptr+2              ;high word of patch address
2148 D7E4
2149 D7E4 A0 05 00              ldy   #$0005                   ;get the segment number
2150 D7E7 B1 52                 lda   (reloc_dict_ptr),y
2151 D7E9 29 FF 00              and   #$00FF                   ;one byte segment number
2152 D7EC 20 CF D5              jsr   get_seg_base
2153 D7EF 90 01                 bcc   @got_it
2154 D7F1 60                    rts   
2155 D7F2              @got_it   
2156 D7F2 A0 06 00              ldy   #$0006                   ;offset to relative address in destination seg
2157 D7F5 18                    clc   
2158 D7F6 B1 52                 lda   (reloc_dict_ptr),y
2159 D7F8 65 74                 adc   segment_base
2160 D7FA 85 5E                 sta   patch_value
2161 D7FC A9 00 00              lda   #$0000
2162 D7FF 65 76                 adc   segment_base+2
2163 D801 85 60                 sta   patch_value+2
2164 D803
2165 D803 18                    clc   
2166 D804 A5 52                 lda   reloc_dict_ptr           ;bump the relocation dictionary pointer please
2167 D806 69 08 00              adc   #$0008
2168 D809 85 52                 sta   reloc_dict_ptr
2169 D80B 90 07                 bcc   @low_only
2170 D80D E6 54                 inc   reloc_dict_ptr+2         ;don't forget the high byte please
2171 D80F A5 53                 lda   reloc_dict_ptr+1
2172 D811 48                    pha   
2173 D812 AB                    plb   
2174 D813 AB                    plb                            ;setup for the new bank please
2175 D814              @low_only  
2176 D814 4C 46 DA              jmp   shift_patch              ;patch the segment please
2177 D817
2178 D817                       TITLE ', ExpressLoad.a - super_handler'
2179 D817              ;====================================================================================================
2180 D817              ;super_handler  This one is a bitch.
2181 D817              ;
2182 D817              ;There are several types of super records.  Below is the list that I support.
2183 D817              ;
2184 D817              ;       1)      Reloc2
2185 D817              ;       2)      Reloc3
2186 D817              ;       3)      Interseg1-Interseg36
2187 D817              ;
2188 D817              ;
2189 D817              ;Super record structure:
2190 D817              ;
2191 D817              ;               opcode  $F7             ;byte
2192 D817              ;               ------------------------
2193 D817              ;               size of record          ;long
2194 D817              ;               ------------------------
2195 D817              ;               record type             ;byte
2196 D817              ;               ------------------------
2197 D817              ;               patch info: example
2198 D817              ;
2199 D817              ;               $01                     ;patch two bytes in page one of load segment
2200 D817              ;               $34                     ;offset to 1st byte in page one of load segment
2201 D817              ;               $7A                     ;offset to 2nd byte in page one of load segment
2202 D817              ;               $81                     ;skip 1 page. (High bit means lower 7 bits contain skip cnt)
2203 D817              ;               $00                     ;patch one byte in page three of load segment
2204 D817              ;               $82                     ;offset in page three to patch
2205 D817              ;
2206 D817              ;====================================================================================================
2207 D817              super_handler  
2208 D817 A5 4A                 lda   base_ptr                 ;address of the segment
2209 D819 85 62                 sta   temp_ptr
2210 D81B A5 4C                 lda   base_ptr+2
2211 D81D 85 64                 sta   temp_ptr+2
2212 D81F
2213 D81F 18                    clc   
2214 D820 A5 52                 lda   reloc_dict_ptr
2215 D822 69 06 00              adc   #$0006                   ;pass the record type
2216 D825 85 6E                 sta   super_ptr
2217 D827 A5 54                 lda   reloc_dict_ptr+2
2218 D829 69 00 00              adc   #$0000
2219 D82C 85 70                 sta   super_ptr+2
2220 D82E
2221 D82E A0 01 00              ldy   #$0001                   ;get the total count of entries please
2222 D831 B1 52                 lda   (reloc_dict_ptr),y       ;get the size of the Super Record
2223 D833 85 6A                 sta   super_size
2224 D835 3A                    dec   a                        ;remove one for the opcode byte
2225 D836 85 6C                 sta   cnt_word
2226 D838 A0 03 00              ldy   #$0003
2227 D83B B1 52                 lda   (reloc_dict_ptr),y       ;fail if non-zero
2228 D83D F0 05                 beq   @size_ok
2229 D83F 38                    sec   
2230 D840 A9 0A 11              lda   #illegal_record
2231 D843 60                    rts                            ;return the error
2232 D844              @size_ok  
2233 D844 A0 05 00              ldy   #$0005                   ;pass the size field
2234 D847 B1 52                 lda   (reloc_dict_ptr),y
2235 D849 29 FF 00              and   #$00FF                   ;clear the garbage
2236 D84C AA                    tax   
2237 D84D F0 1D                 beq   @reloc2_type             ;do a reloc 2 type
2238 D84F 3A                    dec   a
2239 D850 F0 1F                 beq   @reloc3_type
2240 D852              ;
2241 D852              ;If we get here we know that this is an Interseg Record of some kind
2242 D852              ;
2243 D852 8A                    txa                            ;get back the kind again
2244 D853 C9 1A 00              cmp   #26
2245 D856 90 05                 bcc   @chk_14
2246 D858
2247 D858 20 56 D9              jsr   Interseg_26
2248 D85B 80 17                 bra   @end_super               ;we are done
2249 D85D              @chk_14   
2250 D85D C9 0E 00              cmp   #14
2251 D860 90 05                 bcc   @one_thru_12
2252 D862
2253 D862 20 00 D9              jsr   Interseg_14              ;do the conversion
2254 D865 80 0D                 bra   @end_super
2255 D867              @one_thru_12  
2256 D867 20 8B D8              jsr   Interseg_1
2257 D86A 80 08                 bra   @end_super
2258 D86C              @reloc2_type  
2259 D86C 20 B5 D9              jsr   reloc2
2260 D86F 80 03                 bra   @end_super
2261 D871              @reloc3_type  
2262 D871 20 F7 D9              jsr   reloc3
2263 D874
2264 D874              @end_super  
2265 D874 B0 14                 bcs   @abort
2266 D876 A5 6A                 lda   super_size               ;size of the data area
2267 D878 69 05 00              adc   #$0005                   ;overhead in record
2268 D87B 18                    clc   
2269 D87C 65 52                 adc   reloc_dict_ptr           ;bump the relocation dictionary pointer please
2270 D87E 85 52                 sta   reloc_dict_ptr
2271 D880 90 07                 bcc   @low_only
2272 D882 E6 54                 inc   reloc_dict_ptr+2         ;don't forget the high byte please
2273 D884 A5 53                 lda   reloc_dict_ptr+1
2274 D886 48                    pha   
2275 D887 AB                    plb   
2276 D888 AB                    plb                            ;setup for the new bank please
2277 D889              @low_only  
2278 D889 18                    clc   
2279 D88A              @abort    
2280 D88A 60                    rts   
2281 D88B
2282 D88B                       TITLE ', ExpressLoad.a - Interseg_1'
2283 D88B              ;====================================================================================================
2284 D88B              ;Interseg1      This routine is used to patch Super interseg records 1 thru 12:
2285 D88B              ;
2286 D88B              ;structure:
2287 D88B              ;
2288 D88B              ;               If the opcode field is 3 thru 13 then this value indicates
2289 D88B              ;               the file number (plus 1) to load from.  I do not support this.
2290 D88B              ;
2291 D88B              ;               relocation information is in the operand field of load segment.
2292 D88B              ;               Format:
2293 D88B              ;                       Offset          ;word
2294 D88B              ;                       segment number  ;byte number of segment to link to.
2295 D88B              ;
2296 D88B              ;
2297 D88B              ;====================================================================================================
2298 D88B              Interseg_1  
2299 D88B A0 05 00              ldy   #$0005                   ;lets get the segment number
2300 D88E B1 52                 lda   (reloc_dict_ptr),y
2301 D890 29 FF 00              and   #$00FF                   ;get the record type
2302 D893 C9 03 00              cmp   #$0003                   ;is the number 2 thru 12?
2303 D896 90 03                 bcc   @good_seg
2304 D898 A9 0A 11              lda   #illegal_record          ;sorry illegal record type
2305 D89B              @good_seg  
2306 D89B A0 00 00              ldy   #$0000
2307 D89E
2308 D89E A5 6C                 lda   cnt_word                 ;see if we are done yet
2309 D8A0 F0 19                 beq   @done
2310 D8A2              @outter_loop  
2311 D8A2 B7 6E                 lda   [super_ptr],y            ;get the command (8 Bits)
2312 D8A4 89 80 00              bit   #$0080                   ;clear all but the pages bit
2313 D8A7 F0 14                 beq   @do_inner_loop           ;process the relocation info
2314 D8A9 29 7F 00              and   #$007F                   ;get the number of pages to skip
2315 D8AC
2316 D8AC EB                    xba                            ;multiply the number times 256
2317 D8AD 18                    clc   
2318 D8AE 65 62                 adc   temp_ptr
2319 D8B0 85 62                 sta   temp_ptr
2320 D8B2 90 02                 bcc   @low_only
2321 D8B4 E6 64                 inc   temp_ptr+2
2322 D8B6              @low_only  
2323 D8B6 C8                    iny                            ;bump index to the next byte
2324 D8B7 C6 6C                 dec   cnt_word                 ;reduce the count by one
2325 D8B9 D0 E7                 bne   @outter_loop
2326 D8BB              @done     
2327 D8BB 18                    clc   
2328 D8BC 60                    rts                            ;we are done
2329 D8BD
2330 D8BD
2331 D8BD              @do_inner_loop  
2332 D8BD 29 7F 00              and   #$007F                   ;number of entries we have to patch
2333 D8C0 AA                    tax   
2334 D8C1              @inner_loop  
2335 D8C1 C6 6C                 dec   cnt_word                 ;reduce the count by one
2336 D8C3 C8                    iny                            ;bump index to the next byte
2337 D8C4
2338 D8C4 B7 6E                 lda   [super_ptr],y            ;A = offset
2339 D8C6 29 FF 00              and   #$00FF                   ;clear garbage
2340 D8C9 5A                    phy                            ;save the index please
2341 D8CA
2342 D8CA A8                    tay   
2343 D8CB 5A                    phy                            ;index to patch area
2344 D8CC
2345 D8CC B7 62                 lda   [temp_ptr],y             ;get the relative offset in other segment
2346 D8CE 85 5E                 sta   patch_value
2347 D8D0 C8                    iny   
2348 D8D1 C8                    iny   
2349 D8D2 B7 62                 lda   [temp_ptr],y             ;get the segment number to patch to
2350 D8D4 29 FF 00              and   #$00FF
2351 D8D7 20 CF D5              jsr   get_seg_base             ;go and get the segment base address
2352 D8DA 7A                    ply                            ;get our index back please
2353 D8DB 90 02                 bcc   @have_segment
2354 D8DD 7A                    ply                            ;remove super index please
2355 D8DE 60                    rts                            ;return the error
2356 D8DF              @have_segment  
2357 D8DF 18                    clc   
2358 D8E0 A5 74                 lda   segment_base
2359 D8E2 65 5E                 adc   patch_value
2360 D8E4 97 62                 sta   [temp_ptr],y
2361 D8E6 C8                    iny   
2362 D8E7 C8                    iny   
2363 D8E8 A5 76                 lda   segment_base+2
2364 D8EA 69 00 00              adc   #$0000
2365 D8ED E2 20                 sep   #$20                     ;8 bit store only
2366 D8EF 97 62                 sta   [temp_ptr],y             ;save the new address please
2367 D8F1 C2 20                 rep   #$20                     ;16 bit mode
2368 D8F3
2369 D8F3 7A                    ply                            ;restore super index
2370 D8F4 CA                    dex   
2371 D8F5 10 CA                 bpl   @inner_loop              ;process this page
2372 D8F7
2373 D8F7 C8                    iny                            ;bump to next byte
2374 D8F8 E6 63                 inc   temp_ptr+1               ;add 256 to the page pointer
2375 D8FA C6 6C                 dec   cnt_word                 ;reduce the count by one
2376 D8FC D0 A4                 bne   @outter_loop
2377 D8FE 18                    clc   
2378 D8FF 60                    rts   
2379 D900
2380 D900                       TITLE ', ExpressLoad.a - Interseg_14'
2381 D900              ;====================================================================================================
2382 D900              ;Interseg_14    This routine processes interseg 14 thru interseg 24 types.
2383 D900              ;               This type allows a 16 bit patch with no shifting.
2384 D900              ;
2385 D900              ;Structure:
2386 D900              ;
2387 D900              ;               The segment number to process is in the opcode byte.  To determine
2388 D900              ;               the real segment number just subtract 13 from the stored value.
2389 D900              ;
2390 D900              ;====================================================================================================
2391 D900              Interseg_14  
2392 D900 A0 05 00              ldy   #$0005                   ;lets get the segment number
2393 D903 38                    sec   
2394 D904 B1 52                 lda   (reloc_dict_ptr),y
2395 D906 29 FF 00              and   #$00FF                   ;get the record type
2396 D909 E9 0D 00              sbc   #13
2397 D90C 20 CF D5              jsr   get_seg_base             ;setup the base address for this segment
2398 D90F A0 00 00              ldy   #$0000                   ;init super index
2399 D912 90 01                 bcc   @continue
2400 D914 60                    rts                            ;return the error
2401 D915
2402 D915              @continue  
2403 D915 A5 6C                 lda   cnt_word                 ;see if we are done yet
2404 D917 F0 19                 beq   @done
2405 D919              @outter_loop  
2406 D919 B7 6E                 lda   [super_ptr],y            ;get the command (8 Bits)
2407 D91B 89 80 00              bit   #$0080                   ;clear all but the pages bit
2408 D91E F0 14                 beq   @do_inner_loop           ;process the relocation info
2409 D920 29 7F 00              and   #$007F                   ;get the number of pages to skip
2410 D923
2411 D923 EB                    xba                            ;multiply the number times 256
2412 D924 18                    clc   
2413 D925 65 62                 adc   temp_ptr
2414 D927 85 62                 sta   temp_ptr
2415 D929 90 02                 bcc   @low_only
2416 D92B E6 64                 inc   temp_ptr+2
2417 D92D              @low_only  
2418 D92D C8                    iny                            ;bump index to the next byte
2419 D92E C6 6C                 dec   cnt_word                 ;reduce the count by one
2420 D930 D0 E7                 bne   @outter_loop
2421 D932              @done     
2422 D932 18                    clc   
2423 D933 60                    rts   
2424 D934
2425 D934              @do_inner_loop  
2426 D934 29 7F 00              and   #$007F                   ;number of entries we have to patch
2427 D937 AA                    tax   
2428 D938              @inner_loop  
2429 D938 C6 6C                 dec   cnt_word                 ;reduce the count by one
2430 D93A C8                    iny                            ;point to the next byte
2431 D93B
2432 D93B B7 6E                 lda   [super_ptr],y            ;A = offset
2433 D93D 29 FF 00              and   #$00FF                   ;clear garbage
2434 D940 5A                    phy                            ;save super index
2435 D941 A8                    tay                            ;build patch record index
2436 D942
2437 D942 18                    clc                            ;do the 16 bit patch
2438 D943 B7 62                 lda   [temp_ptr],y             ;get the relative offset in other segment
2439 D945 65 74                 adc   segment_base
2440 D947 97 62                 sta   [temp_ptr],y
2441 D949
2442 D949 7A                    ply                            ;get back super index
2443 D94A CA                    dex   
2444 D94B 10 EB                 bpl   @inner_loop              ;process this page
2445 D94D
2446 D94D C8                    iny                            ;point to the next byte
2447 D94E E6 63                 inc   temp_ptr+1               ;point to the next page please
2448 D950 C6 6C                 dec   cnt_word                 ;reduce the count by one
2449 D952 D0 C5                 bne   @outter_loop
2450 D954 18                    clc   
2451 D955 60                    rts   
2452 D956
2453 D956                       TITLE ', ExpressLoad.a - Interseg_26'
2454 D956              ;====================================================================================================
2455 D956              ;Interseg_26    This routine processes interseg 25 thru interseg 36 types.
2456 D956              ;               This type allows a 16 bit patch with 16 bit shifting.
2457 D956              ;
2458 D956              ;Structure:
2459 D956              ;
2460 D956              ;               The segment number to process is in the opcode byte.  To determine
2461 D956              ;               the real segment number just subtract 25 from the stored value.
2462 D956              ;====================================================================================================
2463 D956              Interseg_26  
2464 D956 A0 05 00              ldy   #$0005                   ;lets get the segment number
2465 D959 38                    sec   
2466 D95A B1 52                 lda   (reloc_dict_ptr),y
2467 D95C 29 FF 00              and   #$00FF                   ;get the record type
2468 D95F E9 19 00              sbc   #25
2469 D962 20 CF D5              jsr   get_seg_base             ;setup the base address for this segment
2470 D965 A0 00 00              ldy   #$0000                   ;init the super index pointer
2471 D968 90 01                 bcc   @continue
2472 D96A 60                    rts                            ;return the error
2473 D96B              @continue  
2474 D96B A5 6C                 lda   cnt_word                 ;see if we are done yet
2475 D96D F0 19                 beq   @done
2476 D96F              @outter_loop  
2477 D96F B7 6E                 lda   [super_ptr],y            ;get the command (8 Bits)
2478 D971 89 80 00              bit   #$0080                   ;clear all but the pages bit
2479 D974 F0 14                 beq   @do_inner_loop           ;process the relocation info
2480 D976 29 7F 00              and   #$007F                   ;get the number of pages to skip
2481 D979
2482 D979 EB                    xba                            ;multiply the number times 256
2483 D97A 18                    clc   
2484 D97B 65 62                 adc   temp_ptr
2485 D97D 85 62                 sta   temp_ptr
2486 D97F 90 02                 bcc   @low_only
2487 D981 E6 64                 inc   temp_ptr+2
2488 D983              @low_only  
2489 D983 C8                    iny                            ;bump index to point to the next byte
2490 D984 C6 6C                 dec   cnt_word                 ;reduce the count by one
2491 D986 D0 E7                 bne   @outter_loop
2492 D988              @done     
2493 D988 18                    clc   
2494 D989 60                    rts   
2495 D98A
2496 D98A              @do_inner_loop  
2497 D98A 29 7F 00              and   #$007F                   ;number of entries we have to patch
2498 D98D AA                    tax   
2499 D98E              @inner_loop  
2500 D98E C6 6C                 dec   cnt_word                 ;reduce the count by one
2501 D990 C8                    iny                            ;point to the next byte
2502 D991
2503 D991 B7 6E                 lda   [super_ptr],y            ;A = offset
2504 D993 29 FF 00              and   #$00FF                   ;clear garbage
2505 D996 5A                    phy                            ;save super index
2506 D997 A8                    tay                            ;build index to patch address
2507 D998
2508 D998 B7 62                 lda   [temp_ptr],y             ;get the relative offset in other segment
2509 D99A 85 5E                 sta   patch_value
2510 D99C
2511 D99C 18                    clc                            ;do the 16 bit patch
2512 D99D A5 74                 lda   segment_base
2513 D99F 65 5E                 adc   patch_value
2514 D9A1 A5 76                 lda   segment_base+2           ;store the upper 16 bits only
2515 D9A3 69 00 00              adc   #$0000
2516 D9A6 97 62                 sta   [temp_ptr],y
2517 D9A8
2518 D9A8 7A                    ply                            ;restore super index
2519 D9A9 CA                    dex   
2520 D9AA 10 E2                 bpl   @inner_loop              ;process this page
2521 D9AC
2522 D9AC C8                    iny                            ;point to the next byte
2523 D9AD E6 63                 inc   temp_ptr+1               ;bump to the next page
2524 D9AF C6 6C                 dec   cnt_word                 ;reduce the count by one
2525 D9B1 D0 BC                 bne   @outter_loop
2526 D9B3 18                    clc   
2527 D9B4 60                    rts   
2528 D9B5
2529 D9B5                       TITLE ', ExpressLoad.a - reloc2'
2530 D9B5              ;====================================================================================================
2531 D9B5              reloc2    
2532 D9B5 A0 00 00              ldy   #$0000                   ;init the index
2533 D9B8              @outter_loop  
2534 D9B8 A5 6C                 lda   cnt_word                 ;see if we are done yet
2535 D9BA D0 02                 bne   @not_yet
2536 D9BC 18                    clc   
2537 D9BD 60                    rts                            ;we are done
2538 D9BE              @not_yet  
2539 D9BE B7 6E                 lda   [super_ptr],y            ;get the command (8 Bits)
2540 D9C0 89 80 00              bit   #$0080                   ;clear all but the pages bit
2541 D9C3 F0 12                 beq   @do_inner_loop           ;process the relocation info
2542 D9C5 29 7F 00              and   #$007F                   ;get the number of pages to skip
2543 D9C8
2544 D9C8 EB                    xba                            ;multiply the number times 256
2545 D9C9 18                    clc   
2546 D9CA 65 62                 adc   temp_ptr
2547 D9CC 85 62                 sta   temp_ptr
2548 D9CE 90 02                 bcc   @low_only
2549 D9D0 E6 64                 inc   temp_ptr+2
2550 D9D2              @low_only  
2551 D9D2 C6 6C                 dec   cnt_word                 ;reduce the count by one
2552 D9D4 C8                    iny                            ;bump index to the next byte
2553 D9D5 80 E1                 bra   @outter_loop
2554 D9D7
2555 D9D7
2556 D9D7              @do_inner_loop  
2557 D9D7 29 7F 00              and   #$007F                   ;number of entries we have to patch
2558 D9DA AA                    tax   
2559 D9DB              @inner_loop  
2560 D9DB C6 6C                 dec   cnt_word                 ;reduce the count by one
2561 D9DD C8                    iny                            ;point to the next index please
2562 D9DE
2563 D9DE B7 6E                 lda   [super_ptr],y            ;A = offset
2564 D9E0 29 FF 00              and   #$00FF                   ;clear garbage
2565 D9E3 5A                    phy                            ;save super index
2566 D9E4 A8                    tay                            ;build index to the patch area
2567 D9E5
2568 D9E5 18                    clc   
2569 D9E6 B7 62                 lda   [temp_ptr],y             ;get the relative offset to patch with
2570 D9E8 65 4A                 adc   base_ptr                 ;base address of segment
2571 D9EA 97 62                 sta   [temp_ptr],y
2572 D9EC
2573 D9EC 7A                    ply                            ;restore super index
2574 D9ED CA                    dex   
2575 D9EE 10 EB                 bpl   @inner_loop              ;process this page
2576 D9F0
2577 D9F0 C6 6C                 dec   cnt_word                 ;reduce the count by one
2578 D9F2 C8                    iny                            ;point to the next byte
2579 D9F3 E6 63                 inc   temp_ptr+1               ;point to the next page please
2580 D9F5 80 C1                 bra   @outter_loop
2581 D9F7
2582 D9F7                       TITLE ', ExpressLoad.a - reloc3'
2583 D9F7              ;====================================================================================================
2584 D9F7              reloc3    
2585 D9F7 A0 00 00              ldy   #$0000                   ;init super index to zero
2586 D9FA              @outter_loop  
2587 D9FA A5 6C                 lda   cnt_word                 ;see if we are done yet
2588 D9FC D0 02                 bne   @not_yet
2589 D9FE 18                    clc   
2590 D9FF 60                    rts                            ;we are done
2591 DA00              @not_yet  
2592 DA00 B7 6E                 lda   [super_ptr],y            ;get the command (8 Bits)
2593 DA02 89 80 00              bit   #$0080                   ;clear all but the pages bit
2594 DA05 F0 12                 beq   @do_inner_loop           ;process the relocation info
2595 DA07 29 7F 00              and   #$007F                   ;get the number of pages to skip
2596 DA0A
2597 DA0A EB                    xba                            ;multiply the number times 256
2598 DA0B 18                    clc   
2599 DA0C 65 62                 adc   temp_ptr
2600 DA0E 85 62                 sta   temp_ptr
2601 DA10 90 02                 bcc   @low_only
2602 DA12 E6 64                 inc   temp_ptr+2
2603 DA14              @low_only  
2604 DA14 C6 6C                 dec   cnt_word                 ;reduce the count by one
2605 DA16 C8                    iny                            ;point to next byte
2606 DA17 80 E1                 bra   @outter_loop
2607 DA19
2608 DA19
2609 DA19              @do_inner_loop  
2610 DA19 29 7F 00              and   #$007F                   ;number of entries we have to patch
2611 DA1C AA                    tax   
2612 DA1D              @inner_loop  
2613 DA1D C6 6C                 dec   cnt_word                 ;reduce the count by one
2614 DA1F C8                    iny                            ;point to next byte in super record
2615 DA20
2616 DA20 B7 6E                 lda   [super_ptr],y            ;A = offset
2617 DA22 29 FF 00              and   #$00FF                   ;clear garbage
2618 DA25 5A                    phy                            ;save the super index please
2619 DA26 A8                    tay   
2620 DA27
2621 DA27 18                    clc   
2622 DA28 B7 62                 lda   [temp_ptr],y             ;get the relative offset to patch with
2623 DA2A 65 4A                 adc   base_ptr                 ;base address of segment
2624 DA2C 97 62                 sta   [temp_ptr],y
2625 DA2E C8                    iny   
2626 DA2F C8                    iny   
2627 DA30
2628 DA30 E2 20                 sep   #$20                     ;8 bit accumulator
2629 DA32 B7 62                 lda   [temp_ptr],y
2630 DA34 65 4C                 adc   base_ptr+2
2631 DA36 97 62                 sta   [temp_ptr],y             ;save the third byte please
2632 DA38 C2 20                 rep   #$20                     ;16 bit accumulator
2633 DA3A
2634 DA3A 7A                    ply                            ;restore super index
2635 DA3B CA                    dex   
2636 DA3C 10 DF                 bpl   @inner_loop              ;process this page
2637 DA3E
2638 DA3E C6 6C                 dec   cnt_word                 ;reduce the count by one
2639 DA40 C8                    iny                            ;bump super record index
2640 DA41 E6 63                 inc   temp_ptr+1               ;bump to the next page please
2641 DA43 80 B5                 bra   @outter_loop
2642 DA45
2643 DA45              ;====================================================================================================
2644 DA45              ;End_handler:   Just sets the flag indicating that we are done.
2645 DA45              ;====================================================================================================
2646 DA45
2647 DA45              end_handler  
2648 DA45              ;        lda   #$FFFF
2649 DA45              ;        sta   >end_found               ;indicate that we are done!!!
2650 DA45 60                    rts   
2651 DA46
2652 DA46                       TITLE ', ExpressLoad.a - shift_patch'
2653 DA46              ;====================================================================================================
2654 DA46              ;
2655 DA46              ;Below is the common patch code.  This code will do the relocation of the operand field
2656 DA46              ;
2657 DA46              ;====================================================================================================
2658 DA46              shift_patch  
2659 DA46                       longa off
2660 DA46 E2 20                 sep   #$20
2661 DA48 A5 58                 lda   shift_cnt                ;number of times to shift
2662 DA4A F0 3F                 beq   @no_shift                ;very common case
2663 DA4C C9 F0                 cmp   #$F0                     ;load the 3rd byte of address
2664 DA4E F0 2B                 beq   @skip_16_bits
2665 DA50 C9 F8                 cmp   #$F8                     ;load the 2nd byte of address
2666 DA52 F0 2F                 beq   @skip_8_bits
2667 DA54              ;
2668 DA54              ;we have now handled the common cases. So lets do the odd cases now
2669 DA54              ;
2670 DA54 A5 58                 lda   shift_cnt
2671 DA56 10 14                 bpl   @shift_left              ;not a commom case
2672 DA58 38                    sec   
2673 DA59 A9 00                 lda   #$00
2674 DA5B E5 58                 sbc   shift_cnt                ;convert twos compliment please
2675 DA5D              ;
2676 DA5D              ;do the slow shift right
2677 DA5D              ;
2678 DA5D                       longa on
2679 DA5D C2 20                 rep   #$20                     ;back to 16 bit mode
2680 DA5F 29 FF 00              and   #$00FF                   ;clear garbage
2681 DA62 AA                    tax                            ;count
2682 DA63              @right_loop  
2683 DA63 46 60                 lsr   patch_value+2
2684 DA65 66 5E                 ror   patch_value              ;shift by amount in x
2685 DA67 CA                    dex   
2686 DA68 D0 F9                 bne   @right_loop
2687 DA6A 80 21                 bra   patch_it                 ;continue the patch
2688 DA6C
2689 DA6C              @shift_left  
2690 DA6C                       longa on
2691 DA6C C2 20                 rep   #$20
2692 DA6E 29 FF 00              and   #$00FF
2693 DA71 AA                    tax   
2694 DA72              @left_loop  
2695 DA72 06 5E                 asl   patch_value
2696 DA74 26 60                 rol   patch_value+2
2697 DA76 CA                    dex   
2698 DA77 D0 F9                 bne   @left_loop               ;shift the correct amount
2699 DA79 80 12                 bra   patch_it                 ;continue the patch
2700 DA7B
2701 DA7B              @skip_16_bits                           ;equals a shift 16
2702 DA7B                       longa on
2703 DA7B C2 20                 rep   #$20
2704 DA7D A5 60                 lda   patch_value+2            ;get the high word please
2705 DA7F 85 5E                 sta   patch_value
2706 DA81 80 0A                 bra   patch_it
2707 DA83
2708 DA83              @skip_8_bits                            ;equals a shift 8
2709 DA83                       longa on
2710 DA83 C2 20                 rep   #$20
2711 DA85 A5 5F                 lda   patch_value+1
2712 DA87 85 5E                 sta   patch_value
2713 DA89 80 02                 bra   patch_it
2714 DA8B
2715 DA8B              @no_shift                               ;equals no shift
2716 DA8B                       longa on
2717 DA8B C2 20                 rep   #$20
2718 DA8D              patch_it  
2719 DA8D A0 00 00              ldy   #$0000
2720 DA90 A5 56                 lda   patch_cnt                ;number of bytes to patch
2721 DA92 0A                    asl   a
2722 DA93 AA                    tax   
2723 DA94 BF 98 DA 01           lda   >quick_jump-2,x
2724 DA98 48                    pha   
2725 DA99 60                    rts   
2726 DA9A              quick_jump  
2727 DA9A A1 DA                 DC W:one_byte-1
2728 DA9C AB DA                 DC W:two_byte-1
2729 DA9E B1 DA                 DC W:three_byte-1
2730 DAA0 BE DA                 DC W:four_byte-1
2731 DAA2
2732 DAA2              one_byte  
2733 DAA2 E2 20                 sep   #$20
2734 DAA4 A5 5E                 lda   patch_value
2735 DAA6 87 5A                 sta   [patch_ptr]              ;store the value
2736 DAA8 C2 20                 rep   #$20
2737 DAAA 18                    clc   
2738 DAAB 60                    rts   
2739 DAAC              two_byte  
2740 DAAC A5 5E                 lda   patch_value
2741 DAAE 87 5A                 sta   [patch_ptr]
2742 DAB0 18                    clc   
2743 DAB1 60                    rts   
2744 DAB2              three_byte  
2745 DAB2 A5 5E                 lda   patch_value
2746 DAB4 87 5A                 sta   [patch_ptr]
2747 DAB6 A0 01 00              ldy   #$0001
2748 DAB9 A5 5F                 lda   patch_value+1
2749 DABB 97 5A                 sta   [patch_ptr],y
2750 DABD 18                    clc   
2751 DABE 60                    rts   
2752 DABF              four_byte  
2753 DABF A0 02 00              ldy   #$0002
2754 DAC2 A5 5E                 lda   patch_value
2755 DAC4 87 5A                 sta   [patch_ptr]
2756 DAC6 A5 60                 lda   patch_value+2
2757 DAC8 97 5A                 sta   [patch_ptr],y
2758 DACA 18                    clc   
2759 DACB 60                    rts   
2760 DACC                       endp 
2761 DACC
2762 DACC                       TITLE ', ExpressLoad.a - read_less_64k'
2763 DACC              ;====================================================================================================
2764 DACC              ;read_less_64K: This routine will read data from the input file.  It is limited to $FFFF bytes
2765 DACC              ;
2766 DACC              ;
2767 DACC              ;Input:         A = request count
2768 DACC              ;               X = buffer_ptr low
2769 DACC              ;               Y = buffer_ptr high
2770 DACC              ;               P = nvmxdizc
2771 DACC              ;                   ..000...
2772 DACC              ;               b = k
2773 DACC              ;
2774 DACC              ;
2775 DACC              ;Output:        A = undefined
2776 DACC              ;               X = undefined
2777 DACC              ;               Y = undefined
2778 DACC              ;               P = nvmxdizc
2779 DACC              ;                   ..000..1 = error
2780 DACC              ;               b = k
2781 DACC              ;
2782 DACC              ;
2783 DACC              ;====================================================================================================
2784 DACC
2785 DACC                       longa on
2786 DACC                       longi on
2787 DACC              read_less_64k proc 
2788 DACC                       with DirectPage, Globals
2789 DACC
2790 DACC 9C 54 A7              stz   |PRead.requestCount+2
2791 DACF 8D 52 A7              sta   |PRead.requestCount
2792 DAD2                       export read_wBuf_ptr
2793 DAD2              read_wBuf_ptr  
2794 DAD2 8E 4E A7              stx   |PRead.dataBuffer
2795 DAD5 8C 50 A7              sty   |PRead.dataBuffer+2
2796 DAD8
2797 DAD8 20 62 BA              jsr   lock_handles
2798 DADB 22 A8 00 E1           jsl   $e100a8
2799 DADF 12 00                 DC W:PD_READ                   ;class 0 read call
2800 DAE1 4C A7 01 00           DC L:PRead
2801 DAE5 20 CB BA              jsr   unlock_handles
2802 DAE8 B0 12                 bcs   @exit
2803 DAEA
2804 DAEA AD 56 A7              lda   |PRead.transferCount
2805 DAED 65 A6                 adc   local_mark               ;bump the local mark please
2806 DAEF 85 A6                 sta   local_mark
2807 DAF1 AD 58 A7              lda   |PRead.transferCount+2
2808 DAF4 65 A8                 adc   local_mark+2
2809 DAF6 85 A8                 sta   local_mark+2
2810 DAF8 A9 00 00              lda   #$0000
2811 DAFB 18                    clc   
2812 DAFC              @exit     
2813 DAFC 60                    rts   
2814 DAFD                       endp 
2815 DAFD
2816 DAFD                       TITLE ', ExpressLoad.a - set_mark'
2817 DAFD              ;====================================================================================================
2818 DAFD              ;set_mark:      This routine will set the current file position
2819 DAFD              ;
2820 DAFD              ;
2821 DAFD              ;Input:         A = undefined
2822 DAFD              ;               X = displacement low
2823 DAFD              ;               Y = displacement high
2824 DAFD              ;               P = nvmxdizc
2825 DAFD              ;                   ..000...
2826 DAFD              ;               b = k
2827 DAFD              ;
2828 DAFD              ;
2829 DAFD              ;Output:        A = error if carry set
2830 DAFD              ;               X = undefined
2831 DAFD              ;               Y = undefined
2832 DAFD              ;               P = nvmxdizc
2833 DAFD              ;                   ..000..1 = error
2834 DAFD              ;               b = k
2835 DAFD              ;
2836 DAFD              ;
2837 DAFD              ;====================================================================================================
2838 DAFD
2839 DAFD                       longa on
2840 DAFD                       longi on
2841 DAFD              set_mark proc 
2842 DAFD                       with DirectPage, Globals
2843 DAFD
2844 DAFD 8E 62 A7              stx   |PSetMark.position
2845 DB00 8C 64 A7              sty   |PSetMark.position+2
2846 DB03 E4 A6                 cpx   local_mark               ;lets see if we are already at the mark
2847 DB05 D0 09                 bne   @do_mark
2848 DB07 C4 A8                 cpy   local_mark+2
2849 DB09 D0 05                 bne   @do_mark
2850 DB0B 18                    clc   
2851 DB0C A9 00 00              lda   #$0000                   ;we are already at the mark
2852 DB0F 60                    rts                            ;return with no error
2853 DB10              @do_mark  
2854 DB10 20 62 BA              jsr   lock_handles
2855 DB13 22 A8 00 E1           jsl   $e100a8
2856 DB17 16 00                 DC W:SET_MARK                  ;class 0 set mark call
2857 DB19 60 A7 01 00           DC L:PSetMark
2858 DB1D 20 CB BA              jsr   unlock_handles
2859 DB20 B0 0A                 bcs   @exit
2860 DB22
2861 DB22 AD 62 A7              lda   |PSetMark.position
2862 DB25 85 A6                 sta   local_mark               ;reset our mark please
2863 DB27 AD 64 A7              lda   |PSetMark.position+2
2864 DB2A 85 A8                 sta   local_mark+2
2865 DB2C              @exit     
2866 DB2C 60                    rts   
2867 DB2D                       endp 
2868 DB2D
2869 DB2D
2870 DB2D                       TITLE ', ExpressLoad.a - check_express_seg'
2871 DB2D              ;====================================================================================================
2872 DB2D              ;check_express_seg:     This routine will determine if this is an expressload file
2873 DB2D              ;
2874 DB2D              ;
2875 DB2D              ;Input:         A = undefined
2876 DB2D              ;               X = undefined
2877 DB2D              ;               Y = undefined
2878 DB2D              ;               P = nvmxdizc
2879 DB2D              ;                   ..000...
2880 DB2D              ;               b = k
2881 DB2D              ;
2882 DB2D              ;               PathnamePtr             pointer to file's pathname
2883 DB2D              ;
2884 DB2D              ;Output:        A = undefined
2885 DB2D              ;               X = undefined
2886 DB2D              ;               Y = undefined
2887 DB2D              ;               P = nvmxdizc
2888 DB2D              ;                   ..000...
2889 DB2D              ;               b = k
2890 DB2D              ;
2891 DB2D              ;
2892 DB2D              ;====================================================================================================
2893 DB2D
2894 DB2D                       longa on
2895 DB2D                       longi on
2896 DB2D              check_express_seg proc  
2897 DB2D                       with DirectPage, Globals
2898 DB2D
2899 DB2D A2 B8 A6              ldx   #Header
2900 DB30 A0 01 00              ldy   #^Header
2901 DB33 A9 48 00              lda   #SegmentHeader.SegHeaderSize ;read in segment header
2902 DB36 20 CC DA              jsr   read_less_64k            ;read in less then 64K
2903 DB39 B0 09                 bcs   @oops
2904 DB3B              @no_error  
2905 DB3B AD 56 A7              lda   |PRead.transferCount     ;is the segment > $47 bytes
2906 DB3E C9 48 00              cmp   #SegmentHeader.SegHeaderSize
2907 DB41 F0 02                 beq   @good_size
2908 DB43 38                    sec   
2909 DB44              @oops     
2910 DB44 60                    rts                            ;return with error flag
2911 DB45
2912 DB45              @good_size  
2913 DB45 AD E0 A6              lda   Header.DispName          ;offset to the name
2914 DB48 18                    clc   
2915 DB49 69 0A 00              adc   #10                      ;pass my Name
2916 DB4C 18                    clc   
2917 DB4D 69 B8 A6              adc   #Header
2918 DB50 85 62                 sta   temp_ptr
2919 DB52 A9 01 00              lda   #^Header
2920 DB55 85 64                 sta   temp_ptr+2               ;point to the name field
2921 DB57
2922 DB57                       longa off
2923 DB57                       longi off
2924 DB57 E2 30                 sep   #$30
2925 DB59 A7 62                 lda   [temp_ptr]               ;get the length of the name
2926 DB5B CD 96 A8              cmp   express_name             ;is the length the same?
2927 DB5E D0 17                 bne   next_name                ;cannot be the same
2928 DB60 A8                    tay   
2929 DB61              @loop     
2930 DB61 B7 62                 lda   [temp_ptr],y
2931 DB63 C9 61                 cmp   #'a'                     ;is this lower case
2932 DB65 90 06                 bcc   @not_lower
2933 DB67 C9 7B                 cmp   #'z'+1
2934 DB69 B0 02                 bcs   @not_lower
2935 DB6B 29 DF                 and   #$DF                     ;convert to Upper case
2936 DB6D              @not_lower  
2937 DB6D D9 96 A8              cmp   express_name,y
2938 DB70 D0 23                 bne   sorry_not_express
2939 DB72 88                    dey   
2940 DB73 D0 EC                 bne   @loop                    ;keep checking
2941 DB75 80 1A                 bra   load_it
2942 DB77              ;
2943 DB77              ;Now look for "~ExpressLoad"
2944 DB77              ;
2945 DB77              next_name  
2946 DB77 CD A2 A8              cmp   tilda_name               ;now check for "~ExpressLoad"
2947 DB7A D0 19                 bne   sorry_not_express
2948 DB7C A8                    tay   
2949 DB7D              @loop     
2950 DB7D B7 62                 lda   [temp_ptr],y
2951 DB7F C9 61                 cmp   #'a'                     ;is this lower case
2952 DB81 90 06                 bcc   @not_lower
2953 DB83 C9 7B                 cmp   #'z'+1
2954 DB85 B0 02                 bcs   @not_lower
2955 DB87 29 DF                 and   #$DF                     ;convert to Upper case
2956 DB89              @not_lower  
2957 DB89 D9 A2 A8              cmp   tilda_name,y
2958 DB8C D0 07                 bne   sorry_not_express
2959 DB8E 88                    dey   
2960 DB8F D0 EC                 bne   @loop                    ;keep checking
2961 DB91              load_it   
2962 DB91 C2 30                 rep   #$30
2963 DB93 18                    clc   
2964 DB94 60                    rts   
2965 DB95
2966 DB95              sorry_not_express  
2967 DB95                       longa on
2968 DB95                       longi on
2969 DB95 C2 30                 rep   #$30
2970 DB97 38                    sec   
2971 DB98 60                    rts   
2972 DB99
2973 DB99                       endp 
2974 DB99
2975 DB99                       TITLE ', ExpressLoad.a - find_Segment'
2976 DB99              ;====================================================================================================
2977 DB99              ;find_Segment:  This routine will search for segments in the HET table
2978 DB99              ;
2979 DB99              ;
2980 DB99              ;Input:         A = Kind to search for
2981 DB99              ;               X = AND mask for kind field.    If equal after AND the kind was a match
2982 DB99              ;               Y = AND mask for flags field.   If equal after AND then search succeeds
2983 DB99              ;               P = nvmxdizc
2984 DB99              ;                   ..000...
2985 DB99              ;               b = k
2986 DB99              ;
2987 DB99              ;               HET_ptr         ;must be setup!
2988 DB99              ;
2989 DB99              ;Output:        A = Segment number in file
2990 DB99              ;               X = undefined
2991 DB99              ;               Y = undefined
2992 DB99              ;               P = nvmxdizc
2993 DB99              ;                   ..000..1 = not found
2994 DB99              ;               b = k
2995 DB99              ;
2996 DB99              ;
2997 DB99              ;====================================================================================================
2998 DB99
2999 DB99                       longa on
3000 DB99                       longi on
3001 DB99              find_Segment proc 
3002 DB99                       with DirectPage, Globals
3003 DB99
3004 DB99 85 C6                 sta   search_kind
3005 DB9B 86 C8                 stx   kind_mask
3006 DB9D 84 CA                 sty   flags_mask
3007 DB9F A2 00 00              ldx   #$0000                   ;start search from the beginning
3008 DBA2
3009 DBA2              @loop     
3010 DBA2
3011 DBA2 8A                    txa   
3012 DBA3 0A                    asl   a
3013 DBA4 0A                    asl   a
3014 DBA5 0A                    asl   a                        ;times eight for HET
3015 DBA6 1A                    inc   a
3016 DBA7 1A                    inc   a                        ;pass the count word
3017 DBA8 A8                    tay   
3018 DBA9
3019 DBA9 18                    clc   
3020 DBAA 65 3E                 adc   HET_ptr
3021 DBAC 85 42                 sta   HET_entry_ptr            ;build a pointer to the HET entry
3022 DBAE A9 00 00              lda   #$0000
3023 DBB1 65 40                 adc   HET_ptr+2
3024 DBB3 85 44                 sta   HET_entry_ptr+2
3025 DBB5
3026 DBB5 18                    clc   
3027 DBB6 A7 42                 lda   [HET_entry_ptr]          ;get the relative offset to segment
3028 DBB8 65 42                 adc   HET_entry_ptr
3029 DBBA 85 4E                 sta   seg_header_ptr           ;point to the segment
3030 DBBC A9 00 00              lda   #$0000
3031 DBBF 65 44                 adc   HET_entry_ptr+2
3032 DBC1 85 50                 sta   seg_header_ptr+2
3033 DBC3
3034 DBC3 C8                    iny   
3035 DBC4 C8                    iny   
3036 DBC5 B7 3E                 lda   [HET_ptr],y              ;check the flags mask
3037 DBC7 25 CA                 and   flags_mask
3038 DBC9 D0 12                 bne   @check_next              ;sorry
3039 DBCB
3040 DBCB A0 18 00              ldy   #SegHeaderEntry.Kind     ;lets check the kind please
3041 DBCE B7 4E                 lda   [seg_header_ptr],y
3042 DBD0 25 C8                 and   kind_mask
3043 DBD2 C5 C6                 cmp   search_kind              ;is this it
3044 DBD4 D0 07                 bne   @check_next              ;sorry false alarm
3045 DBD6
3046 DBD6 8A                    txa   
3047 DBD7 1A                    inc   a                        ;convert 0 thru n to 1 thru n
3048 DBD8 1A                    inc   a                        ;account for ExpressLoad segment
3049 DBD9 85 C4                 sta   loaded_seg_num
3050 DBDB 18                    clc   
3051 DBDC 60                    rts                            ;return the segment
3052 DBDD
3053 DBDD              @check_next  
3054 DBDD E8                    inx   
3055 DBDE 8A                    txa   
3056 DBDF C7 3E                 cmp   [HET_ptr]                ;are we done
3057 DBE1 F0 BF                 beq   @loop                    ;we have one more to do
3058 DBE3 90 BD                 bcc   @loop
3059 DBE5 60                    rts                            ;return with the carry set
3060 DBE6                       endp 
3061 DBE6
3062 DBE6                       TITLE ', ExpressLoad.a - chk_dynamic_seg'
3063 DBE6              ;====================================================================================================
3064 DBE6              ;chk_dynamic_seg:       See if there are any dynamic segments in the file.
3065 DBE6              ;
3066 DBE6              ;Input:         A = undefined
3067 DBE6              ;               X = undefined
3068 DBE6              ;               Y = undefined
3069 DBE6              ;               P = nvmxdizc
3070 DBE6              ;                   ..000...
3071 DBE6              ;               b = k
3072 DBE6              ;
3073 DBE6              ;               ExpressHandle           ;handle to the express segment.
3074 DBE6              ;
3075 DBE6              ;Output:        A = undefined
3076 DBE6              ;               X = undefined
3077 DBE6              ;               Y = undefined
3078 DBE6              ;               P = nvmxdizc
3079 DBE6              ;                   ..000..1 = no seg.
3080 DBE6              ;               b = k
3081 DBE6              ;
3082 DBE6              ;
3083 DBE6              ;====================================================================================================
3084 DBE6
3085 DBE6                       longa on
3086 DBE6                       longi on
3087 DBE6              chk_dynamic_seg proc 
3088 DBE6                       with DirectPage, Globals
3089 DBE6
3090 DBE6 20 44 D2              jsr   make_HET_ptr             ;setup pointer to the HETable
3091 DBE9
3092 DBE9 A9 00 80              lda   #dynamic                 ;Compare to Dynamic BIT
3093 DBEC AA                    tax                            ;And Mask (Only Dynamic Bit is important)
3094 DBED A0 00 80              ldy   #unloaded_state          ;only unloaded segments please
3095 DBF0 20 99 DB              jsr   find_Segment             ;do the search
3096 DBF3 60                    rts   
3097 DBF4                       endp 
3098 DBF4
3099 DBF4                       TITLE ', ExpressLoad.a - save_ref_num'
3100 DBF4              ;====================================================================================================
3101 DBF4              ;save_ref_num:  This routine will save the files reference number if the file contains any dynamic
3102 DBF4              ;               segments.  We do this so the file can remain open while the program is running.
3103 DBF4              ;
3104 DBF4              ;Input:         A = undefined
3105 DBF4              ;               X = undefined
3106 DBF4              ;               Y = undefined
3107 DBF4              ;               P = nvmxdizc
3108 DBF4              ;                   ..000...
3109 DBF4              ;               b = k
3110 DBF4              ;
3111 DBF4              ;               POpen.refNum            ;reference number for the current file.
3112 DBF4              ;               ExpressHandle           ;handle to the express segment.
3113 DBF4              ;
3114 DBF4              ;Output:        A = undefined
3115 DBF4              ;               X = undefined
3116 DBF4              ;               Y = undefined
3117 DBF4              ;               P = nvmxdizc
3118 DBF4              ;                   ..000...
3119 DBF4              ;               b = k
3120 DBF4              ;
3121 DBF4              ;
3122 DBF4              ;====================================================================================================
3123 DBF4
3124 DBF4                       longa on
3125 DBF4                       longi on
3126 DBF4              save_ref_num proc 
3127 DBF4                       with DirectPage, Globals
3128 DBF4
3129 DBF4 AD 34 A7              lda   |POpen.fileType          ;retrieve returned file type
3130 DBF7 C9 B3 00              cmp   #app_type                ;only leave the file open if type = Application
3131 DBFA D0 05                 bne   @skip_dynamic_chk        ;don't leave the file open
3132 DBFC
3133 DBFC 20 E6 DB              jsr   chk_dynamic_seg
3134 DBFF 90 02                 bcc   @save_the_num            ;There is a dynamic segment.
3135 DC01
3136 DC01              @skip_dynamic_chk  
3137 DC01 18                    clc   
3138 DC02 60                    rts   
3139 DC03              @save_the_num  
3140 DC03 A0 02 00              ldy   #$0002
3141 DC06 18                    clc   
3142 DC07 A7 88                 lda   [ExpressHandle]
3143 DC09 85 62                 sta   temp_ptr                 ;temp now points the link field
3144 DC0B B7 88                 lda   [ExpressHandle],y
3145 DC0D 85 64                 sta   temp_ptr+2
3146 DC0F
3147 DC0F AD 28 A7              lda   |POpen.refNum            ;save the file reference number since the file
3148 DC12 87 62                 sta   [temp_ptr]               ; contains Dynamic Segments.
3149 DC14 60                    rts   
3150 DC15                       endp 
3151 DC15
3152 DC15                       TITLE ', ExpressLoad.a - get_express_seg'
3153 DC15              ;====================================================================================================
3154 DC15              ;get_express_seg:       This routine will locate and read in the ExpressLoad Header
3155 DC15              ;
3156 DC15              ;
3157 DC15              ;Input:         A = undefined
3158 DC15              ;               X = undefined
3159 DC15              ;               Y = undefined
3160 DC15              ;               P = nvmxdizc
3161 DC15              ;                   ..000...
3162 DC15              ;               b = k
3163 DC15              ;
3164 DC15              ;               PathnamePtr             points to pathname
3165 DC15              ;
3166 DC15              ;Output:        A = undefined
3167 DC15              ;               X = undefined
3168 DC15              ;               Y = undefined
3169 DC15              ;               P = nvmxdizc
3170 DC15              ;                   ..000...
3171 DC15              ;               b = k
3172 DC15              ;
3173 DC15              ;
3174 DC15              ;====================================================================================================
3175 DC15
3176 DC15                       longa on
3177 DC15                       longi on
3178 DC15              get_express_seg proc 
3179 DC15                       with DirectPage, Globals
3180 DC15
3181 DC15 18                    clc   
3182 DC16 AD E2 A6              lda   Header.DispData
3183 DC19 69 05 00              adc   #$0005                   ;Add in LConst overhead
3184 DC1C AA                    tax   
3185 DC1D A0 00 00              ldy   #$0000
3186 DC20 20 FD DA              jsr   set_mark
3187 DC23 B0 5E                 bcs   @error_return
3188 DC25 AE C0 A6              ldx   Header.Length            ;get the size of the disk image please
3189 DC28 8E 52 A7              stx   |PRead.requestCount
3190 DC2B AC C2 A6              ldy   Header.Length+2
3191 DC2E 8C 54 A7              sty   |PRead.requestCount+2
3192 DC31              ;
3193 DC31              ;Now we need to add in the pathname overhead + mod date field overhead
3194 DC31              ;
3195 DC31 A7 CE                 lda   [PathnamePtr]            ;get the length of the pathname
3196 DC33 18                    clc   
3197 DC34 69 0A 00              adc   #10                      ;add 2 (for length word) and 8 (for mod date)
3198 DC37 18                    clc   
3199 DC38 6D C0 A6              adc   Header.Length            ;add in ExpressLoad segment size
3200 DC3B AA                    tax                            ;save request count low
3201 DC3C A9 00 00              lda   #$0000
3202 DC3F 6D C2 A6              adc   Header.Length+2
3203 DC42 A8                    tay                            ;save request count high
3204 DC43
3205 DC43 20 4A D0              jsr   alloc_ExpLoad            ;get enough memory to hold segment
3206 DC46 B0 3B                 bcs   @error_return
3207 DC48 86 88                 stx   ExpressHandle            ;handle to Express Segment
3208 DC4A 86 46                 stx   temp_handle
3209 DC4C 84 8A                 sty   ExpressHandle+2
3210 DC4E 84 48                 sty   temp_handle+2
3211 DC50 A0 02 00              ldy   #$0002
3212 DC53 A7 46                 lda   [temp_handle]            ;clear the link field etc.
3213 DC55 85 4A                 sta   base_ptr
3214 DC57 B7 46                 lda   [temp_handle],y
3215 DC59 85 4C                 sta   base_ptr+2
3216 DC5B
3217 DC5B              ;
3218 DC5B              ;Lets go ahead and add the Express Segment into the User ID table
3219 DC5B              ;
3220 DC5B AD B6 A6              lda   |USERID                  ;this is the ID to use
3221 DC5E 20 68 D3              jsr   add_user_id              ;temp_ptr setup by Add_user_id
3222 DC61 B0 20                 bcs   @error_return
3223 DC63 A0 02 00              ldy   #ID_Table_Entry.ExpressHandle ;save the Handle to the ExpressSegment
3224 DC66 A5 88                 lda   ExpressHandle
3225 DC68 97 62                 sta   [temp_ptr],y
3226 DC6A C8                    iny   
3227 DC6B C8                    iny   
3228 DC6C A5 8A                 lda   ExpressHandle+2
3229 DC6E 97 62                 sta   [temp_ptr],y
3230 DC70
3231 DC70 20 44 D2              jsr   make_HET_ptr             ;temp_ptr will point to the link field (HET_ptr-4)
3232 DC73 20 D2 DA              jsr   read_wBuf_ptr            ;make the read call please
3233 DC76 B0 0B                 bcs   @error_return
3234 DC78 A6 62                 ldx   temp_ptr                 ;pass in pointer to ExpressSegment link field
3235 DC7A A4 64                 ldy   temp_ptr+2
3236 DC7C 20 84 DC              jsr   store_pathname           ;store the pathname in the ExpressLoad segment
3237 DC7F 20 F4 DB              jsr   save_ref_num             ;save the files reference number.
3238 DC82 18                    clc   
3239 DC83              @error_return  
3240 DC83 60                    rts   
3241 DC84
3242 DC84                       TITLE ', ExpressLoad.a - store_pathname'
3243 DC84              ;====================================================================================================
3244 DC84              ;
3245 DC84              ;This routine will add in the pathname stored at [PathnamePtr] to the ExpressLoad segment.
3246 DC84              ;
3247 DC84              ;Input:         A = undefined
3248 DC84              ;               X = Points to the ExpressLoad segment link field
3249 DC84              ;               Y = Points to the ExpressLoad segment link field
3250 DC84              ;               P = nvmxdizc
3251 DC84              ;                   ..000...
3252 DC84              ;               b = k
3253 DC84              ;
3254 DC84              ;               PathnamePtr     pointer to pathname
3255 DC84              ;               base_ptr        pointer to ExpressLoad segment
3256 DC84              ;
3257 DC84              ;Output:        A = undefined
3258 DC84              ;               X = undefined
3259 DC84              ;               Y = undefined
3260 DC84              ;               P = nvmxdizc
3261 DC84              ;                   ..000...
3262 DC84              ;               b = k
3263 DC84              ;
3264 DC84              ;Uses:
3265 DC84              ;
3266 DC84              ;====================================================================================================
3267 DC84
3268 DC84              store_pathname  
3269 DC84 18                    clc   
3270 DC85 8A                    txa   
3271 DC86 6D 52 A7              adc   |PRead.requestCount      ;build a pointer to the Volume Name Buffer
3272 DC89 85 6E                 sta   super_ptr                ;another temp pointer
3273 DC8B 98                    tya   
3274 DC8C 6D 54 A7              adc   |PRead.requestCount+2
3275 DC8F 85 70                 sta   super_ptr+2              ;super_ptr now points past the ExpressLoad segment
3276 DC91
3277 DC91 A0 06 00              ldy   #6                       ;copy 8 bytes
3278 DC94              @store_date_loop  
3279 DC94 B9 44 A7              lda   POpen.modDateTime,y
3280 DC97 97 6E                 sta   [super_ptr],y
3281 DC99 88                    dey   
3282 DC9A 88                    dey   
3283 DC9B 10 F7                 bpl   @store_date_loop
3284 DC9D
3285 DC9D A5 6E                 lda   super_ptr                ;update super_ptr to location for pathname
3286 DC9F 18                    clc   
3287 DCA0 69 08 00              adc   #8
3288 DCA3 85 6E                 sta   super_ptr
3289 DCA5 90 02                 bcc   @no_bump
3290 DCA7 E6 70                 inc   super_ptr+2
3291 DCA9              @no_bump  
3292 DCA9 A7 CE                 lda   [PathnamePtr]            ;get the length
3293 DCAB 87 6E                 sta   [super_ptr]              ;and store in destination
3294 DCAD 1A                    inc   a                        ;bump by 1 for leading length word
3295 DCAE A8                    tay                            ;into indexor
3296 DCAF E2 20                 sep   #$20                     ;8-bit mode
3297 DCB1                       longa off
3298 DCB1              @store_name_loop  
3299 DCB1 B7 CE                 lda   [PathnamePtr],y          ;copy characters from source
3300 DCB3 97 6E                 sta   [super_ptr],y            ;to destination
3301 DCB5 88                    dey                            ;continue until back at length word
3302 DCB6 D0 F9                 bne   @store_name_loop
3303 DCB8 C2 20                 rep   #$20                     ;back to 16-bit accumulator
3304 DCBA                       longa on
3305 DCBA
3306 DCBA A0 02 00              ldy   #ExpressloadSeg.PathnameOffset ;index to offset field (relative offset is based
3307 DCBD 38                    sec                            ;from the beginning of the segment)
3308 DCBE A5 6E                 lda   super_ptr
3309 DCC0 E5 4A                 sbc   base_ptr
3310 DCC2 97 4A                 sta   [base_ptr],y
3311 DCC4 60                    rts   
3312 DCC5
3313 DCC5                       endp 
3314 DCC5
3315 DCC5                       TITLE ', ExpressLoad.a - close_dynamic_file'
3316 DCC5              ;====================================================================================================
3317 DCC5              ;close_dynamic_file:    This routine will close the load file if the file is still open
3318 DCC5              ;
3319 DCC5              ;
3320 DCC5              ;Input:         A = undefined
3321 DCC5              ;               X = undefined
3322 DCC5              ;               Y = undefined
3323 DCC5              ;               P = nvmxdizc
3324 DCC5              ;                   ..000...
3325 DCC5              ;               b = k
3326 DCC5              ;
3327 DCC5              ;               ExpressHandle
3328 DCC5              ;
3329 DCC5              ;Output:        A = undefined
3330 DCC5              ;               X = undefined
3331 DCC5              ;               Y = undefined
3332 DCC5              ;               P = nvmxdizc
3333 DCC5              ;                   ..000..1 = error if any
3334 DCC5              ;               b = k
3335 DCC5              ;
3336 DCC5              ;
3337 DCC5              ;====================================================================================================
3338 DCC5
3339 DCC5                       longa on
3340 DCC5                       longi on
3341 DCC5              close_dynamic_file proc  
3342 DCC5                       with DirectPage, Globals
3343 DCC5                       import close_load_file
3344 DCC5
3345 DCC5 D4 62                 pei   temp_ptr                 ;save temp pointer please
3346 DCC7 D4 64                 pei   temp_ptr+2
3347 DCC9
3348 DCC9 A0 02 00              ldy   #$0002
3349 DCCC 18                    clc   
3350 DCCD A7 88                 lda   [ExpressHandle]
3351 DCCF 85 62                 sta   temp_ptr                 ;temp now points the link field
3352 DCD1 B7 88                 lda   [ExpressHandle],y
3353 DCD3 85 64                 sta   temp_ptr+2
3354 DCD5
3355 DCD5 A7 62                 lda   [temp_ptr]               ;see if there is reference number.
3356 DCD7 F0 4B                 beq   @exit                    ;no, just exit with Acc = 0
3357 DCD9 8D 28 A7              sta   |POpen.refNum            ;setup the reference number for closing
3358 DCDC A9 00 00              lda   #$0000                   ;zero the reference number in ExpressSegment
3359 DCDF 87 62                 sta   [temp_ptr]
3360 DCE1
3361 DCE1 1A                    inc   a                        ;set the pCount
3362 DCE2 8D 72 A7              sta   PSysPrefs.pCount
3363 DCE5
3364 DCE5 20 62 BA              jsr   lock_handles
3365 DCE8 22 A8 00 E1           jsl   $e100a8                  ;get the current system preferences
3366 DCEC 0F 20                 DC W:GetSysPrefs
3367 DCEE 72 A7 01 00           DC L:PSysPrefs
3368 DCF2              ;
3369 DCF2              ;Save the current user's preference please
3370 DCF2              ;
3371 DCF2 AD 74 A7              lda   PSysPrefs.preferences
3372 DCF5 8D 9E A6              sta   users_prefs
3373 DCF8              ;
3374 DCF8              ;Now ask the operating system to put up a mount dialog when I ask for a disk
3375 DCF8              ;
3376 DCF8 A9 00 C0              lda   #$C000                   ;ask the OS to put up the mount dialog
3377 DCFB 8D 74 A7              sta   PSysPrefs.preferences
3378 DCFE
3379 DCFE 22 A8 00 E1           jsl   $e100a8
3380 DD02 0C 20                 DC W:SetSysPrefs               ;set the system preference
3381 DD04 72 A7 01 00           DC L:PSysPrefs
3382 DD08 20 CB BA              jsr   unlock_handles
3383 DD0B
3384 DD0B 20 2E DD              jsr   close_load_file          ;close the file please
3385 DD0E
3386 DD0E AD 9E A6              lda   users_prefs
3387 DD11 8D 74 A7              sta   PSysPrefs.preferences
3388 DD14 20 62 BA              jsr   lock_handles
3389 DD17 22 A8 00 E1           jsl   $e100a8
3390 DD1B 0C 20                 DC W:SetSysPrefs               ;restore the caller's system preference
3391 DD1D 72 A7 01 00           DC L:PSysPrefs
3392 DD21 20 CB BA              jsr   unlock_handles
3393 DD24              @exit     
3394 DD24 FA                    plx   
3395 DD25 86 64                 stx   temp_ptr+2
3396 DD27 FA                    plx   
3397 DD28 86 62                 stx   temp_ptr
3398 DD2A C9 01 00              cmp   #$0001
3399 DD2D 60                    rts                            ;exit with error if any
3400 DD2E                       endp 
3401 DD2E
3402 DD2E                       TITLE ', ExpressLoad.a - close_load_file'
3403 DD2E              ;====================================================================================================
3404 DD2E              ;close_load_file:       This routine will close the load file and restore the caller's sys_prefs
3405 DD2E              ;
3406 DD2E              ;
3407 DD2E              ;Input:         A = undefined
3408 DD2E              ;               X = undefined
3409 DD2E              ;               Y = undefined
3410 DD2E              ;               P = nvmxdizc
3411 DD2E              ;                   ..000...
3412 DD2E              ;               b = k
3413 DD2E              ;
3414 DD2E              ;
3415 DD2E              ;Output:        A = undefined
3416 DD2E              ;               X = undefined
3417 DD2E              ;               Y = undefined
3418 DD2E              ;               P = nvmxdizc
3419 DD2E              ;                   ..000..1 = error if any
3420 DD2E              ;               b = k
3421 DD2E              ;
3422 DD2E              ;
3423 DD2E              ;====================================================================================================
3424 DD2E
3425 DD2E                       longa on
3426 DD2E                       longi on
3427 DD2E              close_load_file proc 
3428 DD2E                       with DirectPage, Globals
3429 DD2E
3430 DD2E A5 88                 lda   ExpressHandle            ;see if there is an ExpressSegment for this file.
3431 DD30 05 8A                 ora   ExpressHandle+2
3432 DD32 F0 16                 beq   @do_close                ;There is no Segment associated with the file.
3433 DD34
3434 DD34 A0 02 00              ldy   #$0002
3435 DD37 18                    clc   
3436 DD38 A7 88                 lda   [ExpressHandle]
3437 DD3A 85 62                 sta   temp_ptr                 ;temp now points the reference number field
3438 DD3C B7 88                 lda   [ExpressHandle],y
3439 DD3E 85 64                 sta   temp_ptr+2
3440 DD40
3441 DD40 A7 62                 lda   [temp_ptr]               ;see if there is reference number.
3442 DD42 F0 06                 beq   @do_close                ;there is no reference number with the segment so
3443 DD44                                                      ;go ahead and close the file they want.
3444 DD44 A9 00 00              lda   #$0000
3445 DD47 18                    clc   
3446 DD48 80 15                 bra   @do_preference           ;No error and I am not going to close the file
3447 DD4A                                                      ;since the file contains Dynamic Segments I will
3448 DD4A                                                      ;leave the file open.
3449 DD4A
3450 DD4A              @do_close  
3451 DD4A AD 28 A7              lda   POpen.refNum             ;is there a valid refNum?
3452 DD4D F0 10                 beq   @do_preference           ;no, so don't do a global close
3453 DD4F
3454 DD4F 20 62 BA              jsr   lock_handles
3455 DD52 22 A8 00 E1           jsl   $e100a8
3456 DD56 14 00                 DC W:PD_CLOSE                  ;GS/OS close command
3457 DD58 28 A7 01 00           DC L:POpen.refNum
3458 DD5C 20 CB BA              jsr   unlock_handles
3459 DD5F              ;
3460 DD5F              ;Save the error code and statue from the close call while I restore the user's system preferences
3461 DD5F              ;
3462 DD5F              @do_preference  
3463 DD5F 48                    pha   
3464 DD60 08                    php   
3465 DD61 64 B4                 stz   file_open                ;file is now closed
3466 DD63 20 C0 D1              jsr   reset_local_mark         ;our local mark is invalid
3467 DD66 28                    plp   
3468 DD67 68                    pla                            ;restore the close error if any
3469 DD68 60                    rts   
3470 DD69                       endp 
3471 DD69
3472 DD69                       TITLE ', ExpressLoad.a - open_load_file'
3473 DD69              ;====================================================================================================
3474 DD69              ;Open_load_file:        This routine will open the load file and verify the storage type
3475 DD69              ;
3476 DD69              ;
3477 DD69              ;Input:         A = undefined
3478 DD69              ;               X = undefined
3479 DD69              ;               Y = undefined
3480 DD69              ;               P = nvmxdizc
3481 DD69              ;                   ..000...
3482 DD69              ;               b = k
3483 DD69              ;
3484 DD69              ;               pathname pointer must be setup
3485 DD69              ;
3486 DD69              ;Output:        A = undefined
3487 DD69              ;               X = undefined
3488 DD69              ;               Y = undefined
3489 DD69              ;               P = nvmxdizc
3490 DD69              ;                   ..000..1 = error
3491 DD69              ;               b = k
3492 DD69              ;
3493 DD69              ;
3494 DD69              ;====================================================================================================
3495 DD69
3496 DD69                       longa on
3497 DD69                       longi on
3498 DD69              open_load_file proc 
3499 DD69                       with DirectPage, Globals
3500 DD69
3501 DD69              ;
3502 DD69              ;Now before I open the file let me see If I have a Reference number for it already.
3503 DD69              ;
3504 DD69 A5 88                 lda   ExpressHandle            ;see if there is an ExpressSegment for this file.
3505 DD6B 05 8A                 ora   ExpressHandle+2
3506 DD6D F0 1C                 beq   @do_open                 ;There is no Segment associated with the file.
3507 DD6F              ;
3508 DD6F              ;There is an Active Segment so lets see if we have the reference number
3509 DD6F              ;
3510 DD6F A0 02 00              ldy   #$0002
3511 DD72 18                    clc   
3512 DD73 A7 88                 lda   [ExpressHandle]
3513 DD75 85 62                 sta   temp_ptr                 ;temp now points the reference number field
3514 DD77 B7 88                 lda   [ExpressHandle],y
3515 DD79 85 64                 sta   temp_ptr+2
3516 DD7B
3517 DD7B A7 62                 lda   [temp_ptr]               ;see if there is reference number.
3518 DD7D F0 0C                 beq   @do_open                 ;There is no reference number so lets open the file
3519 DD7F 8D 28 A7              sta   |POpen.refNum            ;save the reference number
3520 DD82 A9 B3 00              lda   #app_type                ;setup the file type also
3521 DD85 8D 34 A7              sta   |POpen.fileType
3522 DD88 82 93 00              brl   @opened                  ;say that we already opened the file.
3523 DD8B
3524 DD8B              @get_pathname  
3525 DD8B
3526 DD8B
3527 DD8B              @do_open  
3528 DD8B A9 0A 00              lda   #10                      ;pCount (return info up to OptionList)
3529 DD8E 8D 26 A7              sta   |POpen.pCount
3530 DD91 A9 01 00              lda   #$01                     ;requestAccess
3531 DD94 8D 2E A7              sta   |POpen.requestAccess
3532 DD97 8D 72 A7              sta   PSysPrefs.pCount
3533 DD9A 1A                    inc   a
3534 DD9B 8D 76 A7              sta   PGetLevel.pCount
3535 DD9E 8D 7C A7              sta   PSetLevel.pCount
3536 DDA1 9C 7A A7              stz   PGetLevel.levelMode
3537 DDA4 9C 80 A7              stz   PSetLevel.levelMode
3538 DDA7 9C 30 A7              stz   POpen.resourceNumber     ;resourceNumber (data fork always)
3539 DDAA
3540 DDAA A5 CE                 lda   PathnamePtr              ;address of GString
3541 DDAC 8D 2A A7              sta   |POpen.pathname
3542 DDAF A5 D0                 lda   PathnamePtr+2            ;address of GString
3543 DDB1 8D 2C A7              sta   |POpen.pathname+2        ;setup the Open Parameter block
3544 DDB4
3545 DDB4 20 62 BA              jsr   lock_handles
3546 DDB7
3547 DDB7 22 A8 00 E1           jsl   $e100a8                  ;get the current system preferences
3548 DDBB 0F 20                 DC W:GetSysPrefs
3549 DDBD 72 A7 01 00           DC L:PSysPrefs
3550 DDC1              ;
3551 DDC1              ;Save the current user's preference please
3552 DDC1              ;
3553 DDC1 AD 74 A7              lda   PSysPrefs.preferences
3554 DDC4 8D 9E A6              sta   users_prefs
3555 DDC7              ;
3556 DDC7              ;Now ask the operating system to put up a mount dialog when I ask for a disk
3557 DDC7              ;
3558 DDC7 A9 00 C0              lda   #$C000                   ;ask the OS to put up the mount dialog
3559 DDCA 8D 74 A7              sta   PSysPrefs.preferences
3560 DDCD
3561 DDCD 22 A8 00 E1           jsl   $e100a8
3562 DDD1 0C 20                 DC W:SetSysPrefs               ;set the system preference
3563 DDD3 72 A7 01 00           DC L:PSysPrefs
3564 DDD7
3565 DDD7 22 A8 00 E1           jsl   $e100a8                  ;do a get level call to get the current level
3566 DDDB 1B 20                 DC W:GetLevel
3567 DDDD 76 A7 01 00           DC L:PGetLevel                 ;get the level
3568 DDE1
3569 DDE1 A9 70 00              lda   #my_level
3570 DDE4 8D 7E A7              sta   PSetLevel.level
3571 DDE7
3572 DDE7 22 A8 00 E1           jsl   $e100a8
3573 DDEB 1A 20                 DC W:SetLevel                  ;set the current level
3574 DDED 7C A7 01 00           DC L:PSetLevel
3575 DDF1
3576 DDF1 22 A8 00 E1           jsl   $e100a8                  ;call GS/OS
3577 DDF5 10 20                 DC W:Open                      ;class 1 open call
3578 DDF7 26 A7 01 00           DC L:POpen
3579 DDFB 48                    pha   
3580 DDFC 08                    php   
3581 DDFD
3582 DDFD 22 A8 00 E1           jsl   $e100a8                  ;set back to user's setting
3583 DE01 1A 20                 DC W:SetLevel                  ;set the current level
3584 DE03 76 A7 01 00           DC L:PGetLevel                 ;(just reuse this parm block)
3585 DE07
3586 DE07 AD 9E A6              lda   users_prefs
3587 DE0A 8D 74 A7              sta   PSysPrefs.preferences
3588 DE0D 22 A8 00 E1           jsl   $e100a8
3589 DE11 0C 20                 DC W:SetSysPrefs               ;restore the caller's system preference
3590 DE13 72 A7 01 00           DC L:PSysPrefs
3591 DE17 20 CB BA              jsr   unlock_handles
3592 DE1A
3593 DE1A 28                    plp   
3594 DE1B 68                    pla   
3595 DE1C B0 50                 bcs   @oops                    ;return the error to the caller
3596 DE1E              @opened   
3597 DE1E 64 A6                 stz   local_mark
3598 DE20 64 A8                 stz   local_mark+2             ;we are at the beginning of the file.
3599 DE22 AD 28 A7              lda   |POpen.refNum            ;setup the reference number
3600 DE25 8D 4C A7              sta   |PRead.fileRefNum
3601 DE28 8D 5A A7              sta   |PGetMark.markRefNum
3602 DE2B 8D 60 A7              sta   |PSetMark.markRefNum
3603 DE2E A9 01 00              lda   #$0001                   ;indicate that the file is open
3604 DE31 85 B4                 sta   file_open
3605 DE33
3606 DE33              *** added 18-Aug-92 DAL -- allow file types $003x
3607 DE33 AD 34 A7              lda   |POpen.fileType
3608 DE36 29 F0 FF              and   #$FFF0
3609 DE39 C9 30 00              cmp   #$0030
3610 DE3C F0 12                 beq   @chk_length
3611 DE3E              *** end 18-Aug-92
3612 DE3E
3613 DE3E AD 34 A7              lda   |POpen.fileType          ;get returned filetype
3614 DE41 C9 B3 00              cmp   #Load_File
3615 DE44 90 24                 bcc   @no_way
3616 DE46 C9 BF 00              cmp   #Last_Load_File+1        ;max file type that we support
3617 DE49 90 05                 bcc   @chk_length
3618 DE4B C9 C7 00              cmp   #$C7                     ;is it a CDev file?
3619 DE4E D0 1A                 bne   @no_way                  ;nope, can't be a load file
3620 DE50              @chk_length  
3621 DE50 20 62 BA              jsr   lock_handles             ;lock the handles around the OS call
3622 DE53 22 A8 00 E1           jsl   $E100A8                  ;Call GS/OS
3623 DE57 19 00                 DC W:GET_EOF                   ; GetEOF
3624 DE59 5A A7 01 00           DC L:PGetMark
3625 DE5D 20 CB BA              jsr   unlock_handles
3626 DE60 B0 0C                 bcs   @oops
3627 DE62 AD 5C A7              lda   |PGetMark.position       ;is there anything in the file?
3628 DE65 0D 5E A7              ora   |PGetMark.position+2
3629 DE68 D0 04                 bne   @oops                    ;actually no error
3630 DE6A              @no_way   
3631 DE6A A9 04 11              lda   #not_load_file           ;Incompatible file format
3632 DE6D 38                    sec   
3633 DE6E              @oops     
3634 DE6E 60                    rts                            ;return error
3635 DE6F                       endp 
3636 DE6F
3637 DE6F                       TITLE ', ExpressLoad.a - conv_attributes'
3638 DE6F              ;====================================================================================================
3639 DE6F              ;conv_attributes:       This routine will convert the attributes in the segment header to
3640 DE6F              ;                       memory manager attributes
3641 DE6F              ;
3642 DE6F              ;
3643 DE6F              ;Input:         A = undefined
3644 DE6F              ;               X = undefined
3645 DE6F              ;               Y = undefined
3646 DE6F              ;               P = nvmxdizc
3647 DE6F              ;                   ..000...
3648 DE6F              ;               b = k
3649 DE6F              ;
3650 DE6F              ;               seg_header_ptr                  ;must be setup
3651 DE6F              ;
3652 DE6F              ;Output:        A = Memory Manager Attributes
3653 DE6F              ;               X = undefined
3654 DE6F              ;               Y = undefined
3655 DE6F              ;               P = nvmxdizc
3656 DE6F              ;                   ..000...
3657 DE6F              ;               b = k
3658 DE6F              ;
3659 DE6F              ;
3660 DE6F              ;====================================================================================================
3661 DE6F
3662 DE6F              mm_attr_tbl record 
3663 DE6F
3664 DE6F              ;attr_locked    1 = segment is locked when allocated
3665 DE6F              ;attr_fixed     1 = segment can't move while it is in memory
3666 DE6F              ;attr_no_cross  1 = segment may not cross a bank boundary
3667 DE6F              ;attr_no_spec   1 = segment may not use special memory
3668 DE6F              ;attr_page      1 = segment will be page aligned
3669 DE6F              ;attr_addr      1 = segment will remain at fixed address
3670 DE6F              ;attr_bank      1 = segment must remain in fixed bank
3671 DE6F
3672 DE6F 10 C0                 DC W:attr_locked+attr_fixed+attr_no_cross
3673 DE71 11 C0                 DC W:attr_locked+attr_fixed+attr_no_cross+attr_bank
3674 DE73 18 C0                 DC W:attr_locked+attr_fixed+attr_no_cross+attr_no_spec
3675 DE75 19 C0                 DC W:attr_locked+attr_fixed+attr_no_cross+attr_no_spec+attr_bank
3676 DE77 10 80                 DC W:attr_locked+attr_no_cross
3677 DE79 11 80                 DC W:attr_locked+attr_no_cross+attr_bank
3678 DE7B 18 80                 DC W:attr_locked+attr_no_cross+attr_no_spec
3679 DE7D 19 80                 DC W:attr_locked+attr_no_cross+attr_no_spec+attr_bank
3680 DE7F
3681 DE7F 00 C0                 DC W:attr_locked+attr_fixed
3682 DE81 01 C0                 DC W:attr_locked+attr_fixed+attr_bank
3683 DE83 08 C0                 DC W:attr_locked+attr_fixed+attr_no_spec
3684 DE85 09 C0                 DC W:attr_locked+attr_fixed+attr_no_spec+attr_bank
3685 DE87 00 80                 DC W:attr_locked
3686 DE89 01 80                 DC W:attr_locked+attr_bank
3687 DE8B 08 80                 DC W:attr_locked+attr_no_spec
3688 DE8D 09 80                 DC W:attr_locked+attr_no_spec+attr_bank
3689 DE8F                       endr 
3690 DE8F
3691 DE8F
3692 DE8F                       longa on
3693 DE8F                       longi on
3694 DE8F              conv_attributes proc 
3695 DE8F                       with DirectPage, Globals
3696 DE8F
3697 DE8F A0 18 00              ldy   #SegHeaderEntry.Kind     ;get the segment kind
3698 DE92 B7 4E                 lda   [seg_header_ptr],y
3699 DE94 85 BA                 sta   seg_kind                 ;save the word for later
3700 DE96 EB                    xba                            ;get the segment attributes
3701 DE97 4A                    lsr   a
3702 DE98 4A                    lsr   a
3703 DE99 4A                    lsr   a                        ;move abs. bank, special mem, and pos. independent
3704 DE9A 29 07 00              and   #$0007                   ;clear other garbage
3705 DE9D 85 DE                 sta   mm_attr                  ;save temporarily
3706 DE9F              ;
3707 DE9F              ;If the bank size = $10000 then we must set the no_cross bit in the attribute
3708 DE9F              ;
3709 DE9F A2 08 00              ldx   #$0008                   ;default is can cross
3710 DEA2 A0 14 00              ldy   #SegHeaderEntry.BankSize  ;get the bank size please
3711 DEA5 B7 4E                 lda   [seg_header_ptr],y
3712 DEA7 D0 09                 bne   @can_cross               ;it must be able to cross
3713 DEA9 C8                    iny   
3714 DEAA C8                    iny   
3715 DEAB B7 4E                 lda   [seg_header_ptr],y       ;get the high please
3716 DEAD F0 03                 beq   @can_cross               ;we can cross bank boundaries
3717 DEAF A2 00 00              ldx   #$0000
3718 DEB2              ;
3719 DEB2              ;now we get the memory manager attributes
3720 DEB2              ;
3721 DEB2              ; We have now handled the following bits:
3722 DEB2              ;
3723 DEB2              ;       (1)     absolute Bank
3724 DEB2              ;       (2)     special Memory
3725 DEB2              ;       (3)     position independent
3726 DEB2              ;       (4)     bank crossing
3727 DEB2              ;
3728 DEB2              @can_cross  
3729 DEB2 8A                    txa   
3730 DEB3 05 DE                 ora   mm_attr
3731 DEB5 0A                    asl   a
3732 DEB6 AA                    tax   
3733 DEB7 BD 6F DE              lda   mm_attr_tbl,x            ;get the correct atributes for memory manager
3734 DEBA              ;
3735 DEBA              ;We still need to handle the following things:
3736 DEBA              ;
3737 DEBA              ;       (1)     Purge Level     (3 for dynamics)
3738 DEBA              ;       (2)     Alignment       (page and Bank)
3739 DEBA              ;       (3)     Org             (fixed address)
3740 DEBA
3741 DEBA A6 BA                 ldx   seg_kind
3742 DEBC 10 03                 bpl   @its_static              ;this is a static segment
3743 DEBE 09 00 03              ora   #purge_level_3           ;set the purge level to three for dynamics
3744 DEC1              @its_static  
3745 DEC1 85 DE                 sta   mm_attr
3746 DEC3
3747 DEC3 A2 04 00              ldx   #attr_page               ;default is page aligned
3748 DEC6 A0 20 00              ldy   #SegHeaderEntry.Align    ;offset to the alignment field
3749 DEC9 B7 4E                 lda   [seg_header_ptr],y
3750 DECB F0 0A                 beq   @align_high
3751 DECD C9 01 01              cmp   #257
3752 DED0 90 0E                 bcc   @set_aligned             ;align to a page boundary
3753 DED2 A2 20 00              ldx   #attr_bank_align         ;force bank alignment
3754 DED5 80 09                 bra   @set_aligned
3755 DED7              @align_high  
3756 DED7 C8                    iny   
3757 DED8 C8                    iny   
3758 DED9 A2 20 00              ldx   #attr_bank_align         ;force bank alignment
3759 DEDC B7 4E                 lda   [seg_header_ptr],y
3760 DEDE F0 03                 beq   @do_org                  ;there is no alignment
3761 DEE0              @set_aligned  
3762 DEE0 8A                    txa   
3763 DEE1 04 DE                 tsb   mm_attr                  ;add in the alignment bit
3764 DEE3              @do_org   
3765 DEE3 A0 1C 00              ldy   #SegHeaderEntry.Org      ;offset to segment org
3766 DEE6 B7 4E                 lda   [seg_header_ptr],y
3767 DEE8 85 C0                 sta   org_address
3768 DEEA C8                    iny   
3769 DEEB C8                    iny   
3770 DEEC B7 4E                 lda   [seg_header_ptr],y
3771 DEEE 85 C2                 sta   org_address+2
3772 DEF0 05 C0                 ora   org_address
3773 DEF2 F0 10                 beq   @no_org
3774 DEF4
3775 DEF4 A5 C0                 lda   org_address              ;if the low byte is non-zero then fixed attr = true
3776 DEF6 D0 07                 bne   @do_fixed_addr
3777 DEF8 A5 BA                 lda   seg_kind                 ;see if this is a absolute bank segment
3778 DEFA 29 00 08              and   #kind_abs_bank
3779 DEFD D0 05                 bne   @no_org                  ;This is absolute bank but not fixed address
3780 DEFF
3781 DEFF              @do_fixed_addr  
3782 DEFF A9 02 00              lda   #attr_addr               ;block must remain at fixed addr
3783 DF02 04 DE                 tsb   mm_attr
3784 DF04              @no_org   
3785 DF04 A5 BA                 lda   seg_kind                 ;see if this is an absolute Bank only
3786 DF06 A8                    tay   
3787 DF07 29 00 01              and   #kind_bank_bit           ;see if this segment is aligned in any bank
3788 DF0A F0 05                 beq   @not_aligned_in_bank
3789 DF0C
3790 DF0C A9 40 00              lda   #attr_align_in_bank
3791 DF0F 04 DE                 tsb   mm_attr                  ;segment is aligned within the bank
3792 DF11
3793 DF11              ;
3794 DF11              ;Now we need to handle the direct page / stack segment
3795 DF11              ;
3796 DF11              @not_aligned_in_bank  
3797 DF11 98                    tya   
3798 DF12 89 00 08              bit   #kind_abs_bank           ;absolute bank segment?
3799 DF15 D0 0E                 bne   @is_abs                  ;yes, allow special memory
3800 DF17 29 1F 00              and   #kind_only               ;clear attributes
3801 DF1A C9 12 00              cmp   #dp_seg_type             ;DP/Stack segment?
3802 DF1D D0 0C                 bne   @no_stack                ;no, conditionalize special memory bit
3803 DF1F
3804 DF1F A5 DE                 lda   mm_attr
3805 DF21 09 05 00              ora   #attr_page+attr_bank     ;fixed bank and page aligned
3806 DF24              ;        sta   mm_attr
3807 DF24 60                    rts                            ;skip special memory flag
3808 DF25
3809 DF25              @is_abs   
3810 DF25 A5 DE                 lda   mm_attr                  ;must return attributes in accumulator
3811 DF27 29 F7 FF              and   #attr_no_spec
3812 DF2A              ;        sta   mm_attr
3813 DF2A 60                    rts   
3814 DF2B
3815 DF2B              @no_stack  
3816 DF2B A5 DE                 lda   mm_attr
3817 DF2D A6 B2                 ldx   spec_mem_flag            ;check the special memory flag
3818 DF2F F0 03                 beq   @skip_spec
3819 DF31 09 08 00              ora   #attr_no_spec            ;sorry bud no special memory for you
3820 DF34              ;        sta   mm_attr
3821 DF34
3822 DF34              @skip_spec  
3823 DF34 60                    rts   
3824 DF35                       endp 
3825 DF35
3826 DF35                       TITLE ', ExpressLoad.a - reset_jmp_tables'
3827 DF35              ;====================================================================================================
3828 DF35              ;reset_jmp_tables:      This routine will mark all jump table segments as unloaded for a given
3829 DF35              ;                       user id
3830 DF35              ;
3831 DF35              ;
3832 DF35              ;Input:         A = undefined
3833 DF35              ;               X = undefined
3834 DF35              ;               Y = undefined
3835 DF35              ;               P = nvmxdizc
3836 DF35              ;                   ..000...
3837 DF35              ;               b = k
3838 DF35              ;
3839 DF35              ;               ExpressHandle           ;must be setup
3840 DF35              ;
3841 DF35              ;Output:        A = undefined
3842 DF35              ;               X = undefined
3843 DF35              ;               Y = undefined
3844 DF35              ;               P = nvmxdizc
3845 DF35              ;                   ..000..1 = error
3846 DF35              ;               b = k
3847 DF35              ;
3848 DF35              ;
3849 DF35              ;====================================================================================================
3850 DF35
3851 DF35                       longa on
3852 DF35                       longi on
3853 DF35              reset_jmp_tables proc  
3854 DF35                       with DirectPage, Globals
3855 DF35
3856 DF35 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
3857 DF37 1A                    inc   a                        ;start from the last segment
3858 DF38 1A                    inc   a
3859 DF39 AA                    tax   
3860 DF3A              @search_loop  
3861 DF3A 8A                    txa                            ;pass in the segment number
3862 DF3B F0 18                 beq   @end_reset               ;sorry there is no segment by this name
3863 DF3D DA                    phx   
3864 DF3E 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
3865 DF41 A0 02 00              ldy   #HET_Entry.SegFlags      ;see if this is a jump segment
3866 DF44 B7 42                 lda   [HET_entry_ptr],y
3867 DF46 29 02 00              and   #jmp_type
3868 DF49 F0 03                 beq   @not_jump
3869 DF4B 20 57 DF              jsr   clr_table                ;clear this segment
3870 DF4E              @not_jump  
3871 DF4E FA                    plx   
3872 DF4F CA                    dex                            ;back off by one and try again
3873 DF50 E0 01 00              cpx   #$0001
3874 DF53 D0 E5                 bne   @search_loop
3875 DF55              @end_reset  
3876 DF55 18                    clc   
3877 DF56 60                    rts   
3878 DF57              clr_table  
3879 DF57 A0 04 00              ldy   #HET_Entry.SegHandle
3880 DF5A B7 42                 lda   [HET_entry_ptr],y
3881 DF5C 85 46                 sta   temp_handle
3882 DF5E C8                    iny   
3883 DF5F C8                    iny   
3884 DF60 B7 42                 lda   [HET_entry_ptr],y
3885 DF62 85 48                 sta   temp_handle+2
3886 DF64
3887 DF64 A0 02 00              ldy   #$0002                   ;point to the first entry in table
3888 DF67 18                    clc   
3889 DF68 A7 46                 lda   [temp_handle]
3890 DF6A 69 08 00              adc   #seg_jmp_start
3891 DF6D 85 62                 sta   temp_ptr
3892 DF6F B7 46                 lda   [temp_handle],y
3893 DF71 69 00 00              adc   #$0000
3894 DF74 85 64                 sta   temp_ptr+2
3895 DF76              @loop     
3896 DF76 A0 02 00              ldy   #JE_FileNum              ;see if we are done
3897 DF79 B7 62                 lda   [temp_ptr],y
3898 DF7B F0 27                 beq   @done
3899 DF7D
3900 DF7D AD B6 A6              lda   |USERID                  ;see if this is the user ID
3901 DF80 C7 62                 cmp   [temp_ptr]
3902 DF82 D0 0F                 bne   @next_entry
3903 DF84
3904 DF84 A0 0A 00              ldy   #JE_jsl                  ;index to the JSL instruction
3905 DF87 AD AF A8              lda   jump_load_instr          ;store the Jump Load Instruction
3906 DF8A 97 62                 sta   [temp_ptr],y
3907 DF8C C8                    iny   
3908 DF8D C8                    iny   
3909 DF8E AD B1 A8              lda   jump_load_instr+2
3910 DF91 97 62                 sta   [temp_ptr],y
3911 DF93              @next_entry  
3912 DF93 18                    clc   
3913 DF94 A5 62                 lda   temp_ptr
3914 DF96 69 0E 00              adc   #jmp_entry_size          ;size of one entry
3915 DF99 85 62                 sta   temp_ptr
3916 DF9B A5 64                 lda   temp_ptr+2
3917 DF9D 69 00 00              adc   #$0000
3918 DFA0 85 64                 sta   temp_ptr+2
3919 DFA2 80 D2                 bra   @loop
3920 DFA4              @done     
3921 DFA4 60                    rts   
3922 DFA5                       endp 
3923 DFA5
3924 DFA5                       TITLE ', ExpressLoad.a - make_purgable'
3925 DFA5              ;====================================================================================================
3926 DFA5              ;make_purgable: This routine will make segment purgable and unlocked
3927 DFA5              ;
3928 DFA5              ;
3929 DFA5              ;Input:         A = segment_number
3930 DFA5              ;               X = undefined
3931 DFA5              ;               Y = undefined
3932 DFA5              ;               P = nvmxdizc
3933 DFA5              ;                   ..000...
3934 DFA5              ;               b = k
3935 DFA5              ;
3936 DFA5              ;               ExpressHandle           ;must be setup
3937 DFA5              ;
3938 DFA5              ;Output:        A = undefined
3939 DFA5              ;               X = undefined
3940 DFA5              ;               Y = undefined
3941 DFA5              ;               P = nvmxdizc
3942 DFA5              ;                   ..000..1 = error
3943 DFA5              ;               b = k
3944 DFA5              ;
3945 DFA5              ;
3946 DFA5              ;====================================================================================================
3947 DFA5
3948 DFA5                       longa on
3949 DFA5                       longi on
3950 DFA5              make_purgable proc 
3951 DFA5                       with DirectPage, Globals
3952 DFA5
3953 DFA5 85 AC                 sta   search_seg               ;segment we need to nuke
3954 DFA7 20 44 D2              jsr   make_HET_ptr
3955 DFAA A5 AC                 lda   search_seg
3956 DFAC 20 5E D2              jsr   setup_seg_ptrs           ;point to the entry please
3957 DFAF
3958 DFAF A0 02 00              ldy   #HET_Entry.SegFlags      ;see of it is loaded
3959 DFB2 B7 42                 lda   [HET_entry_ptr],y
3960 DFB4 30 05                 bmi   @do_it
3961 DFB6 A9 01 11     @no_seg  lda   #seg_not_found           ;seg_not_found
3962 DFB9 38                    sec   
3963 DFBA 60                    rts   
3964 DFBB              @do_it    
3965 DFBB A0 04 00              ldy   #HET_Entry.SegHandle     ;lets get the handle
3966 DFBE B7 42                 lda   [HET_entry_ptr],y
3967 DFC0 AA                    tax   
3968 DFC1 C8                    iny   
3969 DFC2 C8                    iny   
3970 DFC3 B7 42                 lda   [HET_entry_ptr],y
3971 DFC5 A8                    tay   
3972 DFC6 D0 03                 bne   @have_handle
3973 DFC8 8A                    txa   
3974 DFC9 F0 EB                 beq   @no_seg
3975 DFCB              @have_handle  
3976 DFCB F4 03 00              pea   $0003                    ;make it purgable
3977 DFCE 5A                    phy   
3978 DFCF DA                    phx                            ;push the handle
3979 DFD0
3980 DFD0 86 46                 stx   temp_handle
3981 DFD2 84 48                 sty   temp_handle+2            ;handle to the segment
3982 DFD4 A0 04 00              ldy   #$0004                   ;lets unlock this puppy
3983 DFD7 B7 46                 lda   [temp_handle],y
3984 DFD9 29 FF 7F              and   #$7FFF
3985 DFDC 97 46                 sta   [temp_handle],y
3986 DFDE
3987 DFDE A0 02 00              ldy   #HET_Entry.SegFlags      ;mark this segment as Purgable
3988 DFE1 B7 42                 lda   [HET_entry_ptr],y
3989 DFE3 09 01 00              ora   #$0001
3990 DFE6 97 42                 sta   [HET_entry_ptr],y        ;segment is now marked purgable
3991 DFE8
3992 DFE8 20 35 DF              jsr   reset_jmp_tables         ;go and reset the jump tables for this ID
3993 DFEB
3994 DFEB A2 02 24 22           _SetPurge 
3995 DFF2 60                    rts                            ;return any error
3996 DFF3                       endp 
3997 DFF3
3998 DFF3                       TITLE ', ExpressLoad.a - purge_all_dyn'
3999 DFF3              ;====================================================================================================
4000 DFF3              ;purge_all_dyn: This routine will mark all dynamic segments as purgable
4001 DFF3              ;
4002 DFF3              ;
4003 DFF3              ;Input:         A = undefined
4004 DFF3              ;               X = undefined
4005 DFF3              ;               Y = undefined
4006 DFF3              ;               P = nvmxdizc
4007 DFF3              ;                   ..000...
4008 DFF3              ;               b = k
4009 DFF3              ;
4010 DFF3              ;               ExpressHandle           ;must be setup
4011 DFF3              ;
4012 DFF3              ;Output:        A = undefined
4013 DFF3              ;               X = undefined
4014 DFF3              ;               Y = undefined
4015 DFF3              ;               P = nvmxdizc
4016 DFF3              ;                   ..000..1 = error
4017 DFF3              ;               b = k
4018 DFF3              ;
4019 DFF3              ;
4020 DFF3              ;====================================================================================================
4021 DFF3
4022 DFF3                       longa on
4023 DFF3                       longi on
4024 DFF3              purge_all_dyn proc 
4025 DFF3                       with DirectPage, Globals
4026 DFF3
4027 DFF3
4028 DFF3 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
4029 DFF5 1A                    inc   a                        ;start from the last segment
4030 DFF6 1A                    inc   a
4031 DFF7 AA                    tax   
4032 DFF8              @search_loop  
4033 DFF8 8A                    txa                            ;pass in the segment number
4034 DFF9 F0 1E                 beq   @end_purge               ;sorry there is no segment
4035 DFFB DA                    phx   
4036 DFFC 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
4037 DFFF
4038 DFFF A0 18 00              ldy   #SegHeaderEntry.Kind     ;lets check the kind please
4039 E002 B7 4E                 lda   [seg_header_ptr],y
4040 E004 10 0C                 bpl   @skip_it                 ;skip the segment if it is not dynamic
4041 E006
4042 E006 A0 02 00              ldy   #HET_Entry.SegFlags      ;mark this segment as Purgable
4043 E009 B7 42                 lda   [HET_entry_ptr],y
4044 E00B 10 05                 bpl   @skip_it                 ;the segment is already unloaded
4045 E00D
4046 E00D A3 01                 lda   1,s                      ;get the seg number
4047 E00F 20 A5 DF              jsr   make_purgable
4048 E012              @skip_it  
4049 E012 FA                    plx   
4050 E013 CA                    dex                            ;back off by one and try again
4051 E014 E0 01 00              cpx   #$0001
4052 E017 D0 DF                 bne   @search_loop
4053 E019              @end_purge  
4054 E019 18                    clc   
4055 E01A 60                    rts   
4056 E01B                       endp 
4057 E01B
4058 E01B                       TITLE ', ExpressLoad.a - mark_all_purgable'
4059 E01B              ;====================================================================================================
4060 E01B              ;mark_all_purgable:     This routine will mark all segments as purgable
4061 E01B              ;
4062 E01B              ;
4063 E01B              ;Input:         A =undefined
4064 E01B              ;               X = undefined
4065 E01B              ;               Y = undefined
4066 E01B              ;               P = nvmxdizc
4067 E01B              ;                   ..000...
4068 E01B              ;               b = k
4069 E01B              ;
4070 E01B              ;               ExpressHandle           ;must be setup
4071 E01B              ;
4072 E01B              ;Output:        A = undefined
4073 E01B              ;               X = undefined
4074 E01B              ;               Y = undefined
4075 E01B              ;               P = nvmxdizc
4076 E01B              ;                   ..000..1 = error
4077 E01B              ;               b = k
4078 E01B              ;
4079 E01B              ;
4080 E01B              ;====================================================================================================
4081 E01B
4082 E01B                       longa on
4083 E01B                       longi on
4084 E01B              mark_all_purgable proc  
4085 E01B                       with DirectPage, Globals
4086 E01B
4087 E01B
4088 E01B A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
4089 E01D 1A                    inc   a                        ;start from the last segment
4090 E01E 1A                    inc   a
4091 E01F AA                    tax   
4092 E020              @search_loop  
4093 E020 8A                    txa                            ;pass in the segment number
4094 E021 F0 10                 beq   @end_purge               ;sorry there is no segment
4095 E023 DA                    phx   
4096 E024 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
4097 E027 A3 01                 lda   1,s                      ;get the seg number
4098 E029 20 59 E0              jsr   mark_purged
4099 E02C              @skip_it  
4100 E02C FA                    plx   
4101 E02D CA                    dex                            ;back off by one and try again
4102 E02E E0 01 00              cpx   #$0001
4103 E031 D0 ED                 bne   @search_loop
4104 E033              @end_purge  
4105 E033              ;
4106 E033              ;                unlock all load segments
4107 E033              ;
4108 E033 AD B6 A6              lda   |USERID                  ;push the User ID
4109 E036 48                    pha   
4110 E037 A2 02 23 22           _HUnlockAll 
4111 E03E
4112 E03E              ;
4113 E03E              ;                purge all other dynamic segments
4114 E03E              ;
4115 E03E AD B6 A6              lda   |USERID                  ;push the User ID
4116 E041 48                    pha   
4117 E042 A2 02 13 22           _PurgeAll 
4118 E049              ;
4119 E049              ;                make all static segments purgeable
4120 E049              ;
4121 E049 F4 03 00              pea   $0003                    ;Purge Level
4122 E04C AD B6 A6              lda   |USERID                  ;push the User ID
4123 E04F 48                    pha   
4124 E050 A2 02 25 22           _SetPurgeAll 
4125 E057
4126 E057 18                    clc   
4127 E058 60                    rts   
4128 E059
4129 E059
4130 E059              mark_purged  
4131 E059 85 AC                 sta   search_seg               ;segment we need to nuke
4132 E05B 20 44 D2              jsr   make_HET_ptr
4133 E05E A5 AC                 lda   search_seg
4134 E060 20 5E D2              jsr   setup_seg_ptrs           ;point to the entry please
4135 E063
4136 E063 A0 02 00              ldy   #HET_Entry.SegFlags      ;see of it is loaded
4137 E066 B7 42                 lda   [HET_entry_ptr],y
4138 E068 30 05                 bmi   @do_it
4139 E06A A9 01 11     @no_seg  lda   #seg_not_found           ;seg_not_found
4140 E06D 38                    sec   
4141 E06E 60                    rts   
4142 E06F              @do_it    
4143 E06F A0 04 00              ldy   #HET_Entry.SegHandle     ;lets get the handle
4144 E072 B7 42                 lda   [HET_entry_ptr],y
4145 E074 AA                    tax   
4146 E075 C8                    iny   
4147 E076 C8                    iny   
4148 E077 B7 42                 lda   [HET_entry_ptr],y
4149 E079 A8                    tay   
4150 E07A D0 03                 bne   @have_handle
4151 E07C 8A                    txa   
4152 E07D F0 EB                 beq   @no_seg
4153 E07F              @have_handle  
4154 E07F
4155 E07F 86 46                 stx   temp_handle
4156 E081 84 48                 sty   temp_handle+2            ;handle to the segment
4157 E083 A0 04 00              ldy   #$0004                   ;lets unlock this puppy
4158 E086 B7 46                 lda   [temp_handle],y
4159 E088 29 FF 7F              and   #$7FFF
4160 E08B 97 46                 sta   [temp_handle],y
4161 E08D
4162 E08D A0 02 00              ldy   #HET_Entry.SegFlags      ;mark this segment as Purgable
4163 E090 B7 42                 lda   [HET_entry_ptr],y
4164 E092 09 01 00              ora   #$0001
4165 E095 97 42                 sta   [HET_entry_ptr],y        ;segment is now marked purgable
4166 E097
4167 E097 20 35 DF              jsr   reset_jmp_tables         ;go and reset the jump tables for this ID
4168 E09A 18                    clc   
4169 E09B 60                    rts   
4170 E09C                       endp 
4171 E09C
4172 E09C                       TITLE ', ExpressLoad.a - lock_statics'
4173 E09C              ;====================================================================================================
4174 E09C              ;lock_statics:  This routine will check and see if all the static segments are loaded.  It will
4175 E09C              ;               also lock all the static segments that it finds.  If any of the static segments
4176 E09C              ;               have been purged the routine will error out with the carry set
4177 E09C              ;
4178 E09C              ;
4179 E09C              ;Input:         A = undefined
4180 E09C              ;               X = undefined
4181 E09C              ;               Y = undefined
4182 E09C              ;               P = nvmxdizc
4183 E09C              ;                   ..000...
4184 E09C              ;               b = k
4185 E09C              ;
4186 E09C              ;               ExpressHandle           ;must be setup
4187 E09C              ;
4188 E09C              ;Output:        A = undefined
4189 E09C              ;               X = undefined
4190 E09C              ;               Y = undefined
4191 E09C              ;               P = nvmxdizc
4192 E09C              ;                   ..000..1 = error all static segments are not loaded
4193 E09C              ;               b = k
4194 E09C              ;
4195 E09C              ;
4196 E09C              ;====================================================================================================
4197 E09C
4198 E09C                       longa on
4199 E09C                       longi on
4200 E09C              lock_statics proc 
4201 E09C                       with DirectPage, Globals
4202 E09C
4203 E09C 64 72                 stz   temp_word                ;If zero on exit then there were no static segments
4204 E09E
4205 E09E 20 44 D2              jsr   make_HET_ptr             ;convert ExpressHandle into pointers
4206 E0A1
4207 E0A1 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
4208 E0A3 1A                    inc   a                        ;start from the last segment
4209 E0A4 1A                    inc   a
4210 E0A5 AA                    tax   
4211 E0A6              @search_loop  
4212 E0A6 8A                    txa                            ;pass in the segment number
4213 E0A7 F0 10                 beq   @end_lock                ;sorry there is no segment
4214 E0A9 DA                    phx   
4215 E0AA 20 5E D2              jsr   setup_seg_ptrs           ;setup pointer to the Header Entry
4216 E0AD 20 C1 E0              jsr   lock_it
4217 E0B0 FA                    plx   
4218 E0B1 B0 0C                 bcs   @error_out
4219 E0B3 CA                    dex                            ;back off by one and try again
4220 E0B4 E0 01 00              cpx   #$0001
4221 E0B7 D0 ED                 bne   @search_loop
4222 E0B9              @end_lock  
4223 E0B9 A5 72                 lda   temp_word                ;see if we encountered any static segments
4224 E0BB F0 02                 beq   @error_out
4225 E0BD 18                    clc   
4226 E0BE 60                    rts   
4227 E0BF              @error_out  
4228 E0BF 38                    sec                            ;sorry there are no static segments or not all
4229 E0C0                                                      ;segments are still in memory
4230 E0C0 60                    rts   
4231 E0C1              lock_it   
4232 E0C1 A0 02 00              ldy   #HET_Entry.SegFlags      ;first lets see if this is a static segment
4233 E0C4 B7 42                 lda   [HET_entry_ptr],y
4234 E0C6 29 04 00              and   #stat_type
4235 E0C9 F0 39                 beq   @not_static              ;its not static so we do not care about the segment
4236 E0CB
4237 E0CB 85 72                 sta   temp_word                ;this is used as a flag to indicate that there are
4238 E0CD                                                      ;static segments that can be locked
4239 E0CD A0 04 00              ldy   #HET_Entry.SegHandle     ;now lets see if the segment has been purged
4240 E0D0 B7 42                 lda   [HET_entry_ptr],y
4241 E0D2 AA                    tax   
4242 E0D3 C8                    iny   
4243 E0D4 C8                    iny   
4244 E0D5 B7 42                 lda   [HET_entry_ptr],y
4245 E0D7 A8                    tay   
4246 E0D8 07 42                 ora   [HET_entry_ptr]          ;check for a null handle
4247 E0DA D0 02                 bne   @handle_OK
4248 E0DC              @bad_handle  
4249 E0DC 38                    sec   
4250 E0DD 60                    rts                            ;the handle is scewed up
4251 E0DE              @handle_OK  
4252 E0DE 86 46                 stx   temp_handle
4253 E0E0 84 48                 sty   temp_handle+2
4254 E0E2 A0 02 00              ldy   #$0002
4255 E0E5 A7 46                 lda   [temp_handle]
4256 E0E7 17 46                 ora   [temp_handle],y          ;valid handle?
4257 E0E9 F0 F1                 beq   @bad_handle              ;nope
4258 E0EB
4259 E0EB A0 04 00              ldy   #$0004                   ;now lets lock the handle please
4260 E0EE B7 46                 lda   [temp_handle],y
4261 E0F0 09 00 80              ora   #$8000                   ;set the lock bit
4262 E0F3 97 46                 sta   [temp_handle],y
4263 E0F5
4264 E0F5 F4 00 00              pea   #$0000                   ;set the purge level to zero
4265 E0F8 D4 48                 pei   temp_handle+2
4266 E0FA D4 46                 pei   temp_handle
4267 E0FC A2 02 24 22           _SetPurge 
4268 E103 60                    rts                            ;carry is set based on the call.
4269 E104
4270 E104              @not_static  
4271 E104 18                    clc   
4272 E105 60                    rts   
4273 E106                       endp 
4274 E106
4275 E106                       TITLE ', ExpressLoad.a - lock_segment'
4276 E106              ;====================================================================================================
4277 E106              ;lock_segment:  This routine will make segment purgable and locked
4278 E106              ;
4279 E106              ;
4280 E106              ;Input:         A = segment_number
4281 E106              ;               X = undefined
4282 E106              ;               Y = undefined
4283 E106              ;               P = nvmxdizc
4284 E106              ;                   ..000...
4285 E106              ;               b = k
4286 E106              ;
4287 E106              ;               ExpressHandle           ;must be setup
4288 E106              ;
4289 E106              ;Output:        A = undefined
4290 E106              ;               X = undefined
4291 E106              ;               Y = undefined
4292 E106              ;               P = nvmxdizc
4293 E106              ;                   ..000..1 = error
4294 E106              ;               b = k
4295 E106              ;
4296 E106              ;
4297 E106              ;====================================================================================================
4298 E106
4299 E106                       longa on
4300 E106                       longi on
4301 E106              lock_segment proc 
4302 E106                       with DirectPage, Globals
4303 E106
4304 E106 85 AC                 sta   search_seg               ;segment we need to lock
4305 E108 20 44 D2              jsr   make_HET_ptr
4306 E10B A5 AC                 lda   search_seg               ;segment we need to lock
4307 E10D 20 5E D2              jsr   setup_seg_ptrs           ;point to the entry please
4308 E110
4309 E110 A0 02 00              ldy   #HET_Entry.SegFlags      ;see of it is loaded
4310 E113 B7 42                 lda   [HET_entry_ptr],y
4311 E115 4A                    lsr   a
4312 E116 B0 02                 bcs   @do_it                   ;yep the segment is unlocked
4313 E118 18                    clc   
4314 E119 60                    rts   
4315 E11A              @do_it    
4316 E11A A0 04 00              ldy   #HET_Entry.SegHandle     ;lets get the handle
4317 E11D B7 42                 lda   [HET_entry_ptr],y
4318 E11F AA                    tax   
4319 E120 C8                    iny   
4320 E121 C8                    iny   
4321 E122 B7 42                 lda   [HET_entry_ptr],y
4322 E124 A8                    tay   
4323 E125 D0 03                 bne   @have_handle
4324 E127 8A                    txa   
4325 E128 F0 2E                 beq   @no_seg
4326 E12A              @have_handle  
4327 E12A 5A                    phy   
4328 E12B DA                    phx                            ;push the handle
4329 E12C
4330 E12C 86 46                 stx   temp_handle
4331 E12E 84 48                 sty   temp_handle+2            ;handle to the segment
4332 E130
4333 E130 A0 02 00              ldy   #$0002                   ;deref the handle to see if it is nill
4334 E133 A7 46                 lda   [temp_handle]
4335 E135 17 46                 ora   [temp_handle],y
4336 E137 D0 24                 bne   @lock_it
4337 E139
4338 E139 A0 02 00              ldy   #HET_Entry.SegFlags      ;mark segment as gone
4339 E13C A9 00 00              lda   #$0000
4340 E13F 97 42                 sta   [HET_entry_ptr],y
4341 E141 A0 04 00              ldy   #HET_Entry.SegHandle
4342 E144 97 42                 sta   [HET_entry_ptr],y
4343 E146 C8                    iny   
4344 E147 C8                    iny   
4345 E148 97 42                 sta   [HET_entry_ptr],y        ;zero the handle also
4346 E14A
4347 E14A 20 00 D0              jsr   clear_handles            ;clear local copy of handle
4348 E14D A2 02 10 22           _DisposeHandle 
4349 E154 64 46                 stz   temp_handle
4350 E156 64 48                 stz   temp_handle+2            ;Temp Handle is not valid
4351 E158              @no_seg   
4352 E158 A9 01 11              lda   #seg_not_found
4353 E15B 38                    sec   
4354 E15C 60                    rts                            ;indicate segment is gone
4355 E15D
4356 E15D A0 04 00     @lock_it ldy   #$0004                   ;lets lock this puppy
4357 E160 B7 46                 lda   [temp_handle],y
4358 E162 09 00 80              ora   #$8000
4359 E165 97 46                 sta   [temp_handle],y
4360 E167
4361 E167 A0 02 00              ldy   #HET_Entry.SegFlags      ;mark this segment as locked
4362 E16A B7 42                 lda   [HET_entry_ptr],y
4363 E16C 29 FE FF              and   #$FFFE                   ;clear the Unlocked Bit
4364 E16F 97 42                 sta   [HET_entry_ptr],y        ;segment is now marked purgable
4365 E171 FA                    plx   
4366 E172 7A                    ply   
4367 E173 18                    clc                            ;indicate segment is safely locked down
4368 E174 60                    rts   
4369 E175                       endp 
4370 E175
4371 E175                       TITLE ', ExpressLoad.a - load_segment'
4372 E175              ;====================================================================================================
4373 E175              ;load_segment:  This routine will load a segment into memory
4374 E175              ;
4375 E175              ;
4376 E175              ;Input:         A = undefined
4377 E175              ;               X = undefined
4378 E175              ;               Y = undefined
4379 E175              ;               P = nvmxdizc
4380 E175              ;                   ..000...
4381 E175              ;               b = k
4382 E175              ;
4383 E175              ;               HET_entry_ptr                   ;must be setup
4384 E175              ;               seg_header_ptr  - Pointer to SegHeaderEntry
4385 E175              ;
4386 E175              ;Output:        A = undefined
4387 E175              ;               X = undefined
4388 E175              ;               Y = undefined
4389 E175              ;               P = nvmxdizc
4390 E175              ;                   ..000...
4391 E175              ;               b = k
4392 E175              ;
4393 E175              ;
4394 E175              ;====================================================================================================
4395 E175
4396 E175                       longa on
4397 E175                       longi on
4398 E175              load_segment proc 
4399 E175                       with DirectPage, Globals
4400 E175
4401 E175 64 90                 stz   reloc_handle
4402 E177 64 92                 stz   reloc_handle+2
4403 E179 A0 2E 00              ldy   #SegHeaderEntry.RelocDict_Hndl  ;set handle to zero
4404 E17C A9 00 00              lda   #$0000
4405 E17F 97 4E                 sta   [seg_header_ptr],y
4406 E181 C8                    iny   
4407 E182 C8                    iny   
4408 E183 97 4E                 sta   [seg_header_ptr],y
4409 E185
4410 E185 20 8F DE              jsr   conv_attributes          ;convert the attributes to something useful
4411 E188              ;
4412 E188              ;On exit conv_attributes sets A to memory manager Attributes
4413 E188              ;
4414 E188 85 D8                 sta   mem_attr
4415 E18A
4416 E18A A0 02 00              ldy   #SegHeaderEntry.LConst_Mark+2
4417 E18D A7 4E                 lda   [seg_header_ptr]
4418 E18F AA                    tax   
4419 E190 B7 4E                 lda   [seg_header_ptr],y
4420 E192 A8                    tay   
4421 E193 A9 00 00              lda   #absolute
4422 E196 20 FD DA              jsr   set_mark
4423 E199 90 01                 bcc   @mark1_set
4424 E19B 60           @oops    rts                            ;return the error
4425 E19C              @mark1_set  
4426 E19C A0 04 00              ldy   #SegHeaderEntry.LConst_Length ;now lets get the size of the segment
4427 E19F B7 4E                 lda   [seg_header_ptr],y
4428 E1A1 8D 52 A7              sta   |PRead.requestCount
4429 E1A4 85 B6                 sta   LConst_Size
4430 E1A6 C8                    iny   
4431 E1A7 C8                    iny   
4432 E1A8 B7 4E                 lda   [seg_header_ptr],y       ;get the high count
4433 E1AA 8D 54 A7              sta   |PRead.requestCount+2
4434 E1AD 85 B8                 sta   LConst_Size+2
4435 E1AF              ;
4436 E1AF              ;Now lets see if we already have memory.  We will have memory if we are reloading a restart segment
4437 E1AF              ;
4438 E1AF A0 04 00              ldy   #HET_Entry.SegHandle     ;see if we already have the memory segment
4439 E1B2 B7 42                 lda   [HET_entry_ptr],y
4440 E1B4 AA                    tax   
4441 E1B5 C8                    iny   
4442 E1B6 C8                    iny   
4443 E1B7 B7 42                 lda   [HET_entry_ptr],y
4444 E1B9 A8                    tay   
4445 E1BA D0 4C                 bne   @skip_alloc              ;we already have the memory
4446 E1BC 8A                    txa   
4447 E1BD D0 49                 bne   @skip_alloc              ;this must be a restart call
4448 E1BF
4449 E1BF A5 BA                 lda   seg_kind                 ;what kind of segment is it?
4450 E1C1 89 00 08              bit   #kind_abs_bank           ;absolute bank segment?
4451 E1C4 D0 37                 bne   @just_allocate           ;yes, use attributes as is
4452 E1C6 29 1F 00              and   #kind_only
4453 E1C9 C9 12 00              cmp   #dp_seg_type             ;is it a DP segment?
4454 E1CC F0 2F                 beq   @just_allocate           ;yes, so we HAVE to allow special memory
4455 E1CE A5 D8                 lda   mem_attr                 ;get the original attributes
4456 E1D0 48                    pha                            ;save 'em
4457 E1D1 09 08 00              ora   #attr_no_spec            ;set the 'no-special-memory' bit
4458 E1D4 85 D8                 sta   mem_attr
4459 E1D6              @try_again  
4460 E1D6 AE 52 A7              ldx   |PRead.requestCount
4461 E1D9 AC 54 A7              ldy   |PRead.requestCount+2    ;load the number of bytes to allocate for the segment
4462 E1DC 20 9A D0              jsr   alloc_LConst_seg         ;allocate the memory for the segment
4463 E1DF B0 05                 bcs   @had_error
4464 E1E1 68                    pla                            ;restore original attributes
4465 E1E2 85 D8                 sta   mem_attr
4466 E1E4 80 22                 bra   @skip_alloc              ;all is fine, continue
4467 E1E6
4468 E1E6              @had_error  
4469 E1E6 FA                    plx                            ;retrieve original attributes
4470 E1E7 A8                    tay                            ;save error code
4471 E1E8 A5 D8                 lda   mem_attr                 ;get the attributes we just used
4472 E1EA 29 08 00              and   #$0008                   ;did we allow special memory?
4473 E1ED F0 0B                 beq   @oops2                   ;yes, and still had a problem!
4474 E1EF 8A                    txa                            ;get the original attributes
4475 E1F0 29 08 00              and   #$0008                   ;did they allow special memory?
4476 E1F3 D0 05                 bne   @oops2                   ;no, don't override their wishes
4477 E1F5 86 D8                 stx   mem_attr                 ;restore original attributes
4478 E1F7 DA                    phx                            ;back on stack
4479 E1F8 80 DC                 bra   @try_again               ;go back and try to allocate again
4480 E1FA
4481 E1FA              @oops2    
4482 E1FA 98                    tya                            ;restore error code
4483 E1FB 80 9E                 bra   @oops                    ;and exit
4484 E1FD
4485 E1FD              @just_allocate  
4486 E1FD AE 52 A7              ldx   |PRead.requestCount
4487 E200 AC 54 A7              ldy   |PRead.requestCount+2    ;load the number of bytes to allocate for the segment
4488 E203 20 9A D0              jsr   alloc_LConst_seg         ;allocate the memory for the segment
4489 E206 B0 93                 bcs   @oops
4490 E208              @skip_alloc  
4491 E208 86 46                 stx   temp_handle
4492 E20A 86 94                 stx   seg_handle
4493 E20C 84 48                 sty   temp_handle+2
4494 E20E 84 96                 sty   seg_handle+2
4495 E210
4496 E210 A0 04 00              ldy   #HET_Entry.SegHandle     ;update the handle address in HET entry
4497 E213 8A                    txa   
4498 E214 97 42                 sta   [HET_entry_ptr],y
4499 E216 A5 48                 lda   temp_handle+2
4500 E218 C8                    iny   
4501 E219 C8                    iny   
4502 E21A 97 42                 sta   [HET_entry_ptr],y
4503 E21C
4504 E21C A0 02 00              ldy   #$0002                   ;deref the handle please
4505 E21F A7 46                 lda   [temp_handle]
4506 E221 85 4A                 sta   base_ptr                 ;address of the image
4507 E223 AA                    tax   
4508 E224 B7 46                 lda   [temp_handle],y
4509 E226 85 4C                 sta   base_ptr+2
4510 E228 A8                    tay   
4511 E229
4512 E229 20 D2 DA              jsr   read_wBuf_ptr            ;read in the segment please
4513 E22C 90 01                 bcc   @add_seg_offset
4514 E22E 60                    rts   
4515 E22F              @add_seg_offset  
4516 E22F 20 FD E2              jsr   add_segment_offset       ;add seg offset to base_ptr return value in X&Y
4517 E232
4518 E232                       entry load_reloc_dict
4519 E232              load_reloc_dict                         ;go ahead and load the relocation dictionary
4520 E232              ;
4521 E232              ;Now lets do the relocation dictionary
4522 E232              ;
4523 E232 A0 08 00              ldy   #SegHeaderEntry.RelocDict_Mark
4524 E235 B7 4E                 lda   [seg_header_ptr],y
4525 E237 AA                    tax   
4526 E238 C8                    iny   
4527 E239 C8                    iny   
4528 E23A B7 4E                 lda   [seg_header_ptr],y
4529 E23C A8                    tay   
4530 E23D D0 03                 bne   @data_avail
4531 E23F 8A                    txa   
4532 E240 F0 51                 beq   @its_loaded
4533 E242              @data_avail  
4534 E242 A9 00 00              lda   #absolute
4535 E245 20 FD DA              jsr   set_mark
4536 E248 90 01                 bcc   @mark2_set
4537 E24A 60                    rts                            ;return the error
4538 E24B              @mark2_set  
4539 E24B A0 0C 00              ldy   #SegHeaderEntry.RelocDict_Length  ;now lets get the size of the segment
4540 E24E 18                    clc   
4541 E24F B7 4E                 lda   [seg_header_ptr],y
4542 E251 69 01 00              adc   #$0001
4543 E254 8D 52 A7              sta   |PRead.requestCount
4544 E257 AA                    tax   
4545 E258 C8                    iny   
4546 E259 C8                    iny   
4547 E25A B7 4E                 lda   [seg_header_ptr],y       ;get the high count
4548 E25C 69 00 00              adc   #$0000
4549 E25F 8D 54 A7              sta   |PRead.requestCount+2
4550 E262 A8                    tay   
4551 E263
4552 E263 AD 52 A7              lda   |PRead.requestCount      ;check for a zero length relocation dictionary
4553 E266 3A                    dec   a
4554 E267 0D 54 A7              ora   |PRead.requestCount+2
4555 E26A F0 27                 beq   @its_loaded
4556 E26C
4557 E26C 20 4F D0              jsr   alloc_mem                ;allocate the memory for the segment
4558 E26F 86 46                 stx   temp_handle
4559 E271 86 90                 stx   reloc_handle
4560 E273 84 48                 sty   temp_handle+2
4561 E275 84 92                 sty   reloc_handle+2
4562 E277
4563 E277 A0 2E 00              ldy   #SegHeaderEntry.RelocDict_Hndl ;save handle to relocation dictionary
4564 E27A A5 46                 lda   temp_handle
4565 E27C 97 4E                 sta   [seg_header_ptr],y
4566 E27E C8                    iny   
4567 E27F C8                    iny   
4568 E280 A5 48                 lda   temp_handle+2
4569 E282 97 4E                 sta   [seg_header_ptr],y
4570 E284
4571 E284 A0 02 00              ldy   #$0002                   ;deref the handle please
4572 E287 A7 46                 lda   [temp_handle]
4573 E289 AA                    tax   
4574 E28A B7 46                 lda   [temp_handle],y
4575 E28C A8                    tay   
4576 E28D
4577 E28D 20 D2 DA              jsr   read_wBuf_ptr            ;read in the segment please
4578 E290 90 01                 bcc   @its_loaded
4579 E292 60                    rts   
4580 E293              @its_loaded  
4581 E293 A0 02 00              ldy   #HET_Entry.SegFlags
4582 E296 B7 42                 lda   [HET_entry_ptr],y
4583 E298 09 00 80              ora   #$8000                   ;mark segment loaded
4584 E29B 97 42                 sta   [HET_entry_ptr],y
4585 E29D
4586 E29D A5 BA                 lda   seg_kind
4587 E29F 29 1F 00              and   #kind_only               ;lets see if this is a jump table segment
4588 E2A2 C9 02 00              cmp   #jmp_tbl_seg
4589 E2A5 D0 0D                 bne   @not_jump
4590 E2A7 20 C4 E2              jsr   patch_jmp_tbl            ;we need to setup the jump table entries
4591 E2AA
4592 E2AA A0 02 00              ldy   #HET_Entry.SegFlags      ;mark segment as a Jump Segment
4593 E2AD B7 42                 lda   [HET_entry_ptr],y
4594 E2AF 09 02 00              ora   #jmp_type
4595 E2B2 97 42                 sta   [HET_entry_ptr],y
4596 E2B4              @not_jump  
4597 E2B4 A5 BA                 lda   seg_kind                 ;see if the segment is dynamic or static
4598 E2B6 30 0A                 bmi   @its_dynamic
4599 E2B8 A0 02 00              ldy   #HET_Entry.SegFlags      ;set the static bit please
4600 E2BB B7 42                 lda   [HET_entry_ptr],y
4601 E2BD 09 04 00              ora   #stat_type
4602 E2C0 97 42                 sta   [HET_entry_ptr],y
4603 E2C2              @its_dynamic  
4604 E2C2 18                    clc   
4605 E2C3 60                    rts   
4606 E2C4
4607 E2C4                       entry patch_jmp_tbl
4608 E2C4              patch_jmp_tbl  
4609 E2C4 18                    clc   
4610 E2C5 A5 4A                 lda   base_ptr                 ;please point to the first segment entry
4611 E2C7 69 08 00              adc   #seg_jmp_start
4612 E2CA 85 62                 sta   temp_ptr
4613 E2CC A5 4C                 lda   base_ptr+2
4614 E2CE 69 00 00              adc   #$0000
4615 E2D1 85 64                 sta   temp_ptr+2               ;point to the first entry
4616 E2D3              @loop     
4617 E2D3 A0 02 00              ldy   #JE_FileNum              ;see if we are done
4618 E2D6 B7 62                 lda   [temp_ptr],y
4619 E2D8 F0 22                 beq   @done
4620 E2DA
4621 E2DA AD B6 A6              lda   |USERID                  ;save the ID please
4622 E2DD 87 62                 sta   [temp_ptr]
4623 E2DF
4624 E2DF A0 0A 00              ldy   #JE_jsl                  ;index to the JSL instruction
4625 E2E2 AD AF A8              lda   jump_load_instr          ;store the Jump Load Instruction
4626 E2E5 97 62                 sta   [temp_ptr],y
4627 E2E7 C8                    iny   
4628 E2E8 C8                    iny   
4629 E2E9 AD B1 A8              lda   jump_load_instr+2
4630 E2EC 97 62                 sta   [temp_ptr],y
4631 E2EE              @next_entry  
4632 E2EE 18                    clc   
4633 E2EF A5 62                 lda   temp_ptr
4634 E2F1 69 0E 00              adc   #jmp_entry_size          ;size of one entry
4635 E2F4 85 62                 sta   temp_ptr
4636 E2F6 90 DB                 bcc   @loop
4637 E2F8 E6 64                 inc   temp_ptr+2
4638 E2FA 80 D7                 bra   @loop
4639 E2FC              @done     
4640 E2FC 60                    rts   
4641 E2FD
4642 E2FD                       Entry add_segment_offset
4643 E2FD              add_segment_offset  
4644 E2FD A0 28 00              ldy   #SegHeaderEntry.Entry    ;See if this segment is the main segment
4645 E300 B7 4E                 lda   [seg_header_ptr],y
4646 E302 AA                    tax   
4647 E303 C8                    iny   
4648 E304 C8                    iny   
4649 E305 B7 4E                 lda   [seg_header_ptr],y       ;get the high word
4650 E307 A8                    tay   
4651 E308 D0 07                 bne   @seg_offset_true         ;we must override the first segment
4652 E30A 8A                    txa   
4653 E30B D0 04                 bne   @seg_offset_true
4654 E30D
4655 E30D A2 00 00              ldx   #$0000
4656 E310 9B                    txy   
4657 E311              @seg_offset_true  
4658 E311 18                    clc   
4659 E312 8A                    txa                            ;get the low word of the offset
4660 E313 65 4A                 adc   base_ptr
4661 E315 85 9C                 sta   segment_entry
4662 E317 98                    tya                            ;get the high word of the segment offset
4663 E318 65 4C                 adc   base_ptr+2
4664 E31A 85 9E                 sta   segment_entry+2
4665 E31C 60                    rts   
4666 E31D                       endp 
4667 E31D
4668 E31D                       TITLE ', ExpressLoad.a - find_Seg_name'
4669 E31D              ;====================================================================================================
4670 E31D              ;find_seg_name: This routine will locate a segment by name
4671 E31D              ;
4672 E31D              ;
4673 E31D              ;Input:         A = undefined
4674 E31D              ;               X = low word pointer to name
4675 E31D              ;               Y = high word pointer to the name
4676 E31D              ;               P = nvmxdizc
4677 E31D              ;                   ..000...
4678 E31D              ;               b = k
4679 E31D              ;
4680 E31D              ;               ExpressHandle           ;must be setup
4681 E31D              ;
4682 E31D              ;Output:        A = segment number if found
4683 E31D              ;               X = undefined
4684 E31D              ;               Y = undefined
4685 E31D              ;               P = nvmxdizc
4686 E31D              ;                   ..000..1 = segment not found
4687 E31D              ;               b = k
4688 E31D              ;
4689 E31D              ;
4690 E31D              ;====================================================================================================
4691 E31D
4692 E31D                       longa on
4693 E31D                       longi on
4694 E31D              find_seg_name proc 
4695 E31D                       with DirectPage, Globals
4696 E31D
4697 E31D 86 84                 stx   path_ptr
4698 E31F 84 86                 sty   path_ptr+2               ;segment name pointer
4699 E321
4700 E321 20 44 D2              jsr   make_HET_ptr             ;setup pointer to the Header Entry Table
4701 E324 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
4702 E326 1A                    inc   a                        ;start from the last segment
4703 E327 1A                    inc   a
4704 E328 AA                    tax   
4705 E329              @search_loop  
4706 E329 8A                    txa                            ;pass in the segment number
4707 E32A F0 10                 beq   @not_found               ;sorry there is no segment by this name
4708 E32C DA                    phx   
4709 E32D 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
4710 E330 20 41 E3              jsr   compare_names            ;see if this is the one
4711 E333 90 09                 bcc   @found_it                ;we have located the correct segment
4712 E335 FA                    plx   
4713 E336 CA                    dex                            ;back off by one and try again
4714 E337 E0 01 00              cpx   #$0001
4715 E33A D0 ED                 bne   @search_loop
4716 E33C              @not_found  
4717 E33C 38                    sec   
4718 E33D 60                    rts                            ;segment is not in ExpressLoad header
4719 E33E
4720 E33E 68           @found_it pla                           ;return the segment number
4721 E33F 18                    clc   
4722 E340 60                    rts                            ;return to the caller with the good news
4723 E341
4724 E341              compare_names  
4725 E341 18                    clc   
4726 E342 A0 2C 00              ldy   #SegHeaderEntry.DispName ;get the displacement
4727 E345 B7 4E                 lda   [seg_header_ptr],y
4728 E347 69 0E 00              adc   #SegHeaderEntry.name_overhead
4729 E34A 18                    clc   
4730 E34B 65 4E                 adc   seg_header_ptr
4731 E34D 85 62                 sta   temp_ptr
4732 E34F A9 00 00              lda   #$0000
4733 E352 65 50                 adc   seg_header_ptr+2
4734 E354 85 64                 sta   temp_ptr+2               ;temp_ptr now points to the segment name (PString)
4735 E356 A0 11 00              ldy   #SegHeaderEntry.LabLen   ;offset to label length field in header
4736 E359 B7 4E                 lda   [seg_header_ptr],y       ;get the value
4737 E35B 29 FF 00              and   #$00ff                   ;it's only a byte wide
4738 E35E F0 0E                 beq   @is_length               ;length is first byte of string (Pascal style)
4739 E360 A4 62                 ldy   temp_ptr                 ;else decrement the string pointer
4740 E362 D0 02                 bne   @only_low
4741 E364 C6 64                 dec   temp_ptr+2
4742 E366              @only_low  
4743 E366 C6 62                 dec   temp_ptr
4744 E368 E2 20                 sep   #$20                     ;8-bit store here
4745 E36A 87 62                 sta   [temp_ptr]               ;store the string length (from lablen)
4746 E36C C2 20                 rep   #$20
4747 E36E
4748 E36E              @is_length  
4749 E36E                       longa off
4750 E36E                       longi off
4751 E36E E2 30                 sep   #$30
4752 E370 A7 84                 lda   [path_ptr]               ;get the length of the input name
4753 E372 A8                    tay   
4754 E373 C7 62                 cmp   [temp_ptr]
4755 E375 D0 0D                 bne   @not_it                  ;the length is not the same
4756 E377
4757 E377              @compare_loop  
4758 E377 B7 62                 lda   [temp_ptr],y             ;get the character
4759 E379 D7 84                 cmp   [path_ptr],y             ;same as supplied?
4760 E37B D0 07                 bne   @not_it                  ;nope!
4761 E37D              @check_next  
4762 E37D 88                    dey   
4763 E37E D0 F7                 bne   @compare_loop            ;keep looking
4764 E380 C2 30                 rep   #$30
4765 E382 18                    clc   
4766 E383 60                    rts                            ;We have found the segment!
4767 E384
4768 E384              @not_it   
4769 E384 C2 30                 rep   #$30
4770 E386 38                    sec   
4771 E387 60                    rts   
4772 E388
4773 E388                       endp 
4774 E388
4775 E388                       TITLE ', ExpressLoad.a - save_dp_info'
4776 E388              ;====================================================================================================
4777 E388              ;save_dp_info:  This routine will save the direct page address
4778 E388              ;
4779 E388              ;
4780 E388              ;Input:         A = undefined
4781 E388              ;               X = undefined
4782 E388              ;               Y = undefined
4783 E388              ;               P = nvmxdizc
4784 E388              ;                   ..000...
4785 E388              ;               b = k
4786 E388              ;
4787 E388              ;
4788 E388              ;Output:        A = undefined
4789 E388              ;               X = undefined
4790 E388              ;               Y = undefined
4791 E388              ;               P = nvmxdizc
4792 E388              ;                   ..000...
4793 E388              ;               b = k
4794 E388              ;
4795 E388              ;
4796 E388              ;====================================================================================================
4797 E388
4798 E388                       longa on
4799 E388                       longi on
4800 E388              save_dp_info proc 
4801 E388                       with DirectPage, Globals
4802 E388
4803 E388 A5 9C                 lda   segment_entry            ;address of the stack direct page
4804 E38A 85 DA                 sta   stack_addr
4805 E38C A5 B6                 lda   LConst_Size              ;save the size please
4806 E38E 85 DC                 sta   stack_size
4807 E390 60                    rts   
4808 E391
4809 E391                       endp 
4810 E391
4811 E391                       TITLE ', ExpressLoad.a - load_statics'
4812 E391              ;====================================================================================================
4813 E391              ;load_statics:  This routine will load all static segments
4814 E391              ;
4815 E391              ;
4816 E391              ;Input:         A = undefined
4817 E391              ;               X = undefined
4818 E391              ;               Y = undefined
4819 E391              ;               P = nvmxdizc
4820 E391              ;                   ..000...
4821 E391              ;               b = k
4822 E391              ;
4823 E391              ;               HET_ptr                 ;must be setup
4824 E391              ;
4825 E391              ;Output:        A = undefined
4826 E391              ;               X = undefined
4827 E391              ;               Y = undefined
4828 E391              ;               P = nvmxdizc
4829 E391              ;                   ..000...
4830 E391              ;               b = k
4831 E391              ;
4832 E391              ;
4833 E391              ;====================================================================================================
4834 E391
4835 E391                       longa on
4836 E391                       longi on
4837 E391              load_statics proc 
4838 E391                       with DirectPage, Globals
4839 E391
4840 E391 BA                    tsx                            ;save the stack pointer
4841 E392 86 CC                 stx   stack
4842 E394
4843 E394 9C A6 A6              stz   starting_addr
4844 E397 9C A8 A6              stz   starting_addr+2
4845 E39A 64 DA                 stz   stack_addr               ;there is no stack
4846 E39C 64 DC                 stz   stack_size
4847 E39E
4848 E39E              static_loop  
4849 E39E A9 00 00              lda   #any_kind                ;lets find all static segments that are left
4850 E3A1 A2 00 80              ldx   #static_only             ;don't look at other bits
4851 E3A4 A0 00 80              ldy   #unloaded_state          ;skip loaded segments
4852 E3A7 20 99 DB              jsr   find_Segment             ;do the search
4853 E3AA 90 02                 bcc   @another_seg
4854 E3AC 18                    clc   
4855 E3AD 60           @oops    rts                            ;return with no error
4856 E3AE
4857 E3AE              @another_seg  
4858 E3AE 20 75 E1              jsr   load_segment             ;load the segment into memory
4859 E3B1 B0 FA                 bcs   @oops
4860 E3B3 A0 18 00              ldy   #SegHeaderEntry.Kind     ;lets see if this is a Stack/Direct Page segment
4861 E3B6 B7 4E                 lda   [seg_header_ptr],y       ;If it is then save the correct Info.
4862 E3B8 29 1F 00              and   #kind_only
4863 E3BB C9 12 00              cmp   #dp_seg_type             ;lets find the stack seg please
4864 E3BE D0 05                 bne   @not_stack
4865 E3C0
4866 E3C0 20 88 E3              jsr   save_dp_info             ;save stack and Direct page info
4867 E3C3 80 17                 bra   not_first                ;even if it is skip it please
4868 E3C5
4869 E3C5 C9 10 00     @not_stack cmp   #init_seg_type         ;is this an initilization segment?
4870 E3C8 F0 21                 beq   run_init_seg             ;go ahead and run the segment
4871 E3CA
4872 E3CA AD A6 A6              lda   starting_addr
4873 E3CD 0D A8 A6              ora   starting_addr+2
4874 E3D0 D0 0A                 bne   not_first                ;this is not the first segment
4875 E3D2              ;
4876 E3D2              ;If this is the first segment then save it's starting address so we can return it to the caller
4877 E3D2              ;
4878 E3D2 A5 9C                 lda   segment_entry
4879 E3D4 8D A6 A6              sta   starting_addr            ;save the starting address that we will jump to
4880 E3D7 A5 9E                 lda   segment_entry+2
4881 E3D9 8D A8 A6              sta   starting_addr+2
4882 E3DC              not_first  
4883 E3DC A5 C4                 lda   loaded_seg_num           ;save the seg number
4884 E3DE 48                    pha   
4885 E3DF 20 9E E3              jsr   static_loop
4886 E3E2 B0 1D                 bcs   fix_stack_abort          ;exit if an error occurred
4887 E3E4 68                    pla   
4888 E3E5 20 05 D6              jsr   Process_Reloc
4889 E3E8 B0 17                 bcs   fix_stack_abort          ;mjor problems
4890 E3EA 60                    rts   
4891 E3EB
4892 E3EB              run_init_seg  
4893 E3EB A5 C4                 lda   loaded_seg_num           ;the init segment we just loaded!
4894 E3ED 20 05 D6              jsr   Process_Reloc
4895 E3F0 B0 0F                 bcs   fix_stack_abort          ;exit with the error
4896 E3F2
4897 E3F2 20 62 BA              jsr   lock_handles
4898 E3F5 A5 9C                 lda   segment_entry            ;address of the segment just loaded
4899 E3F7 A4 9E                 ldy   segment_entry+2
4900 E3F9 20 4A E9              jsr   Do_Init_Segment
4901 E3FC 20 CB BA              jsr   unlock_handles
4902 E3FF 80 9D                 bra   static_loop              ;load any other init segs please
4903 E401
4904 E401              fix_stack_abort  
4905 E401 A6 CC                 ldx   stack
4906 E403 9A                    txs                            ;restore the stack pointer please
4907 E404 60                    rts                            ;return the error to the caller
4908 E405                       endp 
4909 E405
4910 E405                       TITLE ', ExpressLoad.a - save_start'
4911 E405              ;====================================================================================================
4912 E405              ;save_start:    This routine will save the starting address and stack info in the user_id_table
4913 E405              ;
4914 E405              ;Input:         A = undefined
4915 E405              ;               X = undefined
4916 E405              ;               Y = undefined
4917 E405              ;               P = nvmxdizc
4918 E405              ;                   ..000...
4919 E405              ;               b = k
4920 E405              ;
4921 E405              ;               user_id_ptr
4922 E405              ;
4923 E405              ;Output:        A = undefined
4924 E405              ;               X = undefined
4925 E405              ;               Y = undefined
4926 E405              ;               P = nvmxdizc
4927 E405              ;                   ..000..1 = error
4928 E405              ;               b = k
4929 E405              ;
4930 E405              ;
4931 E405              ;====================================================================================================
4932 E405
4933 E405                       longa on
4934 E405                       longi on
4935 E405              save_start proc 
4936 E405                       with DirectPage, Globals
4937 E405
4938 E405 A0 06 00              ldy   #ID_Table_Entry.Stack_Addr ;save the address of the stack/direct page
4939 E408 A5 DA                 lda   stack_addr
4940 E40A 97 7C                 sta   [user_id_ptr],y
4941 E40C A0 08 00              ldy   #ID_Table_Entry.Stack_Size ;also save the size
4942 E40F A5 DC                 lda   stack_size
4943 E411 97 7C                 sta   [user_id_ptr],y
4944 E413 A0 0A 00              ldy   #ID_Table_Entry.Start_Addr
4945 E416 AD A6 A6              lda   starting_addr            ;save the starting address of the application
4946 E419 97 7C                 sta   [user_id_ptr],y
4947 E41B C8                    iny   
4948 E41C C8                    iny   
4949 E41D AD A8 A6              lda   starting_addr+2
4950 E420 97 7C                 sta   [user_id_ptr],y
4951 E422 18                    clc   
4952 E423 60                    rts   
4953 E424                       entry restore_start
4954 E424              restore_start  
4955 E424
4956 E424 A0 06 00              ldy   #ID_Table_Entry.Stack_Addr ;get the address of the stack/direct page
4957 E427 B7 7C                 lda   [user_id_ptr],y
4958 E429 85 DA                 sta   stack_addr
4959 E42B A0 08 00              ldy   #ID_Table_Entry.Stack_Size ;get save the size
4960 E42E B7 7C                 lda   [user_id_ptr],y
4961 E430 85 DC                 sta   stack_size
4962 E432 A0 0A 00              ldy   #ID_Table_Entry.Start_Addr
4963 E435 B7 7C                 lda   [user_id_ptr],y
4964 E437 8D A6 A6              sta   starting_addr
4965 E43A C8                    iny   
4966 E43B C8                    iny   
4967 E43C B7 7C                 lda   [user_id_ptr],y
4968 E43E 8D A8 A6              sta   starting_addr+2
4969 E441 18                    clc   
4970 E442 60                    rts   
4971 E443                       endp 
4972 E443
4973 E443                       TITLE ', ExpressLoad.a - reload_restart'
4974 E443              ;====================================================================================================
4975 E443              ;reload_restart:        This routine will scan the ExpressLoad segment looking for a restart segment
4976 E443              ;               If any are found they will be loaded into the same address as they were before.
4977 E443              ;
4978 E443              ;Input:         A = undefined
4979 E443              ;               X = undefined
4980 E443              ;               Y = undefined
4981 E443              ;               P = nvmxdizc
4982 E443              ;                   ..000...
4983 E443              ;               b = k
4984 E443              ;
4985 E443              ;               ExpressHandle
4986 E443              ;
4987 E443              ;Output:        A = undefined
4988 E443              ;               X = undefined
4989 E443              ;               Y = undefined
4990 E443              ;               P = nvmxdizc
4991 E443              ;                   ..000..1 = error
4992 E443              ;               b = k
4993 E443              ;
4994 E443              ;
4995 E443              ;====================================================================================================
4996 E443
4997 E443                       longa on
4998 E443                       longi on
4999 E443              reload_restart proc 
5000 E443                       with DirectPage, Globals
5001 E443 20 44 D2              jsr   make_HET_ptr
5002 E446
5003 E446 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
5004 E448 1A                    inc   a                        ;start from the last segment
5005 E449 1A                    inc   a
5006 E44A AA                    tax   
5007 E44B              @search_loop  
5008 E44B 8A                    txa                            ;pass in the segment number
5009 E44C F0 12                 beq   @end_restarts            ;sorry there is no segment
5010 E44E DA                    phx   
5011 E44F 85 C4                 sta   loaded_seg_num
5012 E451 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
5013 E454 20 62 E4              jsr   do_restarts
5014 E457              @skip_it  
5015 E457 FA                    plx   
5016 E458 B0 07                 bcs   @restart_error
5017 E45A CA                    dex                            ;back off by one and try again
5018 E45B E0 01 00              cpx   #$0001
5019 E45E D0 EB                 bne   @search_loop
5020 E460              @end_restarts  
5021 E460 18                    clc   
5022 E461              @restart_error  
5023 E461 60                    rts   
5024 E462
5025 E462              do_restarts  
5026 E462 A0 18 00              ldy   #SegHeaderEntry.Kind
5027 E465 B7 4E                 lda   [seg_header_ptr],y       ;get the segment kind field to determine if this
5028 E467 29 00 04              and   #Reload_Segment          ;segment needs to be reloaded.
5029 E46A F0 03                 beq   @not_reload
5030 E46C 20 71 E4              jsr   load_restart             ;major pain in the butt!
5031 E46F              @not_reload  
5032 E46F 18                    clc   
5033 E470 60                    rts   
5034 E471
5035 E471              load_restart  
5036 E471 A5 B4                 lda   file_open                ;is the file already open?
5037 E473 D0 05                 bne   @skip_open               ;someone has already opened the file
5038 E475
5039 E475 20 69 DD              jsr   open_load_file           ;open the file please
5040 E478 B0 0A                 bcs   @load_exit
5041 E47A              @skip_open  
5042 E47A 20 75 E1              jsr   load_segment             ;load the segment into memory
5043 E47D B0 05                 bcs   @load_exit               ;bad news
5044 E47F A5 C4                 lda   loaded_seg_num           ;now relocate the segment
5045 E481 20 05 D6              jsr   Process_Reloc            ;process the segment
5046 E484              @load_exit  
5047 E484 60                    rts   
5048 E485
5049 E485                       endp 
5050 E485
5051 E485                       TITLE ', ExpressLoad.a - reload_inits'
5052 E485              ;====================================================================================================
5053 E485              ;reload_inits:  This routine will scan the ExpressLoad segment looking for init segments.  If it finds
5054 E485              ;               an init segment it will pass control to that segment
5055 E485              ;
5056 E485              ;Input:         A = undefined
5057 E485              ;               X = undefined
5058 E485              ;               Y = undefined
5059 E485              ;               P = nvmxdizc
5060 E485              ;                   ..000...
5061 E485              ;               b = k
5062 E485              ;
5063 E485              ;               ExpressHandle
5064 E485              ;
5065 E485              ;Output:        A = undefined
5066 E485              ;               X = undefined
5067 E485              ;               Y = undefined
5068 E485              ;               P = nvmxdizc
5069 E485              ;                   ..000..1 = error
5070 E485              ;               b = k
5071 E485              ;
5072 E485              ;
5073 E485              ;====================================================================================================
5074 E485
5075 E485                       longa on
5076 E485                       longi on
5077 E485              reload_inits proc 
5078 E485                       with DirectPage, Globals
5079 E485 20 44 D2              jsr   make_HET_ptr
5080 E488
5081 E488 A7 3E                 lda   [HET_ptr]                ;get the number of entries in table
5082 E48A 1A                    inc   a                        ;start from the last segment
5083 E48B 1A                    inc   a
5084 E48C AA                    tax   
5085 E48D              @search_loop  
5086 E48D 8A                    txa                            ;pass in the segment number
5087 E48E F0 12                 beq   @end_inits               ;sorry there is no segment
5088 E490 DA                    phx   
5089 E491 85 C4                 sta   loaded_seg_num
5090 E493 20 5E D2              jsr   setup_seg_ptrs           ;we are now in business
5091 E496 20 A4 E4              jsr   do_inits
5092 E499              @skip_it  
5093 E499 FA                    plx   
5094 E49A B0 07                 bcs   @init_error
5095 E49C CA                    dex                            ;back off by one and try again
5096 E49D E0 01 00              cpx   #$0001
5097 E4A0 D0 EB                 bne   @search_loop
5098 E4A2              @end_inits  
5099 E4A2 18                    clc   
5100 E4A3              @init_error  
5101 E4A3 60                    rts   
5102 E4A4
5103 E4A4              do_inits  
5104 E4A4 A0 18 00              ldy   #SegHeaderEntry.Kind
5105 E4A7 B7 4E                 lda   [seg_header_ptr],y       ;get the segment kind field to determine if this
5106 E4A9 29 1F 00              and   #kind_only
5107 E4AC C9 10 00              cmp   #init_seg_type
5108 E4AF F0 02                 beq   @do_init_type
5109 E4B1 18                    clc   
5110 E4B2 60                    rts   
5111 E4B3              @do_init_type  
5112 E4B3 A0 04 00              ldy   #HET_Entry.SegHandle     ;get the handle to the segment
5113 E4B6 B7 42                 lda   [HET_entry_ptr],y
5114 E4B8 AA                    tax   
5115 E4B9 C8                    iny   
5116 E4BA C8                    iny   
5117 E4BB B7 42                 lda   [HET_entry_ptr],y
5118 E4BD A8                    tay   
5119 E4BE D0 05                 bne   @have_handle
5120 E4C0 AA                    tax   
5121 E4C1 D0 02                 bne   @have_handle
5122 E4C3 38                    sec   
5123 E4C4 60                    rts                            ;return the handle
5124 E4C5              @have_handle  
5125 E4C5 86 46                 stx   temp_handle
5126 E4C7 84 48                 sty   temp_handle+2
5127 E4C9 A0 01 00              ldy   #$0001
5128 E4CC A7 46                 lda   [temp_handle]
5129 E4CE 8D E0 E4              sta   self_mod+1
5130 E4D1 B7 46                 lda   [temp_handle],y
5131 E4D3 8D E1 E4              sta   self_mod+2
5132 E4D6 20 62 BA              jsr   lock_handles
5133 E4D9
5134 E4D9 7B                    tdc                            ;save my direct page
5135 E4DA 48                    pha   
5136 E4DB A9 00 00              lda   #$0000
5137 E4DE 5B                    tcd                            ;set direct register to real zero page
5138 E4DF 22 00 00 00  self_mod jsl   >$000000
5139 E4E3 C2 30                 rep   #$30                     ;restore 16 bit mode
5140 E4E5 68                    pla                            ;restore direct register
5141 E4E6 5B                    tcd   
5142 E4E7 4B                    phk   
5143 E4E8 AB                    plb   
5144 E4E9 20 CB BA              jsr   unlock_handles
5145 E4EC 18                    clc   
5146 E4ED 60                    rts   
5147 E4EE                       endp 
5148 E4EE
5149 E4EE                       TITLE ', ExpressLoad.a - zero_handles'
5150 E4EE              ;====================================================================================================
5151 E4EE              ;zero_handles:  Zero handles to indicate that there is no segment
5152 E4EE              ;
5153 E4EE              ;Input:         A = undefined
5154 E4EE              ;               X = undefined
5155 E4EE              ;               Y = undefined
5156 E4EE              ;               P = nvmxdizc
5157 E4EE              ;                   ..000...
5158 E4EE              ;               b = ?
5159 E4EE              ;
5160 E4EE              ;
5161 E4EE              ;Output:        A = undefined
5162 E4EE              ;               X = undefined
5163 E4EE              ;               Y = undefined
5164 E4EE              ;               P = nvmxdizc
5165 E4EE              ;                   ..000...
5166 E4EE              ;               b = k
5167 E4EE              ;
5168 E4EE              ;
5169 E4EE              ;====================================================================================================
5170 E4EE
5171 E4EE                       longa on
5172 E4EE                       longi on
5173 E4EE              zero_handles proc 
5174 E4EE                       with DirectPage
5175 E4EE
5176 E4EE              ;
5177 E4EE              ;We now zero the handles that do not live across calls.  We do this so we can
5178 E4EE              ;lock the handles when we make memory manager calls
5179 E4EE              ;
5180 E4EE 64 88                 stz   ExpressHandle            ;zero the handles please
5181 E4F0 64 8A                 stz   ExpressHandle+2
5182 E4F2 64 46                 stz   temp_handle              ;zero any temp handles hanging around
5183 E4F4 64 48                 stz   temp_handle+2
5184 E4F6 64 90                 stz   reloc_handle             ;this handle does not live across calls
5185 E4F8 64 92                 stz   reloc_handle+2
5186 E4FA 64 94                 stz   seg_handle
5187 E4FC 64 96                 stz   seg_handle+2             ;this handles do not live across calls
5188 E4FE 64 98                 stz   curr_id_handle
5189 E500 64 9A                 stz   curr_id_handle+2
5190 E502 60                    rts   
5191 E503                       endp 
5192 E503
5193 E503                       TITLE ', ExpressLoad.a - rename_segments'
5194 E503              ;====================================================================================================
5195 E503              ;rename_segments:       This routine will rename paths for ExpressLoad
5196 E503              ;
5197 E503              ;Input:         A = undefined
5198 E503              ;               X = undefined
5199 E503              ;               Y = undefined
5200 E503              ;               P = nvmxdizc
5201 E503              ;                   ..000...
5202 E503              ;               b = k
5203 E503              ;
5204 E503              ;Output:        A = User ID
5205 E503              ;               X = undefined
5206 E503              ;               Y =undefined
5207 E503              ;               P = nvmxdizc
5208 E503              ;                   ..000..1 = not found
5209 E503              ;               b = k
5210 E503              ;
5211 E503              ;
5212 E503              ;====================================================================================================
5213 E503
5214 E503                       longa on
5215 E503                       longi on
5216 E503              rename_segments proc 
5217 E503                       with DirectPage, Globals
5218 E503
5219 E503              newAddr  EQU   input_parms
5220 E503              oldAddr  EQU   newAddr+4
5221 E503
5222 E503 A6 78                 ldx   user_id_handle
5223 E505 A4 7A                 ldy   user_id_handle+2
5224 E507              @keep_going  
5225 E507 86 46                 stx   temp_handle
5226 E509 84 48                 sty   temp_handle+2
5227 E50B
5228 E50B A0 02 00              ldy   #$0002
5229 E50E A7 46                 lda   [temp_handle]
5230 E510 85 7C                 sta   user_id_ptr              ;point to the next user_id table
5231 E512 B7 46                 lda   [temp_handle],y
5232 E514 85 7E                 sta   user_id_ptr+2
5233 E516
5234 E516 A0 04 00              ldy   #$0004                   ;lock the handle
5235 E519 B7 46                 lda   [temp_handle],y
5236 E51B 09 00 80              ora   #$8000
5237 E51E 97 46                 sta   [temp_handle],y
5238 E520
5239 E520 20 3C E5              jsr   do_rename                ;rename all files in this user_id chunk
5240 E523
5241 E523 A0 04 00              ldy   #$0004                   ;unlock the handle
5242 E526 B7 46                 lda   [temp_handle],y
5243 E528 29 FF 7F              and   #$7FFF
5244 E52B 97 46                 sta   [temp_handle],y
5245 E52D
5246 E52D A0 02 00              ldy   #User_ID_Table.Next+2    ;get the next link
5247 E530 A7 7C                 lda   [user_id_ptr]
5248 E532 AA                    tax   
5249 E533 B7 7C                 lda   [user_id_ptr],y
5250 E535 A8                    tay   
5251 E536 D0 CF                 bne   @keep_going
5252 E538 8A                    txa   
5253 E539 D0 CC                 bne   @keep_going
5254 E53B 60                    rts                            ;we are done
5255 E53C
5256 E53C              do_rename  
5257 E53C A0 10 00              ldy   #id_entry_size           ;start at the first available spot
5258 E53F A2 7E 00              ldx   #id_entry_cnt            ;number of entries in a table
5259 E542              @rename_loop  
5260 E542 B7 7C                 lda   [user_id_ptr],y          ;get a user_id
5261 E544 F0 07                 beq   @empty_slot
5262 E546 5A                    phy   
5263 E547 DA                    phx   
5264 E548 20 58 E5              jsr   check_and_rename         ;rename if needed
5265 E54B FA                    plx   
5266 E54C 7A                    ply   
5267 E54D              @empty_slot  
5268 E54D 18                    clc   
5269 E54E 98                    tya   
5270 E54F 69 10 00              adc   #id_entry_size
5271 E552 A8                    tay   
5272 E553 CA                    dex   
5273 E554 10 EC                 bpl   @rename_loop
5274 E556 18                    clc   
5275 E557 60                    rts   
5276 E558
5277 E558              ;====================================================================================================
5278 E558              ;Rename the segment if needed
5279 E558              ;====================================================================================================
5280 E558              check_and_rename  
5281 E558                       Import MemMove
5282 E558
5283 E558 C8                    iny   
5284 E559 C8                    iny                            ;get the ExpressHandle
5285 E55A B7 7C                 lda   [user_id_ptr],y
5286 E55C AA                    tax   
5287 E55D C8                    iny   
5288 E55E C8                    iny   
5289 E55F B7 7C                 lda   [user_id_ptr],y
5290 E561 A8                    tay   
5291 E562 20 46 D3              jsr   merge_path               ;build a complete pathname
5292 E565 20 D3 D2              jsr   compare_paths            ;is this the one?
5293 E568 B0 35                 bcs   @no_match                ;yup
5294 E56A
5295 E56A 08                    php                            ;save partial/full match status
5296 E56B A5 88                 lda   ExpressHandle            ;copy ExpressHandle into generic variable
5297 E56D 85 08                 sta   Handle
5298 E56F A5 8A                 lda   ExpressHandle+2
5299 E571 85 0A                 sta   Handle+2
5300 E573
5301 E573 A7 E0                 lda   [newAddr]                ;get the length of the new name
5302 E575 38                    sec   
5303 E576 E7 E4                 sbc   [oldAddr]                ;calculate difference (may be negative)
5304 E578 F0 21                 beq   @no_size_change          ;if same length, no adjustment necessary
5305 E57A 20 EE E5              jsr   adjust_handle_size       ;change the size of the Express Segment buffer
5306 E57D B0 20                 bcs   @no_match                ;just punt if we get an error
5307 E57F A0 02 00              ldy   #2                       ;deref Handle
5308 E582 A7 08                 lda   [Handle]
5309 E584 85 00                 sta   TempZero
5310 E586 B7 08                 lda   [Handle],y
5311 E588 85 02                 sta   TempZero+2
5312 E58A
5313 E58A A0 02 00              ldy   #ExpressloadSeg.PathnameOffset
5314 E58D 18                    clc   
5315 E58E B7 00                 lda   [TempZero],y
5316 E590 65 00                 adc   TempZero                 ;offset to position of pathname within segment
5317 E592 85 CE                 sta   PathnamePtr
5318 E594 A5 02                 lda   TempZero+2
5319 E596 69 00 00              adc   #0
5320 E599 85 D0                 sta   PathnamePtr+2
5321 E59B              @no_size_change  
5322 E59B 28                    plp                            ;retrieve complete/partial match status
5323 E59C 20 A0 E5              jsr   change_pathname          ;go make the change
5324 E59F              @no_match  
5325 E59F 60                    rts                            ;else we're done with this one
5326 E5A0
5327 E5A0                       entry change_pathname
5328 E5A0              change_pathname  
5329 E5A0 08                    php                            ;save overflow flag
5330 E5A1 70 27                 bvs   @full_match              ;complete match, go move the new name in
5331 E5A3              @partial_match  
5332 E5A3 A7 E4                 lda   [oldAddr]                ;get length of matching portion of name
5333 E5A5 1A                    inc   a                        ;adjust for leading length word
5334 E5A6 1A                    inc   a
5335 E5A7 18                    clc   
5336 E5A8 65 CE                 adc   PathnamePtr              ;calculate address of remainder of name
5337 E5AA AA                    tax   
5338 E5AB A5 D0                 lda   PathnamePtr+2
5339 E5AD 69 00 00              adc   #0
5340 E5B0 48                    pha                            ;put source pointer on stack
5341 E5B1 DA                    phx   
5342 E5B2
5343 E5B2 A7 E0                 lda   [newAddr]                ;get length of new name
5344 E5B4 1A                    inc   a                        ;adjust for leading length word
5345 E5B5 1A                    inc   a
5346 E5B6 18                    clc   
5347 E5B7 65 CE                 adc   PathnamePtr              ;calculate address of destination
5348 E5B9 AA                    tax   
5349 E5BA A5 D0                 lda   PathnamePtr+2
5350 E5BC 69 00 00              adc   #0
5351 E5BF 48                    pha                            ;put destination pointer on stack
5352 E5C0 DA                    phx   
5353 E5C1
5354 E5C1 A7 CE                 lda   [PathnamePtr]            ;get length of Express segment name
5355 E5C3 38                    sec   
5356 E5C4 E7 E4                 sbc   [oldAddr]                ;calculate length of remainder of name
5357 E5C6 48                    pha   
5358 E5C7 20 7A FA              jsr   MemMove                  ;move the unchanging portion of name in
5359 E5CA
5360 E5CA              @full_match  
5361 E5CA A7 CE                 lda   [PathnamePtr]            ;get length of original name
5362 E5CC 48                    pha                            ;save on stack for a bit
5363 E5CD
5364 E5CD D4 E2                 pei   newAddr+2                ;source pointer
5365 E5CF D4 E0                 pei   newAddr
5366 E5D1 D4 D0                 pei   PathnamePtr+2            ;destination address
5367 E5D3 D4 CE                 pei   PathnamePtr
5368 E5D5 A7 E0                 lda   [newAddr]
5369 E5D7 1A                    inc   a                        ;adjust for leading length word
5370 E5D8 1A                    inc   a
5371 E5D9 48                    pha   
5372 E5DA 20 7A FA              jsr   MemMove                  ;move the new name in
5373 E5DD
5374 E5DD 68                    pla                            ;retrieve original length
5375 E5DE
5376 E5DE 28                    plp                            ;complete or partial match?
5377 E5DF 70 0C                 bvs   @done                    ;complete, so we're done
5378 E5E1 87 CE                 sta   [PathnamePtr]            ;save here for a bit
5379 E5E3 A7 E0                 lda   [newAddr]                ;calculate difference in size
5380 E5E5 38                    sec   
5381 E5E6 E7 E4                 sbc   [oldAddr]
5382 E5E8 18                    clc                            ;calculate new length
5383 E5E9 67 CE                 adc   [PathnamePtr]
5384 E5EB 87 CE                 sta   [PathnamePtr]            ;set new length
5385 E5ED              @done     
5386 E5ED 60                    rts                            ;we're done with this name
5387 E5EE
5388 E5EE              ;====================================================================================================
5389 E5EE              ;
5390 E5EE              ;This routine will resize the ExpressLoad handle as needed
5391 E5EE              ;
5392 E5EE              ;====================================================================================================
5393 E5EE                       entry adjust_handle_size
5394 E5EE              adjust_handle_size  
5395 E5EE
5396 E5EE 48                    pha                            ;save the amount of change
5397 E5EF
5398 E5EF A9 00 00              lda   #$0000
5399 E5F2 48                    pha   
5400 E5F3 48                    pha   
5401 E5F4 D4 0A                 pei   Handle+2                 ;push the high word of the handle
5402 E5F6 D4 08                 pei   Handle
5403 E5F8 A2 02 18 22           _GetHandleSize 
5404 E5FF
5405 E5FF A2 00 00              ldx   #0                       ;init high word of difference
5406 E602 A3 05                 lda   5,s                      ;get difference value
5407 E604 10 01                 bpl   @enlarge                 ;if positive, must grow the segment
5408 E606 CA                    dex                            ;else sign extend the high word
5409 E607              @enlarge  
5410 E607 18                    clc   
5411 E608 63 01                 adc   1,s                      ;calculate the new size
5412 E60A A8                    tay                            ;save here for a second
5413 E60B 8A                    txa                            ;do high word
5414 E60C 63 03                 adc   3,s
5415 E60E 83 05                 sta   5,s                      ;save the value back on the stack
5416 E610 68                    pla                            ;remove old size
5417 E611 68                    pla   
5418 E612 5A                    phy                            ;and put low word of new size on stack
5419 E613
5420 E613 D4 0A                 pei   Handle+2
5421 E615 D4 08                 pei   Handle
5422 E617 A2 02 22 22           _HUnlock                       ;unlock the handle
5423 E61E
5424 E61E              ; new size is already on stack
5425 E61E D4 0A                 pei   Handle+2
5426 E620 D4 08                 pei   Handle
5427 E622 A2 02 19 22           _SetHandleSize                 ;SetHandle size for ExpressLoad segment
5428 E629 60                    rts   
5429 E62A
5430 E62A                       endp 
